/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import org.apache.commons.math.distribution.BinomialDistribution;
import org.apache.commons.math.distribution.CauchyDistribution;
import org.apache.commons.math.distribution.CauchyDistributionImpl;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.DistributionFactoryImpl;
import org.apache.commons.math.distribution.ExponentialDistribution;
import org.apache.commons.math.distribution.FDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.distribution.HypergeometricDistribution;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.distribution.PascalDistribution;
import org.apache.commons.math.distribution.PascalDistributionImpl;
import org.apache.commons.math.distribution.PoissonDistribution;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.distribution.WeibullDistribution;
import org.apache.commons.math.distribution.WeibullDistributionImpl;

public abstract class DistributionFactory {
    protected DistributionFactory() {
    }

    public static DistributionFactory newInstance() {
        return new DistributionFactoryImpl();
    }

    public abstract BinomialDistribution createBinomialDistribution(int var1, double var2);

    public PascalDistribution createPascalDistribution(int numberOfSuccesses, double probabilityOfSuccess) {
        return new PascalDistributionImpl(numberOfSuccesses, probabilityOfSuccess);
    }

    public CauchyDistribution createCauchyDistribution(double median, double scale) {
        return new CauchyDistributionImpl(median, scale);
    }

    public abstract ChiSquaredDistribution createChiSquareDistribution(double var1);

    public abstract ExponentialDistribution createExponentialDistribution(double var1);

    public abstract FDistribution createFDistribution(double var1, double var3);

    public abstract GammaDistribution createGammaDistribution(double var1, double var3);

    public abstract TDistribution createTDistribution(double var1);

    public abstract HypergeometricDistribution createHypergeometricDistribution(int var1, int var2, int var3);

    public abstract NormalDistribution createNormalDistribution(double var1, double var3);

    public abstract NormalDistribution createNormalDistribution();

    public abstract PoissonDistribution createPoissonDistribution(double var1);

    public WeibullDistribution createWeibullDistribution(double alpha, double beta) {
        return new WeibullDistributionImpl(alpha, beta);
    }
}

