/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips.internal;

import java.util.List;
import net.sf.paperclips.internal.NullUtil;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static int[] defensiveCopy(int[] array) {
        NullUtil.notNull(array);
        return (int[])array.clone();
    }

    public static int[][] defensiveCopy(int[][] array) {
        NullUtil.notNull(array);
        int[][] result = (int[][])array.clone();
        int i = 0;
        while (i < result.length) {
            result[i] = ArrayUtil.defensiveCopy(result[i]);
            ++i;
        }
        return result;
    }

    public static int sum(int[] array) {
        return ArrayUtil.sum(array, 0, array.length);
    }

    public static int sum(int[] array, int start, int count) {
        NullUtil.notNull(array);
        int result = 0;
        int end = start + count;
        int i = start;
        while (i < end) {
            result += array[i];
            ++i;
        }
        return result;
    }

    public static int sumByIndex(int[] array, int[] indices) {
        NullUtil.notNull(array);
        int result = 0;
        int i = 0;
        while (i < indices.length) {
            result += array[indices[i]];
            ++i;
        }
        return result;
    }

    public static int[] toPrimitiveIntArray(List list) {
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (Integer)list.get(i);
            ++i;
        }
        return array;
    }

    public static int[][] toPrimitiveIntIntArray(List list) {
        int[][] array = new int[list.size()][];
        int i = 0;
        while (i < array.length) {
            array[i] = (int[])list.get(i);
            ++i;
        }
        return array;
    }
}

