/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.TextPrint;
import net.sf.paperclips.internal.BitUtil;
import net.sf.paperclips.internal.GraphicsUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class TextStyle {
    private FontData fontData;
    private RGB foreground;
    private RGB background;
    private int alignment;
    private boolean underline;
    private boolean strikeout;

    public TextStyle() {
        this.fontData = TextPrint.DEFAULT_FONT_DATA;
        this.foreground = new RGB(0, 0, 0);
        this.background = null;
        this.alignment = 16384;
        this.underline = false;
        this.strikeout = false;
    }

    private TextStyle(TextStyle that) {
        this.fontData = that.fontData;
        this.foreground = that.foreground;
        this.background = that.background;
        this.alignment = that.alignment;
        this.underline = that.underline;
        this.strikeout = that.strikeout;
    }

    private TextStyle internalFont(FontData fontData) {
        TextStyle result = new TextStyle(this);
        result.fontData = fontData;
        return result;
    }

    public TextStyle font(String name, int height, int style) {
        return this.internalFont(new FontData(name, height, style));
    }

    public TextStyle font(FontData fontData) {
        return this.internalFont(GraphicsUtil.defensiveCopy(fontData));
    }

    public TextStyle fontName(String name) {
        return this.font(name, this.fontData.getHeight(), this.fontData.getStyle());
    }

    public TextStyle fontHeight(int height) {
        return this.font(this.fontData.getName(), height, this.fontData.getStyle());
    }

    public TextStyle fontStyle(int style) {
        return this.font(this.fontData.getName(), this.fontData.getHeight(), style);
    }

    private TextStyle internalForeground(RGB foreground) {
        TextStyle result = new TextStyle(this);
        result.foreground = foreground;
        return result;
    }

    public TextStyle foreground(RGB foreground) {
        return this.internalForeground(GraphicsUtil.defensiveCopy(foreground));
    }

    public TextStyle foreground(int red, int green, int blue) {
        return this.internalForeground(new RGB(red, green, blue));
    }

    public TextStyle foreground(int rgb) {
        return this.internalForeground(GraphicsUtil.deriveRGB(rgb));
    }

    private TextStyle internalBackground(RGB background) {
        TextStyle result = new TextStyle(this);
        result.background = background;
        return result;
    }

    public TextStyle background(RGB background) {
        return this.internalBackground(GraphicsUtil.defensiveCopy(background));
    }

    public TextStyle background(int red, int green, int blue) {
        return this.internalBackground(new RGB(red, green, blue));
    }

    public TextStyle background(int rgb) {
        return this.internalBackground(GraphicsUtil.deriveRGB(rgb));
    }

    public TextStyle align(int alignment) {
        TextStyle result = new TextStyle(this);
        result.alignment = BitUtil.firstMatch(alignment, new int[]{16384, 0x1000000, 131072}, 16384);
        return result;
    }

    public TextStyle underline() {
        return this.underline(true);
    }

    public TextStyle underline(boolean underline) {
        TextStyle result = new TextStyle(this);
        result.underline = underline;
        return result;
    }

    public TextStyle strikeout() {
        return this.strikeout(true);
    }

    public TextStyle strikeout(boolean strikeout) {
        TextStyle result = new TextStyle(this);
        result.strikeout = strikeout;
        return result;
    }

    public FontData getFontData() {
        return GraphicsUtil.defensiveCopy(this.fontData);
    }

    public RGB getForeground() {
        return GraphicsUtil.defensiveCopy(this.foreground);
    }

    public RGB getBackground() {
        return GraphicsUtil.defensiveCopy(this.background);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public boolean getStrikeout() {
        return this.strikeout;
    }
}

