/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.TextIterator;
import net.sf.paperclips.TextStyle;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class TextPrint
implements Print {
    public static final String DEFAULT_TEXT = "";
    public static final FontData DEFAULT_FONT_DATA = new FontData();
    public static final int DEFAULT_ALIGN = 16384;
    private static final TextStyle DEFAULT_STYLE = new TextStyle();
    String text;
    TextStyle style;
    boolean wordSplitting;

    public TextPrint() {
        this(DEFAULT_TEXT);
    }

    public TextPrint(String text) {
        this(text, DEFAULT_STYLE);
    }

    public TextPrint(String text, FontData fontData) {
        this(text, DEFAULT_STYLE.font(fontData));
    }

    public TextPrint(String text, int align) {
        this(text, DEFAULT_STYLE.align(align));
    }

    public TextPrint(String text, FontData fontData, int align) {
        this(text, DEFAULT_STYLE.font(fontData).align(align));
    }

    public TextPrint(String text, TextStyle style) {
        NullUtil.notNull(text, style);
        this.text = text;
        this.style = style;
        this.wordSplitting = true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        NullUtil.notNull(text);
        this.text = text;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public void setStyle(TextStyle style) {
        NullUtil.notNull(style);
        this.style = style;
    }

    public FontData getFontData() {
        return this.style.getFontData();
    }

    public void setFontData(FontData fontData) {
        this.setStyle(this.style.font(fontData));
    }

    public int getAlign() {
        return this.style.getAlignment();
    }

    public void setAlign(int alignment) {
        this.setAlignment(alignment);
    }

    public int getAlignment() {
        return this.style.getAlignment();
    }

    public void setAlignment(int alignment) {
        this.setStyle(this.style.align(alignment));
    }

    public RGB getRGB() {
        return this.getForeground();
    }

    public void setRGB(RGB foreground) {
        this.setForeground(foreground);
    }

    public RGB getForeground() {
        return this.style.getForeground();
    }

    public void setForeground(RGB foreground) {
        this.setStyle(this.style.foreground(foreground));
    }

    public RGB getBackground() {
        return this.style.getBackground();
    }

    public void setBackground(RGB background) {
        this.style = this.style.background(background);
    }

    public boolean getUnderline() {
        return this.style.getUnderline();
    }

    public void setUnderline(boolean underline) {
        this.style = this.style.underline(underline);
    }

    public boolean getStrikeout() {
        return this.style.getStrikeout();
    }

    public void setStrikeout(boolean strikeout) {
        this.style = this.style.strikeout(strikeout);
    }

    public boolean getWordSplitting() {
        return this.wordSplitting;
    }

    public void setWordSplitting(boolean wordBreaking) {
        this.wordSplitting = wordBreaking;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new TextIterator(this, device, gc);
    }
}

