/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.util.ArrayList;
import net.sf.paperclips.AbstractIterator;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.TextPiece;
import net.sf.paperclips.TextPrint;
import net.sf.paperclips.TextStyle;
import net.sf.paperclips.internal.ResourcePool;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class TextIterator
extends AbstractIterator {
    final String text;
    final String[] lines;
    final TextStyle style;
    final boolean wordSplitting;
    int row;
    int col;

    TextIterator(TextPrint print, Device device, GC gc) {
        super(device, gc);
        this.text = print.text;
        this.lines = print.text.split("(\r)?\n");
        this.style = print.style;
        this.wordSplitting = print.wordSplitting;
        this.row = 0;
        this.col = 0;
    }

    TextIterator(TextIterator that) {
        super(that);
        this.text = that.text;
        this.lines = (String[])that.lines.clone();
        this.style = that.style;
        this.wordSplitting = that.wordSplitting;
        this.row = that.row;
        this.col = that.col;
    }

    public boolean hasNext() {
        return this.row < this.lines.length;
    }

    public PrintPiece next(int width, int height) {
        if (!this.hasNext()) {
            PaperClips.error("No more content.");
        }
        Font oldFont = this.initGC();
        PrintPiece result = this.internalNext(width, height);
        this.restoreGC(oldFont);
        return result;
    }

    private PrintPiece internalNext(int width, int height) {
        FontMetrics fm = this.gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        if (height < lineHeight) {
            return null;
        }
        int maxLines = height / lineHeight;
        String[] nextLines = this.nextLines(width, maxLines);
        if (nextLines.length == 0) {
            return null;
        }
        int maxWidth = this.maxExtent((String[])nextLines).x;
        Point size = new Point(maxWidth, nextLines.length * lineHeight);
        int ascent = fm.getAscent() + fm.getLeading();
        return new TextPiece(this.device, this.style, nextLines, size, ascent);
    }

    private Font initGC() {
        Font oldFont = this.gc.getFont();
        FontData fontData = this.style.getFontData();
        if (fontData != null) {
            this.gc.setFont(ResourcePool.forDevice(this.device).getFont(fontData));
        }
        return oldFont;
    }

    private void restoreGC(Font oldFont) {
        this.gc.setFont(oldFont);
    }

    private String[] nextLines(int width, int maxLines) {
        ArrayList<String> nextLines = new ArrayList<String>(Math.min(this.lines.length, maxLines));
        while (nextLines.size() < maxLines && this.row < this.lines.length) {
            String line = this.lines[this.row].substring(this.col);
            int charCount = this.findLineBreak(this.gc, line, width);
            if (line.length() > 0 && charCount == 0) break;
            String thisLine = line.substring(0, charCount);
            nextLines.add(thisLine);
            this.col += charCount;
            this.skipWhitespace();
            this.advanceToNextRowIfCurrentRowCompleted();
        }
        return nextLines.toArray(new String[nextLines.size()]);
    }

    private void skipWhitespace() {
        while (this.col < this.lines[this.row].length() && Character.isWhitespace(this.lines[this.row].charAt(this.col))) {
            ++this.col;
        }
    }

    private void advanceToNextRowIfCurrentRowCompleted() {
        if (this.col >= this.lines[this.row].length()) {
            ++this.row;
            this.col = 0;
        }
    }

    public Point minimumSize() {
        return this.maxExtent(this.text.split("\\s"));
    }

    public Point preferredSize() {
        return this.maxExtent(this.lines);
    }

    private Point maxExtent(String[] text) {
        Font oldFont = this.gc.getFont();
        try {
            this.initGC();
            FontMetrics fm = this.gc.getFontMetrics();
            int maxWidth = 0;
            int i = 0;
            while (i < text.length) {
                String textPiece = text[i];
                maxWidth = Math.max(maxWidth, this.gc.stringExtent((String)textPiece).x);
                ++i;
            }
            Point point = new Point(maxWidth, fm.getHeight());
            return point;
        }
        finally {
            this.restoreGC(oldFont);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int findLineBreak(GC gc, String text, int width) {
        loIndex = 0;
        hiIndex = text.length();
        pixelWidth = gc.stringExtent((String)text).x;
        if (pixelWidth > width) ** GOTO lbl15
        return hiIndex;
lbl-1000:
        // 1 sources

        {
            midIndex = (loIndex + hiIndex + 1) / 2;
            midWidth = gc.stringExtent((String)text.substring((int)0, (int)midIndex)).x;
            if (midWidth < width) {
                loIndex = midIndex;
                continue;
            }
            if (midWidth > width) {
                hiIndex = midIndex - 1;
                continue;
            }
            loIndex = hiIndex = midIndex;
lbl15:
            // 4 sources

            ** while (loIndex < hiIndex)
        }
lbl16:
        // 1 sources

        return this.findWordBreak(text, loIndex);
    }

    int findWordBreak(String text, int maxLength) {
        if (maxLength == text.length()) {
            return maxLength;
        }
        int i = maxLength;
        while (i >= 0) {
            if (Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            --i;
        }
        if (this.wordSplitting) {
            return maxLength;
        }
        return 0;
    }

    public PrintIterator copy() {
        return new TextIterator(this);
    }
}

