/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.SidewaysIterator;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public final class SidewaysPrint
implements Print {
    private final Print target;
    private final int angle;

    public SidewaysPrint(Print target) {
        this(target, 90);
    }

    public SidewaysPrint(Print target, int angle) {
        NullUtil.notNull(target);
        this.target = target;
        this.angle = SidewaysPrint.checkAngle(angle);
    }

    private static int checkAngle(int angle) {
        if (Math.abs(angle) % 90 != 0) {
            PaperClips.error(5, "Angle must be a multiple of 90 degrees");
        }
        while (angle < 0) {
            angle += 360;
        }
        while (angle >= 360) {
            angle -= 360;
        }
        return angle;
    }

    public Print getTarget() {
        return this.target;
    }

    public int getAngle() {
        return this.angle;
    }

    public PrintIterator iterator(Device device, GC gc) {
        if (this.angle == 0) {
            return this.target.iterator(device, gc);
        }
        return new SidewaysIterator(this.target, this.angle, device, gc);
    }
}

