/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.PaperClips;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.ScalePiece;
import net.sf.paperclips.ScalePrint;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class ScaleIterator
implements PrintIterator {
    private final Device device;
    private final PrintIterator target;
    private final Double scale;
    private final Point minimumSize;
    private final Point preferredSize;

    ScaleIterator(ScalePrint print, Device device, GC gc) {
        NullUtil.notNull(print, device, gc);
        this.device = device;
        this.target = print.target.iterator(device, gc);
        this.scale = print.scale;
        Point min = this.target.minimumSize();
        Point pref = this.target.preferredSize();
        if (this.scale == null) {
            this.minimumSize = new Point(Math.min(1, min.x), Math.min(1, min.y));
            this.preferredSize = new Point(Math.min(1, pref.x), Math.min(1, pref.y));
        } else {
            double s = this.scale;
            this.minimumSize = new Point((int)Math.ceil((double)min.x * s), (int)Math.ceil((double)min.y * s));
            this.preferredSize = new Point((int)Math.ceil((double)pref.x * s), (int)Math.ceil((double)pref.y * s));
        }
    }

    private ScaleIterator(ScaleIterator that) {
        this.device = that.device;
        this.target = that.target.copy();
        this.scale = that.scale;
        this.minimumSize = that.minimumSize;
        this.preferredSize = that.preferredSize;
    }

    public Point minimumSize() {
        return this.minimumSize;
    }

    public Point preferredSize() {
        return this.preferredSize;
    }

    public boolean hasNext() {
        return this.target.hasNext();
    }

    public PrintPiece next(int width, int height) {
        int scaledHeight;
        Point pref = this.target.preferredSize();
        double scale = this.scale == null ? Math.min(Math.min((double)width / (double)pref.x, (double)height / (double)pref.y), 1.0) : this.scale;
        int scaledWidth = (int)Math.ceil((double)width / scale);
        PrintPiece target = PaperClips.next(this.target, scaledWidth, scaledHeight = (int)Math.ceil((double)height / scale));
        if (target == null) {
            return null;
        }
        return new ScalePiece(this.device, target, scale, width, height);
    }

    public PrintIterator copy() {
        return new ScaleIterator(this);
    }
}

