/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.Margins;
import net.sf.paperclips.Print;
import net.sf.paperclips.internal.NullUtil;

public class PrintJob {
    private final String name;
    private final Print document;
    private Margins margins = new Margins();
    private int orientation = -1;

    public PrintJob(String name, Print document) {
        NullUtil.notNull(name, document);
        this.name = name;
        this.document = document;
    }

    public String getName() {
        return this.name;
    }

    public Print getDocument() {
        return this.document;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public PrintJob setOrientation(int orientation) {
        this.orientation = this.checkOrientation(orientation);
        return this;
    }

    private int checkOrientation(int orientation) {
        switch (orientation) {
            case -1: 
            case 256: 
            case 512: {
                return orientation;
            }
        }
        return -1;
    }

    public Margins getMargins() {
        return this.margins;
    }

    public PrintJob setMargins(Margins margins) {
        NullUtil.notNull(margins);
        this.margins = margins;
        return this;
    }

    public PrintJob setMargins(int margins) {
        this.margins = new Margins(margins);
        return this;
    }
}

