/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.util.ArrayList;
import java.util.List;
import net.sf.paperclips.CompositeEntry;
import net.sf.paperclips.CompositePiece;
import net.sf.paperclips.Margins;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintJob;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.RotatePrint;
import net.sf.paperclips.internal.NullUtil;
import net.sf.paperclips.internal.PrintPieceUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class PaperClips {
    private static boolean debug = false;
    public static final int ORIENTATION_DEFAULT = -1;
    public static final int ORIENTATION_PORTRAIT = 512;
    public static final int ORIENTATION_LANDSCAPE = 256;

    private PaperClips() {
    }

    public static void error(int code) {
        PaperClips.error(code, null);
    }

    public static void error(String detail) {
        PaperClips.error(1, detail);
    }

    public static void error(int code, String detail) {
        SWT.error((int)code, null, (String)detail);
    }

    public static void setDebug(boolean debug) {
        PaperClips.debug = debug;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static PrintPiece next(PrintIterator iterator, int width, int height) {
        PrintPiece result;
        NullUtil.notNull(iterator);
        if (width < 0 || height < 0) {
            PaperClips.error(5, "PrintPiece size " + width + "x" + height + " not possible");
        }
        if (!iterator.hasNext()) {
            PaperClips.error("Iterator " + iterator + " has no more content.");
        }
        if ((result = iterator.next(width, height)) != null) {
            Point size = result.getSize();
            if (size.x > width || size.y > height) {
                PaperClips.error("Iterator " + iterator + " produced a " + size.x + "x" + size.y + " piece for a " + width + "x" + height + " area.");
            }
        } else if (debug) {
            return new NullPrintPiece();
        }
        return result;
    }

    public static void print(PrintJob printJob, PrinterData printerData) {
        Printer printer = new Printer(printerData);
        try {
            PaperClips.print(printJob, printer);
        }
        finally {
            printer.dispose();
        }
    }

    public static void print(PrintJob printJob, Printer printer) {
        PaperClips.startJob(printer, printJob.getName());
        boolean completed = false;
        try {
            GC gc = PaperClips.createAndConfigureGC(printer);
            try {
                PaperClips.print(printJob, printer, gc);
            }
            finally {
                gc.dispose();
            }
            printer.endJob();
            completed = true;
        }
        finally {
            if (!completed) {
                printer.cancelJob();
            }
        }
    }

    private static void startJob(Printer printer, String jobName) {
        if (!printer.startJob(jobName)) {
            PaperClips.error("Unable to start print job");
        }
    }

    private static GC createAndConfigureGC(Printer printer) {
        GC gc = new GC((Drawable)printer);
        gc.setAdvanced(true);
        return gc;
    }

    private static void print(PrintJob printJob, Printer printer, GC gc) {
        int noncollatedCopies;
        int collatedCopies;
        PrinterData printerData = printer.getPrinterData();
        PrintPiece[] pages = PaperClips.getPages(printJob, printer, gc);
        int startPage = 0;
        int endPage = pages.length - 1;
        if (printerData.scope == 1) {
            startPage = Math.max(startPage, printerData.startPage - 1);
            endPage = Math.min(endPage, printerData.endPage - 1);
        }
        if (printerData.collate) {
            collatedCopies = printerData.copyCount;
            noncollatedCopies = 1;
        } else {
            noncollatedCopies = printerData.copyCount;
            collatedCopies = 1;
        }
        PaperClips.printPages(printer, gc, pages, startPage, endPage, collatedCopies, noncollatedCopies);
    }

    private static void printPages(Printer printer, GC gc, PrintPiece[] pages, int startPage, int endPage, int collatedCopies, int noncollatedCopies) {
        PaperClips.disposeUnusedPages(pages, startPage, endPage);
        Rectangle paperBounds = PaperClips.getPaperBounds(printer);
        int x = paperBounds.x;
        int y = paperBounds.y;
        try {
            int collated = 0;
            while (collated < collatedCopies) {
                int pageIndex = startPage;
                while (pageIndex <= endPage) {
                    int noncollated = 0;
                    while (noncollated < noncollatedCopies) {
                        if (printer.startPage()) {
                            pages[pageIndex].paint(gc, x, y);
                            pages[pageIndex].dispose();
                            printer.endPage();
                        } else {
                            PaperClips.error("Unable to start page " + pageIndex);
                        }
                        ++noncollated;
                    }
                    ++pageIndex;
                }
                ++collated;
            }
        }
        finally {
            PrintPieceUtil.dispose(pages);
        }
    }

    private static void disposeUnusedPages(PrintPiece[] pages, int startPage, int endPage) {
        PrintPieceUtil.dispose(pages, 0, startPage);
        PrintPieceUtil.dispose(pages, endPage + 1, pages.length);
    }

    public static PrintPiece[] getPages(PrintJob printJob, Printer printer) {
        PaperClips.startDummyJob(printer, printJob.getName());
        try {
            PrintPiece[] printPieceArray;
            GC gc = PaperClips.createAndConfigureGC(printer);
            try {
                printPieceArray = PaperClips.getPages(printJob, printer, gc);
            }
            catch (Throwable throwable) {
                gc.dispose();
                throw throwable;
            }
            gc.dispose();
            return printPieceArray;
        }
        finally {
            PaperClips.endDummyJob(printer);
        }
    }

    private static void startDummyJob(Printer printer, String name) {
        if (PaperClips.isCarbon() || PaperClips.isGTK()) {
            PaperClips.startJob(printer, name);
        }
    }

    private static void endDummyJob(Printer printer) {
        if (PaperClips.isGTK()) {
            printer.cancelJob();
        } else if (PaperClips.isCarbon()) {
            printer.endJob();
        }
    }

    private static boolean isCarbon() {
        return SWT.getPlatform().equals("carbon");
    }

    private static boolean isGTK() {
        return SWT.getPlatform().equals("gtk");
    }

    private static PrintPiece[] getPages(PrintJob printJob, Printer printer, GC gc) {
        PrintJobIterator iterator = new PrintJobIterator(printJob, printer, gc);
        ArrayList<PrintPiece> pages = new ArrayList<PrintPiece>();
        while (iterator.hasNext()) {
            PrintPiece page = iterator.nextPage();
            if (page == null) {
                PaperClips.errorOnPage(pages.size() + 1, pages);
            }
            pages.add(page);
        }
        return pages.toArray(new PrintPiece[pages.size()]);
    }

    private static void errorOnPage(int pageNumber, List pages) {
        PrintPieceUtil.dispose(pages);
        PaperClips.error("Unable to layout page " + pageNumber);
    }

    public static Rectangle getPaperBounds(Printer printer) {
        Rectangle rect = PaperClips.getPrintableBounds(printer);
        return printer.computeTrim(rect.x, rect.y, rect.width, rect.height);
    }

    public static Rectangle getPrintableBounds(Printer printer) {
        return printer.getClientArea();
    }

    public static Rectangle getMarginBounds(Margins margins, Printer printer) {
        Rectangle paperBounds = PaperClips.getPaperBounds(printer);
        Point dpi = printer.getDPI();
        int top = paperBounds.y + margins.top * dpi.y / 72;
        int left = paperBounds.x + margins.left * dpi.x / 72;
        int right = paperBounds.x + paperBounds.width - margins.right * dpi.x / 72;
        int bottom = paperBounds.y + paperBounds.height - margins.bottom * dpi.y / 72;
        Rectangle printableBounds = PaperClips.getPrintableBounds(printer);
        if (top < printableBounds.y) {
            top = printableBounds.y;
        }
        if (left < printableBounds.x) {
            left = printableBounds.x;
        }
        if (right > printableBounds.x + printableBounds.width) {
            right = printableBounds.x + printableBounds.width;
        }
        if (bottom > printableBounds.y + printableBounds.height) {
            bottom = printableBounds.y + printableBounds.height;
        }
        return new Rectangle(left, top, right - left, bottom - top);
    }

    private static final class NullPrintPiece
    implements PrintPiece {
        private NullPrintPiece() {
        }

        public Point getSize() {
            return new Point(0, 0);
        }

        public void paint(GC gc, int x, int y) {
        }

        public void dispose() {
        }
    }

    private static class PrintJobIterator {
        private final PrintIterator document;
        private final Rectangle marginBounds;
        private final Rectangle paperBounds;
        private boolean hasNext;

        PrintJobIterator(PrintJob job, Printer printer, GC gc) {
            job = PrintJobIterator.applyOrientation(job, printer);
            Margins margins = job.getMargins();
            this.marginBounds = PaperClips.getMarginBounds(margins, printer);
            this.paperBounds = PaperClips.getPaperBounds(printer);
            this.document = job.getDocument().iterator((Device)printer, gc);
            this.hasNext = this.document.hasNext();
        }

        boolean hasNext() {
            return this.hasNext;
        }

        PrintPiece nextPage() {
            if (!this.hasNext) {
                return null;
            }
            PrintPiece page = PaperClips.next(this.document, this.marginBounds.width, this.marginBounds.height);
            this.hasNext = this.notNull(page) && PrintJobIterator.notDebugPiece(page) && this.document.hasNext();
            return page == null ? null : this.createPagePiece(page);
        }

        private boolean notNull(PrintPiece page) {
            return page != null;
        }

        private static boolean notDebugPiece(PrintPiece page) {
            return !debug || !(page instanceof NullPrintPiece);
        }

        private PrintPiece createPagePiece(PrintPiece page) {
            Point offset = new Point(this.marginBounds.x - this.paperBounds.x, this.marginBounds.y - this.paperBounds.y);
            CompositeEntry entry = new CompositeEntry(page, offset);
            Point size = new Point(this.paperBounds.width, this.paperBounds.height);
            return new CompositePiece(new CompositeEntry[]{entry}, size);
        }

        private static PrintJob applyOrientation(PrintJob printJob, Printer printer) {
            int orientation = printJob.getOrientation();
            Rectangle paperBounds = PaperClips.getPaperBounds(printer);
            if (orientation == 256 && paperBounds.width < paperBounds.height || orientation == 512 && paperBounds.height < paperBounds.width) {
                String name = printJob.getName();
                RotatePrint document = new RotatePrint(printJob.getDocument());
                Margins margins = printJob.getMargins().rotate();
                printJob = new PrintJob(name, document).setMargins(margins).setOrientation(-1);
            }
            return printJob;
        }
    }
}

