/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.DefaultPageNumberFormat;
import net.sf.paperclips.PageNumber;
import net.sf.paperclips.PageNumberFormat;
import net.sf.paperclips.PageNumberIterator;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.internal.BitUtil;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class PageNumberPrint
implements Print {
    public static final FontData DEFAULT_FONT_DATA = new FontData();
    public static final int DEFAULT_ALIGN = 16384;
    PageNumber pageNumber;
    FontData fontData;
    int align;
    RGB rgb;
    PageNumberFormat format;

    public PageNumberPrint(PageNumber pageNumber) {
        this(pageNumber, DEFAULT_FONT_DATA, 16384);
    }

    public PageNumberPrint(PageNumber pageNumber, FontData fontData) {
        this(pageNumber, fontData, 16384);
    }

    public PageNumberPrint(PageNumber pageNumber, int align) {
        this(pageNumber, DEFAULT_FONT_DATA, align);
    }

    public PageNumberPrint(PageNumber pageNumber, FontData fontData, int align) {
        this.setPageNumber(pageNumber);
        this.setFontData(fontData);
        this.setAlign(align);
        this.setRGB(new RGB(0, 0, 0));
        this.setPageNumberFormat(new DefaultPageNumberFormat());
    }

    public void setPageNumber(PageNumber pageNumber) {
        NullUtil.notNull(pageNumber);
        this.pageNumber = pageNumber;
    }

    public PageNumber getPageNumber() {
        return this.pageNumber;
    }

    public void setFontData(FontData fontData) {
        NullUtil.notNull(fontData);
        this.fontData = fontData;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public void setAlign(int align) {
        this.align = this.checkAlign(align);
    }

    public int getAlign() {
        return this.align;
    }

    private int checkAlign(int align) {
        return BitUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072}, 16384);
    }

    public void setPageNumberFormat(PageNumberFormat format) {
        NullUtil.notNull(format);
        this.format = format;
    }

    public PageNumberFormat getPageNumberFormat() {
        return this.format;
    }

    public void setRGB(RGB foreground) {
        NullUtil.notNull(foreground);
        this.rgb = foreground;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new PageNumberIterator(this, device, gc);
    }
}

