/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.DefaultPageNumberFormat;
import net.sf.paperclips.PageDecoration;
import net.sf.paperclips.PageNumber;
import net.sf.paperclips.PageNumberFormat;
import net.sf.paperclips.PageNumberPrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.internal.BitUtil;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class PageNumberPageDecoration
implements PageDecoration {
    FontData fontData = new FontData();
    int align = 16384;
    RGB rgb = new RGB(0, 0, 0);
    PageNumberFormat format = new DefaultPageNumberFormat();

    public PageNumberPageDecoration() {
    }

    public PageNumberPageDecoration(int align) {
        this.setAlign(align);
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        NullUtil.notNull(fontData);
        this.fontData = fontData;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int align) {
        this.align = align = this.checkAlign(align);
    }

    private int checkAlign(int align) {
        return BitUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072}, 16384);
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        NullUtil.notNull(rgb);
        this.rgb = rgb;
    }

    public PageNumberFormat getFormat() {
        return this.format;
    }

    public void setFormat(PageNumberFormat format) {
        NullUtil.notNull(format);
        this.format = format;
    }

    public Print createPrint(PageNumber pageNumber) {
        PageNumberPrint result = new PageNumberPrint(pageNumber);
        result.setFontData(this.fontData);
        result.setAlign(this.align);
        result.setPageNumberFormat(this.format);
        result.setRGB(this.rgb);
        return result;
    }
}

