/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.AbstractIterator;
import net.sf.paperclips.PageNumber;
import net.sf.paperclips.PageNumberFormat;
import net.sf.paperclips.PageNumberPiece;
import net.sf.paperclips.PageNumberPrint;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.ResourcePool;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class PageNumberIterator
extends AbstractIterator {
    final PageNumber pageNumber;
    final FontData fontData;
    final int align;
    final RGB rgb;
    final PageNumberFormat format;
    final Point size;
    boolean hasNext = true;

    PageNumberIterator(PageNumberPrint print, Device device, GC gc) {
        super(device, gc);
        this.pageNumber = print.pageNumber;
        this.fontData = print.fontData;
        this.align = print.align;
        this.rgb = print.rgb;
        this.format = print.format;
        Font oldFont = gc.getFont();
        try {
            gc.setFont(ResourcePool.forDevice(device).getFont(this.fontData));
            this.size = gc.textExtent(this.format.format(new PageNumber(){

                public int getPageCount() {
                    return 9999;
                }

                public int getPageNumber() {
                    return 9998;
                }
            }));
        }
        finally {
            gc.setFont(oldFont);
        }
    }

    PageNumberIterator(PageNumberIterator that) {
        super(that);
        this.pageNumber = that.pageNumber;
        this.fontData = that.fontData;
        this.align = that.align;
        this.rgb = that.rgb;
        this.format = that.format;
        this.size = that.size;
        this.hasNext = that.hasNext;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Point minimumSize() {
        return this.size;
    }

    public Point preferredSize() {
        return this.size;
    }

    public PrintPiece next(int width, int height) {
        if (width < this.size.x || height < this.size.y) {
            return null;
        }
        Point size = new Point(this.size.x, this.size.y);
        if (this.align == 0x1000000 || this.align == 131072) {
            size.x = width;
        }
        PageNumberPiece piece = new PageNumberPiece(this, size);
        this.hasNext = false;
        return piece;
    }

    public PrintIterator copy() {
        return new PageNumberIterator(this);
    }
}

