/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.util.ArrayList;
import net.sf.paperclips.CompositeEntry;
import net.sf.paperclips.CompositePiece;
import net.sf.paperclips.PageDecoration;
import net.sf.paperclips.PageNumber;
import net.sf.paperclips.PagePrint;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.PrintPieceUtil;
import net.sf.paperclips.internal.PrintSizeStrategy;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class PageIterator
implements PrintIterator {
    final Device device;
    final GC gc;
    final PageDecoration header;
    final int headerGap;
    final PrintIterator body;
    final int footerGap;
    final PageDecoration footer;
    final PageNumberer numberer;
    final Point minimumSize;
    final Point preferredSize;
    PageNumber pageNumber;

    PageIterator(PagePrint print, Device device, GC gc) {
        this.device = device;
        this.gc = gc;
        Point dpi = device.getDPI();
        this.body = print.body.iterator(device, gc);
        this.header = print.header;
        this.headerGap = this.header == null ? 0 : print.headerGap * dpi.y / 72;
        this.footer = print.footer;
        this.footerGap = this.footer == null ? 0 : print.footerGap * dpi.y / 72;
        this.numberer = new PageNumberer();
        this.minimumSize = this.computeSize(PrintSizeStrategy.MINIMUM);
        this.preferredSize = this.computeSize(PrintSizeStrategy.PREFERRED);
    }

    PageIterator(PageIterator that) {
        this.device = that.device;
        this.gc = that.gc;
        this.body = that.body.copy();
        this.header = that.header;
        this.headerGap = that.headerGap;
        this.footer = that.footer;
        this.footerGap = that.footerGap;
        this.numberer = that.numberer.copy();
        this.pageNumber = that.pageNumber;
        this.minimumSize = that.minimumSize;
        this.preferredSize = that.preferredSize;
    }

    private Point computeSize(PrintSizeStrategy strategy) {
        Print footerPrint;
        PrintIterator iter;
        Print headerPrint;
        Point size = strategy.computeSize(this.body);
        PageNumber samplePageNumber = new PageNumber(){

            public int getPageCount() {
                return 1;
            }

            public int getPageNumber() {
                return 0;
            }
        };
        if (this.header != null && (headerPrint = this.header.createPrint(samplePageNumber)) != null) {
            iter = headerPrint.iterator(this.device, this.gc);
            size.y += this.headerGap;
            Point headerSize = strategy.computeSize(iter);
            size.x = Math.max(size.x, headerSize.x);
            size.y += headerSize.y;
        }
        if (this.footer != null && (footerPrint = this.footer.createPrint(samplePageNumber)) != null) {
            iter = footerPrint.iterator(this.device, this.gc);
            size.y += this.footerGap;
            Point footerSize = strategy.computeSize(iter);
            size.x = Math.max(size.x, footerSize.x);
            size.y += footerSize.y;
        }
        return size;
    }

    public boolean hasNext() {
        return this.body.hasNext();
    }

    public Point minimumSize() {
        return new Point(this.minimumSize.x, this.minimumSize.y);
    }

    public Point preferredSize() {
        return new Point(this.preferredSize.x, this.preferredSize.y);
    }

    public PrintPiece next(int width, int height) {
        PrintPiece bodyPiece;
        Print footerPrint;
        Print headerPrint;
        PageNumber pageNumber = this.getCurrentPageNumber();
        PrintPiece headerPiece = null;
        int availableHeight = height;
        if (this.header != null && (headerPrint = this.header.createPrint(pageNumber)) != null) {
            headerPiece = this.getDecorationPrintPiece(headerPrint, width, availableHeight);
            if (headerPiece == null) {
                return null;
            }
            availableHeight -= this.heightOf(headerPiece) + this.headerGap;
        }
        PrintPiece footerPiece = null;
        if (this.footer != null && (footerPrint = this.footer.createPrint(pageNumber)) != null) {
            footerPiece = this.getDecorationPrintPiece(footerPrint, width, availableHeight);
            if (footerPiece == null) {
                PrintPieceUtil.dispose(headerPiece);
                return null;
            }
            availableHeight -= this.heightOf(footerPiece) + this.footerGap;
        }
        if ((bodyPiece = PaperClips.next(this.body, width, availableHeight)) == null) {
            PrintPieceUtil.dispose(headerPiece, footerPiece);
            return null;
        }
        PrintPiece result = this.createResult(height, headerPiece, bodyPiece, footerPiece);
        this.advancePageNumber();
        return result;
    }

    private int heightOf(PrintPiece piece) {
        return piece.getSize().y;
    }

    private void advancePageNumber() {
        this.pageNumber = null;
    }

    private PageNumber getCurrentPageNumber() {
        if (this.pageNumber == null) {
            this.pageNumber = this.numberer.next();
        }
        return this.pageNumber;
    }

    private PrintPiece createResult(int height, PrintPiece headerPiece, PrintPiece bodyPiece, PrintPiece footerPiece) {
        if (headerPiece == null && footerPiece == null) {
            return bodyPiece;
        }
        ArrayList<CompositeEntry> entries = new ArrayList<CompositeEntry>();
        if (headerPiece != null) {
            entries.add(this.createEntry(headerPiece, 0));
        }
        int y = headerPiece == null ? 0 : this.heightOf(headerPiece) + this.headerGap;
        entries.add(this.createEntry(bodyPiece, y));
        if (footerPiece != null) {
            y = height - this.heightOf(footerPiece);
            entries.add(this.createEntry(footerPiece, y));
        }
        return new CompositePiece(entries);
    }

    private CompositeEntry createEntry(PrintPiece piece, int y) {
        return new CompositeEntry(piece, new Point(0, y));
    }

    private PrintPiece getDecorationPrintPiece(Print decoration, int width, int height) {
        PrintIterator iterator = decoration.iterator(this.device, this.gc);
        PrintPiece piece = PaperClips.next(iterator, width, height);
        if (piece == null) {
            return null;
        }
        if (iterator.hasNext()) {
            piece.dispose();
            return null;
        }
        return piece;
    }

    public PrintIterator copy() {
        return new PageIterator(this);
    }

    class PageNumberer {
        int pageCount = 0;

        PageNumberer() {
        }

        synchronized PageNumber next() {
            return new InnerPageNumber();
        }

        PageNumberer copy() {
            PageNumberer result = new PageNumberer();
            result.pageCount = this.pageCount;
            return result;
        }

        class InnerPageNumber
        implements PageNumber {
            final int pageNumber;

            InnerPageNumber() {
                this.pageNumber = PageNumberer.this.pageCount++;
            }

            public int getPageCount() {
                return PageNumberer.this.pageCount;
            }

            public int getPageNumber() {
                return this.pageNumber;
            }
        }
    }
}

