/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.LineIterator;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class LinePrint
implements Print {
    final int orientation;
    double thickness;
    RGB rgb = new RGB(0, 0, 0);

    public LinePrint() {
        this(256);
    }

    public LinePrint(int orientation) {
        this(orientation, 1.0);
    }

    public LinePrint(int orientation, double thickness) {
        this.orientation = this.checkOrientation(orientation);
        this.thickness = this.checkThickness(thickness);
    }

    public int getOrientation() {
        return this.orientation;
    }

    private int checkOrientation(int orientation) {
        if ((orientation & 0x100) == 256) {
            return 256;
        }
        if ((orientation & 0x200) == 512) {
            return 512;
        }
        return 256;
    }

    private double checkThickness(double thickness) {
        if (thickness < 0.0) {
            return 0.0;
        }
        return thickness;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public void setRGB(RGB foreground) {
        NullUtil.notNull(foreground);
        this.rgb = foreground;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new LineIterator(this, device, gc);
    }
}

