/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.Border;
import net.sf.paperclips.BorderPainter;
import net.sf.paperclips.LineBorderPainter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class LineBorder
implements Border {
    RGB rgb;
    int lineWidth = 1;
    int gapSize = 5;

    public LineBorder() {
        this(new RGB(0, 0, 0));
    }

    public LineBorder(RGB rgb) {
        this.setRGB(rgb);
    }

    public void setRGB(RGB rgb) {
        this.rgb = new RGB(rgb.red, rgb.green, rgb.blue);
    }

    public RGB getRGB() {
        return new RGB(this.rgb.red, this.rgb.green, this.rgb.blue);
    }

    public void setLineWidth(int points) {
        if (points < 1) {
            points = 1;
        }
        this.lineWidth = points;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setGapSize(int points) {
        if (points < 1) {
            points = 1;
        }
        this.gapSize = points;
    }

    public int getGapSize() {
        return Math.max(this.lineWidth, this.gapSize);
    }

    public BorderPainter createPainter(Device device, GC gc) {
        return new LineBorderPainter(this, device, gc);
    }
}

