/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.LayerEntryIterator;
import net.sf.paperclips.Print;
import net.sf.paperclips.internal.BitUtil;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class LayerEntry {
    final Print target;
    final int align;

    LayerEntry(Print target, int align) {
        NullUtil.notNull(target);
        this.target = target;
        this.align = LayerEntry.checkAlign(align);
    }

    LayerEntry(LayerEntry that) {
        this.target = that.target;
        this.align = that.align;
    }

    public Print getTarget() {
        return this.target;
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    private static int checkAlign(int align) {
        return BitUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072}, 16384);
    }

    LayerEntry copy() {
        return new LayerEntry(this);
    }

    LayerEntryIterator iterator(Device device, GC gc) {
        return new LayerEntryIterator(this, device, gc);
    }
}

