/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.ImageIterator;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ImagePrint
implements Print {
    ImageData imageData;
    Point dpi;
    Point size;

    public ImagePrint(ImageData imageData) {
        this(imageData, new Point(72, 72));
    }

    public ImagePrint(ImageData imageData, Point dpi) {
        NullUtil.notNull(imageData, dpi);
        this.imageData = imageData;
        this.setDPI(dpi);
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void setSize(Point size) {
        NullUtil.notNull(size);
        this.dpi = new Point((int)Math.ceil((float)this.imageData.width * 72.0f / (float)size.x), (int)Math.ceil((float)this.imageData.height * 72.0f / (float)size.y));
        this.size = size;
    }

    public void setSize(int width, int height) {
        this.setSize(new Point(width, height));
    }

    public Point getSize() {
        return this.size;
    }

    public void setDPI(Point dpi) {
        NullUtil.notNull(dpi);
        this.dpi = dpi;
        this.size = new Point((int)Math.ceil(this.imageData.width * 72 / dpi.x), (int)Math.ceil(this.imageData.height * 72 / dpi.y));
    }

    public void setDPI(int dpiX, int dpiY) {
        this.setDPI(new Point(dpiX, dpiY));
    }

    public Point getDPI() {
        return this.dpi;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new ImageIterator(this, device);
    }
}

