/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.paperclips.Border;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.GridCell;
import net.sf.paperclips.GridColumn;
import net.sf.paperclips.GridIterator;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.internal.ArrayUtil;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public final class GridPrint
implements Print {
    public static final int REMAINDER = -1;
    public static final int PREFERRED = 0;
    public static final int BORDER_OVERLAP = -1;
    private final DefaultGridLook defaultLook;
    private GridLook look;
    final List columns;
    int[][] columnGroups = new int[0][];
    final List header = new ArrayList();
    private int headerCol = 0;
    final List body = new ArrayList();
    private int bodyCol = 0;
    boolean cellClippingEnabled = true;
    final List footer = new ArrayList();
    private int footerCol = 0;

    public GridPrint() {
        this(new GridColumn[0]);
    }

    public GridPrint(GridLook look) {
        this(new GridColumn[0], look);
    }

    public GridPrint(String columns) {
        this(GridPrint.parseColumns(columns));
    }

    public GridPrint(String columns, GridLook look) {
        this(GridPrint.parseColumns(columns), look);
    }

    public GridPrint(String columns, int spacing) {
        this(GridPrint.parseColumns(columns), spacing, spacing);
    }

    public GridPrint(String columns, int horizontalSpacing, int verticalSpacing) {
        this(GridPrint.parseColumns(columns), horizontalSpacing, verticalSpacing);
    }

    public GridPrint(GridColumn[] columns) {
        NullUtil.noNulls(columns);
        this.columns = new ArrayList();
        int i = 0;
        while (i < columns.length) {
            this.columns.add(columns[i]);
            ++i;
        }
        this.defaultLook = new DefaultGridLook();
        this.look = this.defaultLook;
    }

    public GridPrint(GridColumn[] columns, GridLook look) {
        this(columns);
        this.setLook(look);
    }

    public GridPrint(GridColumn[] columns, int spacing) {
        this(columns, spacing, spacing);
    }

    public GridPrint(GridColumn[] columns, int horizontalSpacing, int verticalSpacing) {
        this(columns);
        this.defaultLook.setCellSpacing(horizontalSpacing, verticalSpacing);
    }

    public void addColumn(String column) {
        this.addColumn(this.columns.size(), GridColumn.parse(column));
    }

    public void addColumn(GridColumn column) {
        this.addColumn(this.columns.size(), column);
    }

    public void addColumn(int index, String column) {
        this.addColumn(index, GridColumn.parse(column));
    }

    public void addColumn(int index, GridColumn column) {
        this.checkColumnInsert(index);
        NullUtil.notNull(column);
        this.columns.add(index, column);
        this.adjustForColumnInsert(index, 1);
    }

    public void addColumns(String columns) {
        this.addColumns(this.columns.size(), GridPrint.parseColumns(columns));
    }

    public void addColumns(GridColumn[] columns) {
        this.addColumns(this.columns.size(), columns);
    }

    public void addColumns(int index, String columns) {
        this.addColumns(index, GridPrint.parseColumns(columns));
    }

    public void addColumns(int index, GridColumn[] columns) {
        this.checkColumnInsert(index);
        NullUtil.noNulls(columns);
        this.columns.addAll(index, (Collection)Arrays.asList(columns));
        this.adjustForColumnInsert(index, columns.length);
    }

    private void checkColumnInsert(int index) {
        if (index < 0 || index > this.columns.size()) {
            PaperClips.error(6, "index = " + index + ", size = " + this.columns.size());
        }
    }

    private void adjustForColumnInsert(int index, int count) {
        this.adjustCellsForColumnInsert(this.header, index, count);
        this.adjustCellsForColumnInsert(this.body, index, count);
        this.adjustCellsForColumnInsert(this.footer, index, count);
        this.adjustColumnGroupsForColumnInsert(index, count);
        if (this.bodyCol > index) {
            this.bodyCol += count;
        }
        if (this.headerCol > index) {
            this.headerCol += count;
        }
        if (this.footerCol > index) {
            this.footerCol += count;
        }
    }

    private void adjustCellsForColumnInsert(List rows, int index, int count) {
        int rowI = 0;
        while (rowI < rows.size()) {
            List row = (List)rows.get(rowI);
            int col = 0;
            int cellI = 0;
            while (cellI < row.size()) {
                GridCell cell = (GridCell)row.get(cellI);
                if ((col += cell.colspan) > index || col == index && (rowI + 1 < rows.size() || cellI + 1 < row.size())) {
                    row.set(cellI, new GridCell(cell.hAlignment, cell.vAlignment, cell.target, cell.colspan + count));
                    break;
                }
                ++cellI;
            }
            ++rowI;
        }
    }

    private void adjustColumnGroupsForColumnInsert(int index, int count) {
        int groupI = 0;
        while (groupI < this.columnGroups.length) {
            int[] group = this.columnGroups[groupI];
            int i = 0;
            while (i < group.length) {
                if (group[i] >= index) {
                    int n = i;
                    group[n] = group[n] + count;
                }
                ++i;
            }
            ++groupI;
        }
    }

    private static GridColumn[] parseColumns(String columns) {
        String[] cols = columns.split("\\s*,\\s*");
        GridColumn[] result = new GridColumn[cols.length];
        int i = 0;
        while (i < cols.length) {
            result[i] = GridColumn.parse(cols[i]);
            ++i;
        }
        return result;
    }

    public GridColumn[] getColumns() {
        return this.columns.toArray(new GridColumn[this.columns.size()]);
    }

    public void addHeader(Print cell) {
        this.headerCol = this.add(this.header, this.headerCol, -1, -1, cell, 1);
    }

    public void addHeader(int hAlignment, Print cell) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, -1, cell, 1);
    }

    public void addHeader(int hAlignment, int vAlignment, Print cell) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, vAlignment, cell, 1);
    }

    public void addHeader(Print cell, int colspan) {
        this.headerCol = this.add(this.header, this.headerCol, -1, -1, cell, colspan);
    }

    public void addHeader(int hAlignment, Print cell, int colspan) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, -1, cell, colspan);
    }

    public void addHeader(int hAlignment, int vAlignment, Print cell, int colspan) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, vAlignment, cell, colspan);
    }

    public void addHeader(Print cell, int colspan, int hAlignment) {
        this.headerCol = this.add(this.header, this.headerCol, hAlignment, -1, cell, colspan);
    }

    public GridCell[][] getHeaderCells() {
        return GridPrint.getGridCellArray(this.header);
    }

    public GridCell[][] getBodyCells() {
        return GridPrint.getGridCellArray(this.body);
    }

    public GridCell[][] getFooterCells() {
        return GridPrint.getGridCellArray(this.footer);
    }

    private static GridCell[][] getGridCellArray(List list) {
        GridCell[][] cells = new GridCell[list.size()][];
        int rowIndex = 0;
        while (rowIndex < cells.length) {
            List row = (List)list.get(rowIndex);
            GridCell[] rowCells = new GridCell[row.size()];
            int cellIndex = 0;
            while (cellIndex < rowCells.length) {
                rowCells[cellIndex] = (GridCell)row.get(cellIndex);
                ++cellIndex;
            }
            cells[rowIndex] = rowCells;
            ++rowIndex;
        }
        return cells;
    }

    public RGB getHeaderBackground() {
        return this.defaultLook.getHeaderBackground();
    }

    public void setHeaderBackground(RGB headerBackground) {
        this.defaultLook.setHeaderBackground(headerBackground);
    }

    public void add(Print cell) {
        this.bodyCol = this.add(this.body, this.bodyCol, -1, -1, cell, 1);
    }

    public void add(int hAlignment, Print cell) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, -1, cell, 1);
    }

    public void add(int hAlignment, int vAlignment, Print cell) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, vAlignment, cell, 1);
    }

    public void add(Print cell, int colspan) {
        this.bodyCol = this.add(this.body, this.bodyCol, -1, -1, cell, colspan);
    }

    public void add(int hAlignment, Print cell, int colspan) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, -1, cell, colspan);
    }

    public void add(int hAlignment, int vAlignment, Print cell, int colspan) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, vAlignment, cell, colspan);
    }

    public void add(Print cell, int colspan, int hAlignment) {
        this.bodyCol = this.add(this.body, this.bodyCol, hAlignment, -1, cell, colspan);
    }

    public RGB getBodyBackground() {
        return this.defaultLook.getBodyBackground();
    }

    public void setBodyBackground(RGB bodyBackground) {
        this.defaultLook.setBodyBackground(bodyBackground);
    }

    public boolean isCellClippingEnabled() {
        return this.cellClippingEnabled;
    }

    public void setCellClippingEnabled(boolean cellClippingEnabled) {
        this.cellClippingEnabled = cellClippingEnabled;
    }

    public void addFooter(Print cell) {
        this.footerCol = this.add(this.footer, this.footerCol, -1, -1, cell, 1);
    }

    public void addFooter(int hAlignment, Print cell) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, -1, cell, 1);
    }

    public void addFooter(int hAlignment, int vAlignment, Print cell) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, vAlignment, cell, 1);
    }

    public void addFooter(Print cell, int colspan) {
        this.footerCol = this.add(this.footer, this.footerCol, -1, -1, cell, colspan);
    }

    public void addFooter(int hAlignment, Print cell, int colspan) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, -1, cell, colspan);
    }

    public void addFooter(int hAlignment, int vAlignment, Print cell, int colspan) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, vAlignment, cell, colspan);
    }

    public void addFooter(Print cell, int colspan, int hAlignment) {
        this.footerCol = this.add(this.footer, this.footerCol, hAlignment, -1, cell, colspan);
    }

    public RGB getFooterBackground() {
        return this.defaultLook.getFooterBackground();
    }

    public void setFooterBackground(RGB footerBackground) {
        this.defaultLook.setBodyBackground(footerBackground);
    }

    private int add(List rows, int startColumn, int hAlignment, int vAlignment, Print cellContents, int colspan) {
        startColumn = this.startNewRowIfCurrentRowFull(startColumn);
        this.checkColumnSpan(startColumn, colspan);
        List row = this.getOpenRow(rows, startColumn);
        colspan = this.convertRemainderToExplicitColSpan(startColumn, colspan);
        GridCell cell = new GridCell(hAlignment, vAlignment, cellContents, colspan);
        row.add(cell);
        if ((startColumn += colspan) > this.columns.size()) {
            row.remove(row.size() - 1);
            if (row.size() == 0) {
                rows.remove(row);
            }
            PaperClips.error(5, "Colspan " + colspan + " too wide at column " + startColumn + " (" + this.columns.size() + " columns total)");
        }
        return startColumn;
    }

    private int convertRemainderToExplicitColSpan(int startColumn, int colspan) {
        if (colspan == -1) {
            colspan = this.columns.size() - startColumn;
        }
        return colspan;
    }

    private int startNewRowIfCurrentRowFull(int startColumn) {
        if (startColumn == this.columns.size()) {
            startColumn = 0;
        }
        return startColumn;
    }

    private void checkColumnSpan(int startColumn, int colspan) {
        if (startColumn + colspan > this.columns.size()) {
            PaperClips.error(5, "Colspan " + colspan + " too wide at column " + startColumn + " (" + this.columns.size() + " columns total)");
        }
    }

    private List getOpenRow(List rows, int startColumn) {
        ArrayList row;
        if (startColumn == 0) {
            row = new ArrayList(this.columns.size());
            rows.add(row);
        } else {
            row = (ArrayList)rows.get(rows.size() - 1);
        }
        return row;
    }

    public int[][] getColumnGroups() {
        return ArrayUtil.defensiveCopy(this.columnGroups);
    }

    public void setColumnGroups(int[][] columnGroups) {
        this.checkColumnGroups(columnGroups);
        this.columnGroups = ArrayUtil.defensiveCopy(columnGroups);
    }

    private void checkColumnGroups(int[][] columnGroups) {
        NullUtil.notNull(columnGroups);
        int groupIndex = 0;
        while (groupIndex < columnGroups.length) {
            this.checkColumnGroup(columnGroups[groupIndex]);
            ++groupIndex;
        }
    }

    private void checkColumnGroup(int[] columnGroup) {
        NullUtil.notNull(columnGroup);
        int columnInGroupIndex = 0;
        while (columnInGroupIndex < columnGroup.length) {
            this.checkColumnIndex(columnGroup[columnInGroupIndex]);
            ++columnInGroupIndex;
        }
    }

    private void checkColumnIndex(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columns.size()) {
            PaperClips.error(6, "Column index in column group must be 0 <= " + columnIndex + " < " + this.columns.size());
        }
    }

    public Border getCellBorder() {
        return this.defaultLook.getCellBorder();
    }

    public void setCellBorder(Border border) {
        this.defaultLook.setCellBorder(border);
    }

    public int getHorizontalSpacing() {
        return this.defaultLook.getCellSpacing().x;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.defaultLook.setCellSpacing(horizontalSpacing, this.defaultLook.getCellSpacing().y);
    }

    public int getVerticalSpacing() {
        return this.defaultLook.getCellSpacing().y;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.defaultLook.setCellSpacing(this.defaultLook.getCellSpacing().x, verticalSpacing);
    }

    public GridLook getLook() {
        return this.look;
    }

    public void setLook(GridLook look) {
        NullUtil.notNull(look);
        this.look = look;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new GridIterator(this, device, gc);
    }
}

