/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.GridLookPainter;
import net.sf.paperclips.GridMargins;
import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.ArrayUtil;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class GridLookPainterPiece
implements PrintPiece {
    final GridLookPainter look;
    final int[] columns;
    final int[] headerRows;
    final int[][] headerColSpans;
    final int firstRowIndex;
    final boolean topOpen;
    final int[] bodyRows;
    final int[][] bodyColSpans;
    final boolean bottomOpen;
    final int[] footerRows;
    final int[][] footerColSpans;
    final Point size;

    GridLookPainterPiece(GridLookPainter look, int[] colSizes, int[] headerRows, int[][] headerColSpans, int firstRowIndex, boolean topOpen, int[] bodyRows, int[][] bodyColSpans, boolean bottomOpen, int[] footerRows, int[][] footerColSpans) {
        Point size;
        NullUtil.notNull(look);
        this.look = look;
        this.columns = ArrayUtil.defensiveCopy(colSizes);
        this.headerRows = ArrayUtil.defensiveCopy(headerRows);
        this.headerColSpans = ArrayUtil.defensiveCopy(headerColSpans);
        this.firstRowIndex = firstRowIndex;
        this.topOpen = topOpen;
        this.bodyRows = ArrayUtil.defensiveCopy(bodyRows);
        this.bodyColSpans = ArrayUtil.defensiveCopy(bodyColSpans);
        this.bottomOpen = bottomOpen;
        this.footerRows = ArrayUtil.defensiveCopy(footerRows);
        this.footerColSpans = ArrayUtil.defensiveCopy(footerColSpans);
        GridMargins margins = look.getMargins();
        this.size = size = GridLookPainterPiece.calculateSize(margins, colSizes, headerRows, topOpen, bodyRows, bottomOpen, footerRows);
    }

    private static Point calculateSize(GridMargins margins, int[] columns, int[] headerRows, boolean topOpen, int[] bodyRows, boolean bottomOpen, int[] footerRows) {
        boolean headerPresent = headerRows.length > 0;
        boolean footerPresent = footerRows.length > 0;
        int width = GridLookPainterPiece.calculateWidth(margins, columns);
        int height = GridLookPainterPiece.calculateBodyHeight(margins, topOpen, bodyRows, bottomOpen, headerPresent, footerPresent);
        if (headerPresent) {
            height += GridLookPainterPiece.calculateHeaderHeight(margins, headerRows);
        }
        if (footerPresent) {
            height += GridLookPainterPiece.calculateFooterHeight(margins, footerRows);
        }
        return new Point(width, height);
    }

    private static int calculateWidth(GridMargins margins, int[] columns) {
        return margins.getLeft() + margins.getHorizontalSpacing() * (columns.length - 1) + margins.getRight() + ArrayUtil.sum(columns);
    }

    private static int calculateBodyHeight(GridMargins margins, boolean topOpen, int[] bodyRows, boolean bottomOpen, boolean headerPresent, boolean footerPresent) {
        return margins.getBodyTop(headerPresent, topOpen) + margins.getBodyVerticalSpacing() * (bodyRows.length - 1) + margins.getBodyBottom(footerPresent, bottomOpen) + ArrayUtil.sum(bodyRows);
    }

    private static int calculateHeaderHeight(GridMargins margins, int[] headerRows) {
        return margins.getHeaderTop() + margins.getHeaderVerticalSpacing() * (headerRows.length - 1) + ArrayUtil.sum(headerRows);
    }

    private static int calculateFooterHeight(GridMargins margins, int[] footerRows) {
        return margins.getFooterVerticalSpacing() * (footerRows.length - 1) + margins.getFooterBottom() + ArrayUtil.sum(footerRows);
    }

    public void dispose() {
        this.look.dispose();
    }

    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    public void paint(GC gc, int x, int y) {
        this.look.paint(gc, x, y, this.columns, this.headerRows, this.headerColSpans, this.firstRowIndex, this.topOpen, this.bodyRows, this.bodyColSpans, this.bottomOpen, this.footerRows, this.footerColSpans);
    }
}

