/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.GridCellIterator;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.internal.BitUtil;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class GridCell {
    final int hAlignment;
    final int vAlignment;
    final Print target;
    final int colspan;

    GridCell(int hAlignment, int vAlignment, Print target, int colspan) {
        NullUtil.notNull(target);
        this.hAlignment = GridCell.checkHorizontalAlignment(hAlignment);
        this.vAlignment = GridCell.checkVerticalAlignment(vAlignment);
        this.target = target;
        this.colspan = this.checkColspan(colspan);
    }

    public Point getAlignment() {
        return new Point(this.hAlignment, this.vAlignment);
    }

    public int getHorizontalAlignment() {
        return this.hAlignment;
    }

    public int getVerticalAlignment() {
        return this.vAlignment;
    }

    public Print getContent() {
        return this.target;
    }

    public int getColSpan() {
        return this.colspan;
    }

    private static int checkHorizontalAlignment(int hAlignment) {
        if ((hAlignment = BitUtil.firstMatch(hAlignment, new int[]{-1, 16384, 0x1000000, 131072}, 0)) == 0) {
            PaperClips.error(5, "Alignment argument must be one of SWT.LEFT, SWT.CENTER, SWT.RIGHT, or SWT.DEFAULT");
        }
        return hAlignment;
    }

    private static int checkVerticalAlignment(int vAlignment) {
        if ((vAlignment = BitUtil.firstMatch(vAlignment, new int[]{-1, 128, 0x1000000, 1024, 4}, 0)) == 0) {
            PaperClips.error(5, "Alignment argument must be one of SWT.TOP, SWT.CENTER, SWT.BOTTOM, SWT.DEFAULT, or SWT.FILL");
        }
        return vAlignment;
    }

    private int checkColspan(int colspan) {
        if (colspan <= 0 && colspan != -1) {
            PaperClips.error(5, "colspan must be a positive number or GridPrint.REMAINDER");
        }
        return colspan;
    }

    GridCellIterator iterator(Device device, GC gc) {
        return new GridCellIterator(this, device, gc);
    }
}

