/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.Border;
import net.sf.paperclips.CellBackgroundProvider;
import net.sf.paperclips.DefaultCellBackgroundProvider;
import net.sf.paperclips.DefaultGridLookPainter;
import net.sf.paperclips.GapBorder;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridLookPainter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class DefaultGridLook
implements GridLook {
    public static final int BORDER_OVERLAP = -1;
    Point cellSpacing = new Point(-1, -1);
    Rectangle cellPadding = new Rectangle(0, 0, 0, 0);
    int headerGap = -1;
    int footerGap = -1;
    Border cellBorder = new GapBorder();
    DefaultCellBackgroundProvider defaultBodyBackgroundProvider = new DefaultCellBackgroundProvider();
    DefaultCellBackgroundProvider defaultHeaderBackgroundProvider;
    DefaultCellBackgroundProvider defaultFooterBackgroundProvider;
    CellBackgroundProvider bodyBackgroundProvider = this.defaultBodyBackgroundProvider;
    CellBackgroundProvider headerBackgroundProvider;
    CellBackgroundProvider footerBackgroundProvider;

    public DefaultGridLook() {
        this.defaultHeaderBackgroundProvider = new DefaultCellBackgroundProvider(this.bodyBackgroundProvider);
        this.headerBackgroundProvider = this.defaultHeaderBackgroundProvider;
        this.defaultFooterBackgroundProvider = new DefaultCellBackgroundProvider(this.bodyBackgroundProvider);
        this.footerBackgroundProvider = this.defaultFooterBackgroundProvider;
    }

    public DefaultGridLook(int horizontalSpacing, int verticalSpacing) {
        this();
        this.setCellSpacing(horizontalSpacing, verticalSpacing);
    }

    public Border getCellBorder() {
        return this.cellBorder;
    }

    public void setCellBorder(Border border) {
        this.cellBorder = border;
    }

    public Point getCellSpacing() {
        return new Point(this.cellSpacing.x, this.cellSpacing.y);
    }

    public void setCellSpacing(Point cellSpacing) {
        this.setCellSpacing(cellSpacing.x, cellSpacing.y);
    }

    public void setCellSpacing(int horizontal, int vertical) {
        if (horizontal == -1 || horizontal >= 0) {
            this.cellSpacing.x = horizontal;
        }
        if (vertical == -1 || vertical >= 0) {
            this.cellSpacing.y = vertical;
        }
    }

    public Rectangle getCellPadding() {
        return new Rectangle(this.cellPadding.x, this.cellPadding.y, this.cellPadding.width, this.cellPadding.height);
    }

    public void setCellPadding(Rectangle cellPadding) {
        this.setCellPadding(cellPadding.x, cellPadding.y, cellPadding.width, cellPadding.height);
    }

    public void setCellPadding(int horizontalPadding, int verticalPadding) {
        this.setCellPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
    }

    public void setCellPadding(int left, int top, int right, int bottom) {
        this.cellPadding.x = left;
        this.cellPadding.y = top;
        this.cellPadding.width = right;
        this.cellPadding.height = bottom;
    }

    public RGB getHeaderBackground() {
        return this.defaultHeaderBackgroundProvider.getBackground();
    }

    public void setHeaderBackground(RGB headerBackground) {
        this.defaultHeaderBackgroundProvider.setBackground(headerBackground);
        this.headerBackgroundProvider = this.defaultHeaderBackgroundProvider;
    }

    public CellBackgroundProvider getHeaderBackgroundProvider() {
        return this.headerBackgroundProvider;
    }

    public void setHeaderBackgroundProvider(CellBackgroundProvider headerBackgroundProvider) {
        this.headerBackgroundProvider = headerBackgroundProvider == null ? this.defaultHeaderBackgroundProvider : headerBackgroundProvider;
    }

    public int getHeaderGap() {
        return this.headerGap;
    }

    public void setHeaderGap(int headerGap) {
        this.headerGap = headerGap;
    }

    public RGB getBodyBackground() {
        return this.defaultBodyBackgroundProvider.getBackground();
    }

    public void setBodyBackground(RGB bodyBackground) {
        this.defaultBodyBackgroundProvider.setBackground(bodyBackground);
        this.bodyBackgroundProvider = this.defaultBodyBackgroundProvider;
    }

    public CellBackgroundProvider getBodyBackgroundProvider() {
        return this.bodyBackgroundProvider;
    }

    public void setBodyBackgroundProvider(CellBackgroundProvider bodyBackgroundProvider) {
        this.bodyBackgroundProvider = bodyBackgroundProvider == null ? this.defaultBodyBackgroundProvider : bodyBackgroundProvider;
    }

    public int getFooterGap() {
        return this.footerGap;
    }

    public void setFooterGap(int footerGap) {
        this.footerGap = footerGap;
    }

    public RGB getFooterBackground() {
        return this.defaultFooterBackgroundProvider.getBackground();
    }

    public void setFooterBackground(RGB footerBackground) {
        this.defaultFooterBackgroundProvider.setBackground(footerBackground);
        this.footerBackgroundProvider = this.defaultFooterBackgroundProvider;
    }

    public CellBackgroundProvider getFooterBackgroundProvider() {
        return this.footerBackgroundProvider;
    }

    public void setFooterBackgroundProvider(CellBackgroundProvider footerBackgroundProvider) {
        this.footerBackgroundProvider = footerBackgroundProvider == null ? this.defaultFooterBackgroundProvider : footerBackgroundProvider;
    }

    public GridLookPainter getPainter(Device device, GC gc) {
        return new DefaultGridLookPainter(this, device, gc);
    }
}

