/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.ColumnIterator;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class ColumnPrint
implements Print {
    final Print target;
    final int columns;
    final int spacing;
    boolean compressed;

    public ColumnPrint(Print target, int columns, int spacing) {
        this(target, columns, spacing, true);
    }

    public ColumnPrint(Print target, int columns, int spacing, boolean compressed) {
        NullUtil.notNull(target);
        if (spacing < 0) {
            PaperClips.error(5, "spacing must be >= 0");
        }
        if (columns < 2) {
            PaperClips.error(5, "columns must be >= 2");
        }
        this.target = target;
        this.spacing = spacing;
        this.columns = columns;
        this.compressed = compressed;
    }

    public Print getTarget() {
        return this.target;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getColumnSpacing() {
        return this.spacing;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return new ColumnIterator(this, device, gc);
    }
}

