/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.BorderPainter;
import net.sf.paperclips.BorderPiece;
import net.sf.paperclips.BorderPrint;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.PrintPiece;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

class BorderIterator
implements PrintIterator {
    private final BorderPainter border;
    private PrintIterator target;
    private boolean opened;

    BorderIterator(BorderPrint print, Device device, GC gc) {
        this.border = print.border.createPainter(device, gc);
        this.target = print.target.iterator(device, gc);
        this.opened = false;
    }

    BorderIterator(BorderIterator that) {
        this.border = that.border;
        this.target = that.target.copy();
        this.opened = that.opened;
    }

    public boolean hasNext() {
        return this.target.hasNext();
    }

    public Point minimumSize() {
        return this.addBorderMargin(this.target.minimumSize());
    }

    public Point preferredSize() {
        return this.addBorderMargin(this.target.preferredSize());
    }

    private Point addBorderMargin(Point targetSize) {
        return new Point(targetSize.x + this.border.getWidth(), targetSize.y + this.border.getMaxHeight());
    }

    public PrintPiece next(int width, int height) {
        PrintPiece piece;
        if (!this.hasNext()) {
            PaperClips.error("No more content");
        }
        if ((piece = this.next(width, height, false)) == null) {
            piece = this.next(width, height, true);
        }
        this.opened = piece != null;
        return piece;
    }

    private PrintPiece next(int width, int height, boolean bottomBorderOpen) {
        if ((width -= this.border.getWidth()) < 0 || (height -= this.border.getHeight(this.opened, bottomBorderOpen)) < 0) {
            return null;
        }
        PrintIterator testIterator = this.target.copy();
        PrintPiece piece = PaperClips.next(testIterator, width, height);
        if (piece == null) {
            return null;
        }
        if (bottomBorderOpen && !testIterator.hasNext()) {
            piece.dispose();
            piece = this.getTallestPieceNotCompletelyConsumingTarget(width, height);
            if (piece == null) {
                return null;
            }
        } else {
            if (!bottomBorderOpen && testIterator.hasNext()) {
                piece.dispose();
                return null;
            }
            this.target = testIterator;
        }
        piece = new BorderPiece(piece, this.border, this.opened, bottomBorderOpen);
        return piece;
    }

    private PrintPiece getTallestPieceNotCompletelyConsumingTarget(int width, int height) {
        int low = 0;
        int high = height - 1;
        PrintIterator bestIterator = null;
        PrintPiece bestPiece = null;
        while (low + 1 < high) {
            int testHeight = (low + high + 1) / 2;
            PrintIterator testIterator = this.target.copy();
            PrintPiece testPiece = PaperClips.next(testIterator, width, testHeight);
            if (testPiece == null) {
                low = testHeight + 1;
                continue;
            }
            if (testIterator.hasNext()) {
                low = testHeight;
                if (bestPiece != null) {
                    bestPiece.dispose();
                }
                bestIterator = testIterator;
                bestPiece = testPiece;
                continue;
            }
            high = testPiece.getSize().y - 1;
        }
        if (bestPiece != null) {
            this.target = bestIterator;
        }
        return bestPiece;
    }

    public PrintIterator copy() {
        return new BorderIterator(this);
    }
}

