/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.PrintPiece;
import net.sf.paperclips.internal.NullUtil;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;

class BigPiece
implements PrintPiece {
    private final PrintPiece target;
    private final Point size;
    private final Point offset;

    BigPiece(PrintPiece target, Point size, int xOffset, int yOffset) {
        NullUtil.notNull(target, size);
        this.target = target;
        this.size = new Point(size.x, size.y);
        this.offset = new Point(xOffset, yOffset);
    }

    public Point getSize() {
        return new Point(this.size.x, this.size.y);
    }

    public void paint(GC gc, int x, int y) {
        Region region = new Region();
        gc.getClipping(region);
        gc.setClipping(x, y, this.size.x, this.size.y);
        this.target.paint(gc, x - this.offset.x, y - this.offset.y);
        gc.setClipping(region);
        region.dispose();
    }

    public void dispose() {
        this.target.dispose();
    }
}

