/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.wireadmin;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.wireadmin.EventManager;
import org.apache.felix.wireadmin.WireImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.wireadmin.Consumer;
import org.osgi.service.wireadmin.Producer;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdmin;

public class WireAdminImpl
implements WireAdmin,
ServiceListener {
    private BundleContext m_bundleContext;
    private Map m_consumers;
    private Map m_producers;
    private List m_wires;
    private Filter m_consumerFilter;
    private Filter m_producerFilter;
    private EventManager m_eventManager;
    private static int m_wireCount = 0;
    private AsyncMethodCaller m_asyncMethodCaller;
    private static PrintStream m_traceout = null;
    private static PrintStream m_errorout = System.err;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WireAdminImpl(BundleContext bundleContext) {
        block20: {
            String value;
            this.m_consumers = new HashMap();
            this.m_producers = new HashMap();
            this.m_asyncMethodCaller = new AsyncMethodCaller();
            this.m_bundleContext = bundleContext;
            if (bundleContext.getProperty("fr.imag.adele.wireadmin.trace") != null && (value = bundleContext.getProperty("fr.imag.adele.wireadmin.trace")).equals("true")) {
                m_traceout = System.out;
            }
            this.m_eventManager = new EventManager(this.m_bundleContext);
            try {
                this.m_producerFilter = this.m_bundleContext.createFilter("(objectClass=org.osgi.service.wireadmin.Producer)");
                this.m_consumerFilter = this.m_bundleContext.createFilter("(objectClass=org.osgi.service.wireadmin.Consumer)");
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.getPersistentWires();
            new Thread(this.m_asyncMethodCaller).start();
            try {
                ServiceReference[] consumerRefs;
                Object currentRef;
                int i;
                this.m_bundleContext.addServiceListener((ServiceListener)this, "(|" + this.m_producerFilter.toString() + this.m_consumerFilter.toString() + ")");
                ServiceReference[] producerRefs = this.m_bundleContext.getServiceReferences(Producer.class.getName(), null);
                if (producerRefs != null) {
                    Map map = this.m_producers;
                    synchronized (map) {
                        i = 0;
                        while (i < producerRefs.length) {
                            currentRef = producerRefs[i];
                            for (WireImpl currentWire : this.m_wires) {
                                if (!currentWire.getProducerPID().equals(currentRef.getProperty("service.pid"))) continue;
                                currentWire.bindProducer((ServiceReference)currentRef);
                            }
                            this.m_producers.put(currentRef, new ArrayList());
                            ++i;
                        }
                    }
                }
                if ((consumerRefs = this.m_bundleContext.getServiceReferences(Consumer.class.getName(), null)) == null) break block20;
                i = 0;
                while (i < consumerRefs.length) {
                    currentRef = this.m_consumers;
                    synchronized (currentRef) {
                        ServiceReference currentRef2 = consumerRefs[i];
                        for (WireImpl currentWire : this.m_wires) {
                            if (!currentWire.getConsumerPID().equals(currentRef2.getProperty("service.pid"))) continue;
                            currentWire.bindConsumer(currentRef2);
                        }
                        this.m_consumers.put(currentRef2, new ArrayList());
                    }
                    ++i;
                }
            }
            catch (InvalidSyntaxException e) {
                WireAdminImpl.trace((Exception)((Object)e));
            }
        }
        List list = this.m_wires;
        synchronized (list) {
            for (WireImpl currentWire : this.m_wires) {
                if (!currentWire.isConnected()) continue;
                List wires = (List)this.m_producers.get(currentWire.getProducerServiceRef());
                wires.add(currentWire);
                this.m_asyncMethodCaller.consumersConnected(currentWire.getProducer(), wires.toArray(new Wire[wires.size()]));
                wires = (List)this.m_consumers.get(currentWire.getConsumerServiceRef());
                wires.add(currentWire);
                this.m_asyncMethodCaller.producersConnected(currentWire.getConsumer(), wires.toArray(new Wire[wires.size()]));
            }
        }
    }

    void setServiceReference(ServiceReference ref) {
        this.m_eventManager.setServiceReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wire createWire(String producerPID, String consumerPID, Dictionary props) {
        ServiceReference producerServiceRef2 = null;
        ServiceReference consumerServiceRef2 = null;
        Dictionary properties = props == null ? new Hashtable() : this.cloneProperties(props);
        properties.put("wireadmin.consumer.pid", consumerPID);
        properties.put("wireadmin.producer.pid", producerPID);
        properties.put("wireadmin.pid", this.generateWirePID());
        WireImpl wire = new WireImpl(producerPID, consumerPID, properties);
        wire.initialize(this.m_bundleContext, this.m_eventManager);
        Object object = this.m_wires;
        synchronized (object) {
            this.m_wires.add(wire);
        }
        this.m_eventManager.fireEvent(4, wire);
        object = this.m_producers;
        synchronized (object) {
            for (ServiceReference producerServiceRef2 : this.m_producers.keySet()) {
                if (!producerServiceRef2.getProperty("service.pid").equals(producerPID)) continue;
                wire.bindProducer(producerServiceRef2);
                break;
            }
        }
        object = this.m_consumers;
        synchronized (object) {
            for (ServiceReference consumerServiceRef2 : this.m_consumers.keySet()) {
                if (!consumerServiceRef2.getProperty("service.pid").equals(consumerPID)) continue;
                wire.bindConsumer(consumerServiceRef2);
                break;
            }
        }
        if (wire.isConnected()) {
            List wires = (List)this.m_producers.get(producerServiceRef2);
            wires.add(wire);
            this.m_asyncMethodCaller.consumersConnected(wire.getProducer(), wires.toArray(new Wire[wires.size()]));
            wires = (List)this.m_consumers.get(consumerServiceRef2);
            wires.add(wire);
            this.m_asyncMethodCaller.producersConnected(wire.getConsumer(), wires.toArray(new Wire[wires.size()]));
        }
        this.persistWires();
        return wire;
    }

    public void deleteWire(Wire wire) {
        if (this.m_wires.contains(wire)) {
            WireImpl wireImpl = (WireImpl)wire;
            this.m_wires.remove(wire);
            if (wireImpl.isConnected()) {
                List wires = (List)this.m_producers.get(wireImpl.getProducerServiceRef());
                wires.remove(wireImpl);
                this.m_asyncMethodCaller.consumersConnected(wireImpl.getProducer(), wires.toArray(new Wire[wires.size()]));
                wires = (List)this.m_consumers.get(wireImpl.getConsumerServiceRef());
                wires.remove(wireImpl);
                this.m_asyncMethodCaller.producersConnected(wireImpl.getConsumer(), wires.toArray(new Wire[wires.size()]));
            }
            wireImpl.invalidate();
            this.m_eventManager.fireEvent(16, wireImpl);
            this.persistWires();
        } else {
            WireAdminImpl.traceln("WireAdminImpl: Cannot delete a wire that is not managed by this service");
        }
    }

    public void updateWire(Wire wire, Dictionary props) {
        if (!this.m_wires.contains(wire)) {
            WireAdminImpl.traceln("WireAdminImpl: Cannot update a wire that is not managed by this service");
            return;
        }
        Dictionary properties = this.cloneProperties(props);
        properties.put("wireadmin.consumer.pid", wire.getProperties().get("wireadmin.consumer.pid"));
        properties.put("wireadmin.producer.pid", wire.getProperties().get("wireadmin.producer.pid"));
        properties.put("wireadmin.pid", wire.getProperties().get("wireadmin.pid"));
        WireImpl wireImpl = (WireImpl)wire;
        wireImpl.updateProperties(properties);
        if (wireImpl.isConnected()) {
            List wires = (List)this.m_producers.get(wireImpl.getProducerServiceRef());
            this.m_asyncMethodCaller.consumersConnected(wireImpl.getProducer(), wires.toArray(new Wire[wires.size()]));
            wires = (List)this.m_consumers.get(wireImpl.getConsumerServiceRef());
            this.m_asyncMethodCaller.producersConnected(wireImpl.getConsumer(), wires.toArray(new Wire[wires.size()]));
        }
        this.m_eventManager.fireEvent(8, wireImpl);
    }

    public Wire[] getWires(String filter) throws InvalidSyntaxException {
        ArrayList<WireImpl> res = null;
        if (filter == null) {
            return this.m_wires.toArray(new Wire[this.m_wires.size()]);
        }
        Filter tempFilter = this.m_bundleContext.createFilter(filter);
        for (WireImpl currentWire : this.m_wires) {
            if (!tempFilter.match(currentWire.getProperties())) continue;
            if (res == null) {
                res = new ArrayList<WireImpl>();
            }
            res.add(currentWire);
        }
        if (res == null) {
            return null;
        }
        return res.toArray(new Wire[res.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent e) {
        WireImpl currentWire;
        Iterator wireIt;
        Object object;
        ArrayList<WireImpl> wires;
        ServiceReference serviceRef = e.getServiceReference();
        if (this.m_consumerFilter.match(serviceRef)) {
            switch (e.getType()) {
                case 1: {
                    WireAdminImpl.traceln("consumer registered");
                    wires = new ArrayList<WireImpl>();
                    object = this.m_consumers;
                    synchronized (object) {
                        this.m_consumers.put(serviceRef, wires);
                    }
                    object = this.m_wires;
                    synchronized (object) {
                        wireIt = this.m_wires.iterator();
                        boolean called = false;
                        while (wireIt.hasNext()) {
                            currentWire = (WireImpl)wireIt.next();
                            if (!currentWire.getConsumerPID().equals(serviceRef.getProperty("service.pid"))) continue;
                            currentWire.bindConsumer(serviceRef);
                            if (!currentWire.isConnected()) continue;
                            wires.add(currentWire);
                            called = true;
                            this.m_asyncMethodCaller.producersConnected(currentWire.getConsumer(), wires.toArray(new Wire[wires.size()]));
                            List producerWires = (List)this.m_producers.get(currentWire.getProducerServiceRef());
                            producerWires.add(currentWire);
                            this.m_asyncMethodCaller.consumersConnected(currentWire.getProducer(), producerWires.toArray(new Wire[producerWires.size()]));
                        }
                        if (!called) {
                            this.m_asyncMethodCaller.producersConnected((Consumer)this.m_bundleContext.getService(serviceRef), null);
                        }
                        break;
                    }
                }
                case 4: {
                    WireAdminImpl.traceln("consumer unregistering");
                    object = this.m_consumers;
                    synchronized (object) {
                        this.m_consumers.remove(serviceRef);
                    }
                    object = this.m_wires;
                    synchronized (object) {
                        for (WireImpl currentWire2 : this.m_wires) {
                            if (!currentWire2.getConsumerPID().equals(serviceRef.getProperty("service.pid"))) continue;
                            if (currentWire2.isConnected()) {
                                currentWire2.unbindConsumer();
                                List producerWires = (List)this.m_producers.get(currentWire2.getProducerServiceRef());
                                producerWires.remove(currentWire2);
                                this.m_asyncMethodCaller.consumersConnected(currentWire2.getProducer(), producerWires.toArray(new Wire[producerWires.size()]));
                                continue;
                            }
                            currentWire2.unbindConsumer();
                        }
                        break;
                    }
                }
                case 2: {
                    WireAdminImpl.traceln("consumer service modified");
                }
            }
        }
        if (this.m_producerFilter.match(serviceRef)) {
            switch (e.getType()) {
                case 1: {
                    WireAdminImpl.traceln("producer registered");
                    wires = new ArrayList();
                    object = this.m_producers;
                    synchronized (object) {
                        this.m_producers.put(serviceRef, wires);
                    }
                    object = this.m_wires;
                    synchronized (object) {
                        wireIt = this.m_wires.iterator();
                        boolean called = false;
                        while (wireIt.hasNext()) {
                            currentWire = (WireImpl)wireIt.next();
                            if (!currentWire.getProducerPID().equals(serviceRef.getProperty("service.pid"))) continue;
                            currentWire.bindProducer(serviceRef);
                            if (!currentWire.isConnected()) continue;
                            wires.add(currentWire);
                            called = true;
                            this.m_asyncMethodCaller.consumersConnected(currentWire.getProducer(), wires.toArray(new Wire[wires.size()]));
                            List consumerWires = (List)this.m_consumers.get(currentWire.getConsumerServiceRef());
                            consumerWires.add(currentWire);
                            this.m_asyncMethodCaller.producersConnected(currentWire.getConsumer(), consumerWires.toArray(new Wire[consumerWires.size()]));
                        }
                        if (!called) {
                            this.m_asyncMethodCaller.consumersConnected((Producer)this.m_bundleContext.getService(serviceRef), null);
                        }
                        break;
                    }
                }
                case 4: {
                    WireAdminImpl.traceln("Producer unregistering");
                    object = this.m_producers;
                    synchronized (object) {
                        this.m_producers.remove(serviceRef);
                    }
                    object = this.m_wires;
                    synchronized (object) {
                        for (WireImpl currentWire3 : this.m_wires) {
                            if (!currentWire3.getProducerPID().equals(serviceRef.getProperty("service.pid"))) continue;
                            if (currentWire3.isConnected()) {
                                currentWire3.unbindProducer();
                                List consumerWires = (List)this.m_consumers.get(currentWire3.getConsumerServiceRef());
                                consumerWires.remove(currentWire3);
                                this.m_asyncMethodCaller.producersConnected(currentWire3.getConsumer(), consumerWires.toArray(new Wire[consumerWires.size()]));
                                continue;
                            }
                            currentWire3.unbindProducer();
                        }
                        break;
                    }
                }
                case 2: {
                    WireAdminImpl.traceln("producer service modified");
                }
            }
        }
    }

    synchronized void releaseAll() {
        for (WireImpl currentWire : this.m_wires) {
            currentWire.invalidate();
        }
        for (ServiceReference producerRef : this.m_producers.keySet()) {
            ((Producer)this.m_bundleContext.getService(producerRef)).consumersConnected(null);
        }
        for (ServiceReference consumerRef : this.m_consumers.keySet()) {
            ((Consumer)this.m_bundleContext.getService(consumerRef)).producersConnected(null);
        }
        this.m_asyncMethodCaller.stop();
        this.m_eventManager.stop();
        this.persistWires();
    }

    private String generateWirePID() {
        Date d = new Date();
        String PID = "wire." + this.m_bundleContext.getBundle().getBundleId() + d.hashCode() + m_wireCount;
        if (++m_wireCount > 9) {
            m_wireCount = 0;
        }
        return PID;
    }

    private void getPersistentWires() {
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.m_bundleContext.getDataFile("wires.ser")));
            this.m_wires = (ArrayList)ois.readObject();
            ois.close();
            if (this.m_wires != null) {
                WireAdminImpl.traceln("Deserialized " + this.m_wires.size() + " wires");
                for (WireImpl currentWire : this.m_wires) {
                    currentWire.initialize(this.m_bundleContext, this.m_eventManager);
                }
            } else {
                WireAdminImpl.traceln("Couldn't Deserialize wires");
                this.m_wires = new ArrayList();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_wires = new ArrayList();
        }
        catch (Exception ex) {
            WireAdminImpl.trace(ex);
            this.m_wires = new ArrayList();
        }
    }

    private void persistWires() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.m_bundleContext.getDataFile("wires.ser")));
            oos.writeObject(this.m_wires);
            oos.close();
            WireAdminImpl.traceln("Serialized " + this.m_wires.size() + " wires");
        }
        catch (Exception ex) {
            WireAdminImpl.trace(ex);
        }
    }

    static void error(String message) {
        if (m_errorout != null) {
            m_errorout.println(message);
        }
    }

    static void traceln(String message) {
        if (m_traceout != null) {
            WireAdminImpl.trace(message);
            WireAdminImpl.trace("\n");
        }
    }

    static void trace(String message) {
        if (m_traceout != null) {
            m_traceout.print(message);
        }
    }

    static void trace(Exception e) {
        if (m_traceout != null) {
            e.printStackTrace(m_traceout);
        }
    }

    private Dictionary cloneProperties(Dictionary dictionary) {
        Hashtable properties = new Hashtable();
        if (dictionary == null) {
            properties = new Hashtable();
        } else {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Object value = dictionary.get(key);
                ((Dictionary)properties).put(key, value);
            }
        }
        return properties;
    }

    class AsyncMethodCaller
    implements Runnable {
        private boolean m_stop = false;
        private List m_methodCallStack = new ArrayList();

        AsyncMethodCaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (!this.m_stop) {
                Object[] nextTarget = null;
                List list = this.m_methodCallStack;
                synchronized (list) {
                    while (true) {
                        if (this.m_methodCallStack.size() != 0) {
                            nextTarget = (Object[])this.m_methodCallStack.remove(0);
                            break;
                        }
                        try {
                            this.m_methodCallStack.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (nextTarget[0] instanceof Producer) {
                    try {
                        ((Producer)nextTarget[0]).consumersConnected((Wire[])nextTarget[1]);
                    }
                    catch (Exception ex) {
                        WireAdminImpl.trace(ex);
                    }
                }
                if (!(nextTarget[0] instanceof Consumer)) continue;
                try {
                    ((Consumer)nextTarget[0]).producersConnected((Wire[])nextTarget[1]);
                }
                catch (Exception ex) {
                    WireAdminImpl.trace(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void producersConnected(Consumer c, Wire[] wires) {
            List list = this.m_methodCallStack;
            synchronized (list) {
                this.m_methodCallStack.add(new Object[]{c, wires});
                this.m_methodCallStack.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumersConnected(Producer p, Wire[] wires) {
            List list = this.m_methodCallStack;
            synchronized (list) {
                this.m_methodCallStack.add(new Object[]{p, wires});
                this.m_methodCallStack.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            List list = this.m_methodCallStack;
            synchronized (list) {
                this.m_stop = true;
                this.m_methodCallStack.add(new Object[]{"", new Wire[0]});
                this.m_methodCallStack.notify();
            }
        }
    }
}

