/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.wireadmin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.wireadmin.WireAdminImpl;
import org.apache.felix.wireadmin.WireImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;

class EventManager
implements ServiceListener {
    private Map m_wireAdminListeners = new HashMap();
    private BundleContext m_bundleContext;
    private AsyncDispatcher m_eventDispatcher = new AsyncDispatcher();
    private ServiceReference m_ref;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventManager(BundleContext ctxt) {
        this.m_bundleContext = ctxt;
        ServiceReference[] serviceRefs = null;
        try {
            this.m_bundleContext.addServiceListener((ServiceListener)this, "(objectClass=org.osgi.service.wireadmin.WireAdminListener)");
            serviceRefs = this.m_bundleContext.getServiceReferences(WireAdminListener.class.getName(), null);
        }
        catch (Exception exception) {}
        if (serviceRefs != null) {
            Map map = this.m_wireAdminListeners;
            synchronized (map) {
                int i = 0;
                while (i < serviceRefs.length) {
                    ServiceReference currentRef = serviceRefs[i];
                    this.m_wireAdminListeners.put(currentRef, this.m_bundleContext.getService(currentRef));
                    ++i;
                }
            }
        }
    }

    void setServiceReference(ServiceReference ref) {
        this.m_ref = ref;
        new Thread(this.m_eventDispatcher).start();
    }

    void stop() {
        this.m_eventDispatcher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent e) {
        ServiceReference serviceRef = e.getServiceReference();
        switch (e.getType()) {
            case 1: {
                Map map = this.m_wireAdminListeners;
                synchronized (map) {
                    this.m_wireAdminListeners.put(serviceRef, this.m_bundleContext.getService(serviceRef));
                    break;
                }
            }
            case 4: {
                Map map = this.m_wireAdminListeners;
                synchronized (map) {
                    this.m_wireAdminListeners.remove(serviceRef);
                    break;
                }
            }
        }
    }

    void fireEvent(int eventType, WireImpl wire) {
        this.fireEvent(eventType, wire, null);
    }

    void fireEvent(int eventType, WireImpl wire, Throwable exception) {
        WireAdminEvent evt = new WireAdminEvent(this.m_ref, eventType, (Wire)wire, exception);
        this.m_eventDispatcher.queueEvent(evt);
    }

    class AsyncDispatcher
    implements Runnable {
        private boolean m_stop = false;
        private boolean m_empty = true;
        private List m_eventStack = new ArrayList();

        AsyncDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block10: while (!this.m_stop || this.m_stop && !this.m_empty) {
                WireAdminEvent nextEvent = null;
                Object object = this.m_eventStack;
                synchronized (object) {
                    while (true) {
                        if (this.m_eventStack.size() != 0) {
                            nextEvent = (WireAdminEvent)this.m_eventStack.remove(0);
                            if (this.m_eventStack.size() == 0) {
                                this.m_empty = true;
                            }
                            break;
                        }
                        try {
                            this.m_eventStack.wait();
                            if (!this.m_stop || this.m_eventStack.size() != 0) continue;
                            return;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                object = EventManager.this.m_wireAdminListeners;
                synchronized (object) {
                    Iterator listenerIt = EventManager.this.m_wireAdminListeners.keySet().iterator();
                    while (true) {
                        if (!listenerIt.hasNext()) {
                            continue block10;
                        }
                        ServiceReference listenerRef = (ServiceReference)listenerIt.next();
                        WireAdminListener listener = (WireAdminListener)EventManager.this.m_wireAdminListeners.get(listenerRef);
                        try {
                            Integer evtsInteger = (Integer)listenerRef.getProperty("wireadmin.events");
                            if (evtsInteger != null) {
                                int events = evtsInteger;
                                if ((nextEvent.getType() & events) == 0) continue;
                                listener.wireAdminEvent(nextEvent);
                                continue;
                            }
                            WireAdminImpl.trace(new Exception("Listener with no WIREADMIN_EVENTS" + listenerRef));
                        }
                        catch (ClassCastException ex) {
                            WireAdminImpl.trace("Listener returned WIREADMIN_EVENTS of wrong type:" + ex);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(WireAdminEvent evt) {
            List list = this.m_eventStack;
            synchronized (list) {
                this.m_eventStack.add(evt);
                this.m_empty = false;
                this.m_eventStack.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            List list = this.m_eventStack;
            synchronized (list) {
                this.m_stop = true;
                this.m_eventStack.notify();
            }
        }
    }
}

