 /*****************************************************************
 ***  Part of the ASAM GDI Specification                        ***
 ***  File        : gdi_data.h                                  ***
 ***  GDI Version : 4.3.2                                       ***
 ***  Date        : February 13, 2009                           ***
 *****************************************************************/
//
//-------------------------- Start of the gdi_data.H file -----------

//-------------------------------------------------------------
// value ranges:    A_UINT8:    number     (0..255)
//                  char:       number     (-128, 127)
//                  A_ASCII:    character  (1..255), 0 is terminating character
//-------------------------------------------------------------

// ASAM data types
//-------------------------------------------------------------


// base types

typedef boolean                         A_BOOLEAN;    // boolean
typedef char                            A_INT8;       // 8 bit integer
typedef octet                           A_UINT8;      // 8 bit unsigned integer
typedef short                           A_INT16;      // 16 bit integer
typedef unsigned short                  A_UINT16;     // 16 bit unsigned integer
typedef long                            A_INT32;      // 32 bit integer
typedef unsigned long                   A_UINT32;     // 32 bit unsigned integer
typedef float                           A_FLOAT32;    // 32 bit float
typedef double                          A_FLOAT64;    // 64 bit float

// BCD number
typedef A_UINT8                         A_BCD;

// Enumeration
// only the values -32768..32767 may be used as enumeration values
typedef A_INT32                         A_ENUM;
//-------------------------------------------------------------


// character types

typedef A_UINT8                         A_ASCII;           // semantically, one char 1..255
                                                           // or the termination character Hex00
typedef A_UINT16                        A_UNICODE_2;       // semantically: one 16 bit character
                                                           // defined in ISO-10646 UCS-2 0x0001-0xFFFF
                                                           // or the termination character Hex0000
typedef A_INT32                         A_UNICODE_4;       // semantically: one 31 bit character defined
                                                           // in ISO-10646 UCS-4  0x00000001 - 0x7FFFFFFF
                                                           // or the termination character Hex0000
typedef A_UINT8                         A_BYTEFIELD_6 [6];
typedef A_BYTEFIELD_6                   A_UTF8;            // UTF8 charccter RFC 2279, encoded in 1 up to 6 Bytes
//-------------------------------------------------------------

// string types

// ASCII string

typedef sequence    <A_ASCII>           A_ASCIISTRING;          // maximum restricted to 4294967295


// UCS-2 string

typedef sequence    <A_UNICODE_2>       A_UNICODE2STRING;       // maximum restricted to 4294967295
                                                                // zero terminated with character Hex0000
// UCS-4 string

typedef sequence    <A_UNICODE_4>       A_UNICODE4STRING;       // maximum restricted to 4294967295
                                                                // zero terminated with character Hex00000000

// RFC 2279 UTF8 field
// number of valid characters is given in actual Length of sequence management structure
typedef sequence    <A_UTF8>            A_UTF8STRING;    
//-------------------------------------------------------------


// character fields

// ASCII field
// number of valid characters is given in actual Length of sequence management structure
typedef A_ASCIISTRING                   A_ASCIIFIELD;

// ISO 10646 UCS-2 field
// number of valid characters is given in actual Length of sequence management structure
typedef A_UNICODE2STRING                A_UNICODE2FIELD;

// ISO 10646 UCS-4 field
// number of valid characters is given in actual Length of sequence management structure
typedef A_UNICODE4STRING                A_UNICODE4FIELD;

// RFC 2279 UTF8 field
// number of valid characters is given in actual Length of sequence management structure
typedef A_UTF8STRING                    A_UTF8FIELD;
//-------------------------------------------------------------


// predefined ASCII_STRINGs and FIELDs
typedef A_ASCII                         A_ASCIISTRING_2    [3];
typedef A_ASCII                         A_ASCIISTRING_32   [33];
typedef A_ASCII                         A_ASCIISTRING_64   [65];
typedef A_ASCII                         A_ASCIISTRING_128  [129];
typedef A_ASCII                         A_ASCIISTRING_255  [256];
typedef A_ASCII                         A_ASCIISTRING_1024 [1025];
typedef A_ASCII                         A_ASCIISTRING_2048 [2049];
typedef A_ASCII                         A_ASCIISTRING_5100 [5101];


typedef struct A_ASCIIFIELD_2
   {
    A_UINT32        IsLength;
    A_ASCII         szData [2];
   } A_ASCIIFIELD_2;

typedef struct A_ASCIIFIELD_32
   {
    A_UINT32        IsLength;
    A_ASCII         szData [32];
   } A_ASCIIFIELD_32;

typedef struct A_ASCIIFIELD_64
   {
    A_UINT32        IsLength;
    A_ASCII         szData [64];
   } A_ASCIIFIELD_64;

typedef struct A_ASCIIFIELD_128
   {
    A_UINT32        IsLength;
    A_ASCII         szData [128];
   } A_ASCIIFIELD_128;

typedef struct A_ASCIIFIELD_255
   {
    A_UINT32        IsLength;
    A_ASCII         szData [255];
   } A_ASCIIFIELD_255;

typedef struct A_ASCIIFIELD_1024
   {
    A_UINT32        IsLength;
    A_ASCII         szData [1024];
   } A_ASCIIFIELD_1024;

typedef struct A_ASCIIFIELD_2048
   {
    A_UINT32        IsLength;
    A_ASCII         szData [2048];
   } A_ASCIIFIELD_2048;
   

//-------------------------------------------------------------



// structures describing numeric values

// 64 bit integer
typedef struct A_INT64
{
    A_INT32         n32High;
    A_UINT32        un32Low;
} A_INT64;

// 64 bit unsigned integer
typedef struct A_UINT64
{
    A_UINT32        un32High;
    A_UINT32        un32Low;
} A_UINT64;

// complex value (real and imaginary part are float values)
typedef struct A_COMPLEX32
{
    A_FLOAT32       fReal;
    A_FLOAT32       fImaginary;
} A_COMPLEX32;


// complex value (real and imaginary part are double values)
typedef struct A_COMPLEX64
{
    A_FLOAT64       dReal;
    A_FLOAT64       dImaginary;
} A_COMPLEX64;
//-------------------------------------------------------------


// bit and byte fields

typedef sequence    <A_UINT8, 256>      BYTEARRAY_256;

// bit field
typedef struct A_BITFIELD
{
    A_INT16         n16NumberOfBits;                  // number of valid bits in bitfield
                                                      // [1 .. 2048]
    BYTEARRAY_256   aun8Field;                        // array of bytes,
                                                      // length of un8Field is calculated as
                                                      // (un32NumberOfBits + 7)/8
                                                      // value range for number of bytes: [1 ..256]
} A_BITFIELD;

// byte field
// number of bytes in byte field is given in lLength of sequence
typedef sequence    <A_UINT8>           A_BYTEFIELD;  //maximum restricted to 4294967295
//-------------------------------------------------------------


// IP-address (IPv4)
typedef struct A_IP4
{
    A_UINT8         un8Octet1;
    A_UINT8         un8Octet2;
    A_UINT8         un8Octet3;
    A_UINT8         un8Octet4;
} A_IP4;


// IP-address (IPv6)
typedef struct A_IP6
{
    A_UINT16        un16Value1;
    A_UINT16        un16Value2;
    A_UINT16        un16Value3;
    A_UINT16        un16Value4;
    A_UINT16        un16Value5;
    A_UINT16        un16Value6;
    A_UINT16        un16Value7;
    A_UINT16        un16Value8;
}A_IP6;

//-------------------------------------------------------------


// data types for time instants


typedef struct A_TIME_STRUCT
{
    A_INT16         n16Year;                          // year
    A_INT8          n8Month;                          // month
    A_INT8          n8DayOfMonth;                     // day of month
    A_INT8          n8Hour;                           // hour
    A_INT8          n8Minute;                         // minute
    A_INT8          n8Second;                         // second
    A_INT16         n16MilliSecond;                   // millisecond
    A_INT16         n16MicroSecond;                   // microsecond
    A_INT16         n16NanoSecond;                    // nanosecond
    A_INT32         n32TimeZoneDiff;                  // difference between UTC and local time in seconds
} A_TIME_STRUCT;


// description of day within a year (year, month, day of month)

typedef struct A_Day_YMD
{
    A_INT16         n16Year;                          // year
    A_INT8          n8Month;                          // month
    A_INT8          n8DayOfMonth;                     // day of month
}A_Day_YMD;


// description of day within a year (year, week, day of week)

typedef struct A_Day_YWD
{
    A_INT16         n16Year;                          // year
    A_INT8          n8Week;                           // week
    A_INT8          n8DayOfWeek;                      // day of week
}A_Day_YWD;


// description of day within a year (year, day of year)

typedef struct A_Day_YD
{
    A_INT16         n16Year;                          // year
    A_INT16         n16DayOfYear;                     // day of year
}A_Day_YD;


//-------------------------------------------------------------


// Definition of used types inside URL adress


// Host access type is switch type of union
typedef enum HOST_ACCESS_TYPE
{
    SERVER_IP4,
    SERVER_IP6,
    SERVER_DOMAIN
} HOST_ACCESS_TYPE;


// structure describing host access using IPv4 address
typedef struct HOST_IP4
{
    A_ASCIISTRING_255                   szUser;
    A_ASCIISTRING_255                   szPwd;
    A_IP4                               Address;
    A_UINT16                            unPort;
} HOST_IP4;

// structure describing host access using IPv6 address
typedef struct HOST_IP6
{
    A_ASCIISTRING_255                   szUser;
    A_ASCIISTRING_255                   szPwd;
    A_IP6                               Address;
    A_UINT16                            unPort;
} HOST_IP6;

// domain name (consists of up to 20 sub-domain names, each up to 255 characters long)
typedef A_ASCIISTRING_5100                A_DOMAIN_NAME;

// structure describing host access using domain name

typedef struct HOST_DOMAIN
{
    A_ASCIISTRING_255                   szUser;
    A_ASCIISTRING_255                   szPwd;
    A_DOMAIN_NAME                       szDomain;
    A_UINT16                            unPort;
} HOST_DOMAIN;

// union describing host access

typedef union HOST_ACCESS switch (HOST_ACCESS_TYPE)
{
    case SERVER_IP4 :   HOST_IP4        hostIP4;
    case SERVER_IP6 :   HOST_IP6        hostIP6;
    default         :   HOST_DOMAIN     hostDomain;
} HOST_ACCESS;

// URL address

typedef struct A_URL
{
    A_ASCIISTRING_255                   AccessScheme;
    HOST_ACCESS_TYPE                  HostAccessType;
    HOST_ACCESS                         HostAccess;
    A_ASCIISTRING                       szPath;
} A_URL;

//-------------------------------------------------------------
// defintion of country and language

typedef A_ASCIISTRING_2                 A_COUNTRY;
typedef A_ASCIISTRING_2                 A_LANGUAGE;
//---------------------------- End of the gdi_data.H file -----------
