/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.launcher;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.net.URLStreamHandlerFactory;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.equinox.launcher.JNIBridge;

public class Main {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected URL installLocation = null;
    protected URL configurationLocation = null;
    protected String parentConfigurationLocation = null;
    protected String framework = "org.eclipse.osgi";
    protected String devClassPath = null;
    private Properties devClassPathProps = null;
    protected boolean inDevelopmentMode = false;
    protected String os = null;
    protected String ws = null;
    protected String arch = null;
    private String library = null;
    private String exitData = null;
    private String vm = null;
    private String[] vmargs = null;
    private String[] commands = null;
    String[] extensionPaths = null;
    JNIBridge bridge = null;
    private boolean showSplash = false;
    private String splashLocation = null;
    private String endSplash = null;
    private boolean initialize = false;
    protected boolean splashDown = false;
    private final Thread splashHandler = new SplashHandler();
    public static final String SPLASH_HANDLE = "org.eclipse.equinox.launcher.splash.handle";
    public static final String SPLASH_LOCATION = "org.eclipse.equinox.launcher.splash.location";
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String VM = "-vm";
    private static final String VMARGS = "-vmargs";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String CONFIGURATION = "-configuration";
    private static final String NOSPLASH = "-nosplash";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String EXITDATA = "-exitdata";
    private static final String NAME = "-name";
    private static final String LAUNCHER = "-launcher";
    private static final String LIBRARY = "--launcher.library";
    private static final String APPEND_VMARGS = "--launcher.appendVmargs";
    private static final String OVERRIDE_VMARGS = "--launcher.overrideVmargs";
    private static final String NL = "-nl";
    private static final String ENDSPLASH = "-endsplash";
    private static final String SPLASH_IMAGE = "splash.bmp";
    private static final String CLEAN = "-clean";
    private static final String NOEXIT = "-noExit";
    private static final String OS = "-os";
    private static final String WS = "-ws";
    private static final String ARCH = "-arch";
    private static final String STARTUP = "-startup";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String ECLIPSE_PROPERTIES = "eclipse.properties";
    private static final String FILE_SCHEME = "file:";
    protected static final String REFERENCE_SCHEME = "reference:";
    protected static final String JAR_SCHEME = "jar:";
    private static final String CONFIG_DIR = "configuration/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_USER_DIR = "user.dir";
    private static final String PROP_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    private static final String PROP_CONFIG_AREA_DEFAULT = "osgi.configuration.area.default";
    private static final String PROP_BASE_CONFIG_AREA = "osgi.baseConfiguration.area";
    private static final String PROP_SHARED_CONFIG_AREA = "osgi.sharedConfiguration.area";
    private static final String PROP_CONFIG_CASCADED = "osgi.configuration.cascaded";
    protected static final String PROP_FRAMEWORK = "osgi.framework";
    private static final String PROP_SPLASHPATH = "osgi.splashPath";
    private static final String PROP_SPLASHLOCATION = "osgi.splashLocation";
    private static final String PROP_CLASSPATH = "osgi.frameworkClassPath";
    private static final String PROP_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_FRAMEWORK_SYSPATH = "osgi.syspath";
    private static final String PROP_FRAMEWORK_SHAPE = "osgi.framework.shape";
    private static final String PROP_LOGFILE = "osgi.logfile";
    private static final String PROP_REQUIRED_JAVA_VERSION = "osgi.requiredJavaVersion";
    private static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    private static final String PROP_FRAMEWORK_PARENT_CLASSLOADER = "osgi.frameworkParentClassloader";
    private static final String PROP_NL = "osgi.nl";
    static final String PROP_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_DEBUG = "osgi.debug";
    private static final String PROP_OS = "osgi.os";
    private static final String PROP_WS = "osgi.ws";
    private static final String PROP_ARCH = "osgi.arch";
    private static final String PROP_EXITCODE = "eclipse.exitcode";
    private static final String PROP_EXITDATA = "eclipse.exitdata";
    private static final String PROP_LAUNCHER = "eclipse.launcher";
    private static final String PROP_LAUNCHER_NAME = "eclipse.launcher.name";
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_ECLIPSESECURITY = "eclipse.security";
    private static final String READ_ONLY_AREA_SUFFIX = ".readOnly";
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    private static final String PARENT_CLASSLOADER_APP = "app";
    private static final String PARENT_CLASSLOADER_EXT = "ext";
    private static final String PARENT_CLASSLOADER_BOOT = "boot";
    private static final String PARENT_CLASSLOADER_CURRENT = "current";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.equinox.launcher";
    protected File logFile = null;
    protected BufferedWriter log = null;
    protected boolean newSession = true;

    private String getWS() {
        if (this.ws != null) {
            return this.ws;
        }
        String string = System.getProperty(PROP_WS);
        if (string != null) {
            this.ws = string;
            return this.ws;
        }
        String string2 = this.getOS();
        if (string2.equals("win32")) {
            return "win32";
        }
        if (string2.equals("linux")) {
            return "gtk";
        }
        if (string2.equals("macosx")) {
            return "cocoa";
        }
        if (string2.equals("hpux")) {
            return "motif";
        }
        if (string2.equals("aix")) {
            return "motif";
        }
        if (string2.equals("solaris")) {
            return "gtk";
        }
        if (string2.equals("qnx")) {
            return "photon";
        }
        return "unknown";
    }

    private String getAlternateWS(String string) {
        if ("cocoa".equals(string)) {
            return "carbon";
        }
        if ("gtk".equals(string)) {
            return "motif";
        }
        if ("win32".equals(string)) {
            return "wpf";
        }
        return "unknown";
    }

    private String getOS() {
        if (this.os != null) {
            return this.os;
        }
        String string = System.getProperty(PROP_OS);
        if (string != null) {
            this.os = string;
            return this.os;
        }
        String string2 = System.getProperties().getProperty("os.name");
        if (string2.regionMatches(true, 0, "win32", 0, 3)) {
            return "win32";
        }
        if (string2.equalsIgnoreCase("SunOS")) {
            return "solaris";
        }
        if (string2.equalsIgnoreCase("Linux")) {
            return "linux";
        }
        if (string2.equalsIgnoreCase("QNX")) {
            return "qnx";
        }
        if (string2.equalsIgnoreCase("AIX")) {
            return "aix";
        }
        if (string2.equalsIgnoreCase("HP-UX")) {
            return "hpux";
        }
        if (string2.equalsIgnoreCase("OS/400")) {
            return "os/400";
        }
        if (string2.equalsIgnoreCase("OS/390")) {
            return "os/390";
        }
        if (string2.equalsIgnoreCase("z/OS")) {
            return "z/os";
        }
        if (string2.regionMatches(true, 0, "Mac OS", 0, "Mac OS".length())) {
            return "macosx";
        }
        return "unknown";
    }

    private String getArch() {
        if (this.arch != null) {
            return this.arch;
        }
        String string = System.getProperty(PROP_ARCH);
        if (string != null) {
            this.arch = string;
            return this.arch;
        }
        String string2 = System.getProperties().getProperty("os.arch");
        if (string2.equalsIgnoreCase("i386")) {
            return "x86";
        }
        if (string2.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        return string2;
    }

    private String getFragmentString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(PLUGIN_ID);
        stringBuffer.append('.');
        stringBuffer.append(string2);
        stringBuffer.append('.');
        stringBuffer.append(string);
        if (!string.equals("macosx") || "x86_64".equals(string3)) {
            stringBuffer.append('.');
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private void setupJNI(URL[] uRLArray) {
        this.bridge = new JNIBridge(null);
    }

    private String getLibraryPath(String string, URL[] uRLArray) {
        String string2;
        File file;
        Object object;
        Object object2;
        String string3 = null;
        String string4 = null;
        if (this.inDevelopmentMode && this.devClassPathProps != null && ((String[])(object2 = this.getArrayFromList((String)(object = this.devClassPathProps.getProperty(PLUGIN_ID))))).length > 0 && (file = new File(object2[0])).isAbsolute() && (string4 = this.searchFor(string, string2 = file.getParent())) != null) {
            string3 = this.getLibraryFromFragment(string4);
        }
        if (string3 == null && this.bootLocation != null && (object = uRLArray) != null && ((Object)object).length > 0) {
            for (int i = ((Object)object).length - 1; i >= 0 && string3 == null; --i) {
                file = new File(((URL)object[i]).getFile());
                string2 = file.getParent();
                if (this.inDevelopmentMode) {
                    String string5 = string2 + "/" + PLUGIN_ID + "/fragments";
                    string4 = this.searchFor(string, string5);
                }
                if (string4 == null) {
                    string4 = this.searchFor(string, string2);
                }
                if (string4 == null) continue;
                string3 = this.getLibraryFromFragment(string4);
            }
        }
        if (string3 == null) {
            object = this.getInstallLocation();
            object2 = ((URL)object).getFile();
            string4 = this.searchFor(string, (String)(object2 = (String)object2 + "/plugins/"));
            if (string4 != null) {
                string3 = this.getLibraryFromFragment(string4);
            }
        }
        return string3;
    }

    private String getLibraryFromFragment(String string) {
        Object object;
        File file;
        if (string.startsWith(FILE_SCHEME)) {
            string = string.substring(5);
        }
        if (!(file = new File(string)).exists()) {
            return null;
        }
        if (file.isDirectory()) {
            return this.searchFor(ECLIPSE, string);
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            this.log("Exception opening JAR file: " + string);
            this.log(iOException);
            return null;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String string2 = null;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!((ZipEntry)object).getName().startsWith("eclipse_")) continue;
            string2 = ((ZipEntry)object).getName();
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
            break;
        }
        if (string2 != null) {
            object = this.extractFromJAR(string, string2);
            if (!this.getOS().equals("win32")) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "755", object}).waitFor();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return object;
        }
        return null;
    }

    protected void basicRun(String[] stringArray) throws Exception {
        System.getProperties().put("eclipse.startTime", Long.toString(System.currentTimeMillis()));
        this.commands = stringArray;
        String[] stringArray2 = this.processCommandLine(stringArray);
        if (!this.debug) {
            this.debug = System.getProperty(PROP_DEBUG) != null;
        }
        this.setupVMProperties();
        this.processConfiguration();
        this.getInstallLocation();
        URL[] uRLArray = this.getBootPath(this.bootLocation);
        this.setupJNI(uRLArray);
        if (!this.checkVersion(System.getProperty("java.version"), System.getProperty(PROP_REQUIRED_JAVA_VERSION))) {
            return;
        }
        if (!this.checkConfigurationLocation(this.configurationLocation)) {
            return;
        }
        this.setSecurityPolicy(uRLArray);
        this.handleSplash(uRLArray);
        this.beforeFwkInvocation();
        this.invokeFramework(stringArray2, uRLArray);
    }

    protected void beforeFwkInvocation() {
    }

    protected void setSecurityPolicy(URL[] uRLArray) {
        String string = System.getProperty(PROP_ECLIPSESECURITY);
        if (string != null) {
            ProtectionDomain protectionDomain = Main.class.getProtectionDomain();
            CodeSource codeSource = null;
            if (protectionDomain != null) {
                codeSource = Main.class.getProtectionDomain().getCodeSource();
            }
            if (protectionDomain == null || codeSource == null) {
                this.log("Can not automatically set the security manager. Please use a policy file.");
                return;
            }
            URL[] uRLArray2 = new URL[uRLArray.length + 1];
            uRLArray2[0] = codeSource.getLocation();
            System.arraycopy(uRLArray, 0, uRLArray2, 1, uRLArray.length);
            EclipsePolicy eclipsePolicy = new EclipsePolicy(Policy.getPolicy(), uRLArray2);
            Policy.setPolicy(eclipsePolicy);
        }
    }

    private void invokeFramework(String[] stringArray, URL[] uRLArray) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, Error, Exception, InvocationTargetException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Class<?> clazz = classLoader.loadClass(STARTER);
        Method method = clazz.getDeclaredMethod("run", String[].class, Runnable.class);
        try {
            method.invoke(clazz, stringArray, this.splashHandler);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof Error) {
                throw (Error)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof Exception) {
                throw (Exception)invocationTargetException.getTargetException();
            }
            throw invocationTargetException;
        }
    }

    private boolean checkVersion(String string, String string2) {
        if (string2 == null || string == null) {
            return true;
        }
        try {
            Identifier identifier = new Identifier(string2);
            Identifier identifier2 = new Identifier(string);
            boolean bl = identifier2.isGreaterEqualTo(identifier);
            if (!bl) {
                System.getProperties().put(PROP_EXITCODE, "14");
                System.getProperties().put(PROP_EXITDATA, "<title>Incompatible JVM</title>Version " + string + " of the JVM is not suitable for this product. Version: " + string2 + " or greater is required.");
            }
            return bl;
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    private boolean checkConfigurationLocation(URL uRL) {
        if (uRL == null || !"file".equals(uRL.getProtocol())) {
            return true;
        }
        if (Boolean.valueOf(System.getProperty("osgi.configuration.area.readOnly")).booleanValue()) {
            return true;
        }
        File file = new File(uRL.getFile()).getAbsoluteFile();
        if (!file.exists()) {
            file.mkdirs();
            if (!file.exists()) {
                System.getProperties().put(PROP_EXITCODE, "15");
                System.getProperties().put(PROP_EXITDATA, "<title>Invalid Configuration Location</title>The configuration area at '" + file + "' could not be created.  Please choose a writable location using the '-configuration' command line option.");
                return false;
            }
        }
        if (!Main.canWrite(file)) {
            System.getProperties().put(PROP_EXITCODE, "15");
            System.getProperties().put(PROP_EXITDATA, "<title>Invalid Configuration Location</title>The configuration area at '" + file + "' is not writable.  Please choose a writable location using the '-configuration' command line option.");
            return false;
        }
        return true;
    }

    protected String decode(String string) {
        int n;
        int n2;
        Object object;
        Object object2;
        try {
            Object object3;
            Class<URLDecoder> clazz = URLDecoder.class;
            object2 = clazz.getDeclaredMethod("decode", String.class, String.class);
            if (string.indexOf(43) >= 0) {
                int n3 = string.length();
                object = new StringBuffer(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    n = string.charAt(n2);
                    if (n == 43) {
                        ((StringBuffer)object).append("%2B");
                        continue;
                    }
                    ((StringBuffer)object).append((char)n);
                }
                string = ((StringBuffer)object).toString();
            }
            if ((object3 = ((Method)object2).invoke(null, string, "UTF-8")) != null) {
                return (String)object3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        object2 = string.getBytes();
        int n4 = ((byte[])object2).length;
        object = new byte[n4];
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            byte by = object2[n];
            if (by == 37) {
                if (n + 2 >= n4) {
                    throw new IllegalArgumentException("Malformed URL (\"" + string + "\"): % must be followed by 2 digits.");
                }
                Object object4 = object2[++n];
                Object object5 = object2[++n];
                by = (byte)((this.hexToByte((byte)object4) << 4) + this.hexToByte((byte)object5));
                bl = true;
            }
            object[n2++] = by;
        }
        if (!bl) {
            return string;
        }
        try {
            return new String((byte[])object, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String((byte[])object, 0, n2);
        }
    }

    protected String[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new String[]{} : vector.toArray(new String[vector.size()]);
    }

    private URL[] getDevPath(URL uRL) throws IOException {
        ArrayList arrayList = new ArrayList(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(uRL, arrayList, OSGI);
        }
        this.addBaseJars(uRL, arrayList);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    URL constructURL(URL uRL, String string) {
        String string2 = uRL.toExternalForm();
        if (string2.endsWith(".jar")) {
            try {
                return new URL(JAR_SCHEME + uRL + "!/" + string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void readFrameworkExtensions(URL uRL, ArrayList arrayList) throws IOException {
        String[] stringArray = this.getArrayFromList(System.getProperties().getProperty(PROP_EXTENSIONS));
        String string = new File(uRL.getFile()).getParent().toString();
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            Properties properties;
            URL uRL2;
            String string2;
            block13: {
                string2 = this.searchForBundle(stringArray[i], string);
                if (string2 == null) {
                    this.log("Could not find extension: " + stringArray[i]);
                    continue;
                }
                if (this.debug) {
                    System.out.println("Loading extension: " + stringArray[i]);
                }
                uRL2 = null;
                if (this.installLocation.getProtocol().equals("file")) {
                    arrayList2.add(string2);
                    uRL2 = new File(string2).toURL();
                } else {
                    uRL2 = new URL(this.installLocation.getProtocol(), this.installLocation.getHost(), this.installLocation.getPort(), string2);
                }
                properties = null;
                try {
                    properties = this.loadProperties(this.constructURL(uRL2, ECLIPSE_PROPERTIES));
                }
                catch (IOException iOException) {
                    if (!this.debug) break block13;
                    System.out.println("\teclipse.properties not found");
                }
            }
            String string3 = null;
            if (properties != null) {
                string3 = properties.getProperty(PROP_CLASSPATH);
            } else {
                properties = new Properties();
            }
            if (string3 == null || string3.length() == 0) {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = "";
            } else {
                stringArray2 = this.getArrayFromList(string3);
            }
            String[] stringArray4 = stringArray2;
            String string4 = System.getProperty(PROP_CLASSPATH) == null ? "." : "";
            for (int j = 0; j < stringArray4.length; ++j) {
                string4 = string4 + ", file:" + string2 + stringArray4[j];
            }
            properties.put(PROP_CLASSPATH, string4);
            this.mergeProperties(System.getProperties(), properties, null);
            if (!this.inDevelopmentMode) continue;
            String string5 = stringArray[i];
            if (string5.startsWith(REFERENCE_SCHEME)) {
                string5 = new File(string2).getName();
            }
            this.addDevEntries(uRL2, arrayList, string5);
        }
        this.extensionPaths = arrayList2.toArray(new String[arrayList2.size()]);
    }

    private void addBaseJars(URL uRL, ArrayList arrayList) throws IOException {
        Object[] objectArray;
        File file;
        boolean bl;
        String string = System.getProperty(PROP_CLASSPATH);
        if (string == null) {
            this.readFrameworkExtensions(uRL, arrayList);
            string = System.getProperties().getProperty(PROP_CLASSPATH);
        }
        if (bl = (file = new File(uRL.getFile())).isDirectory()) {
            System.getProperties().put(PROP_FRAMEWORK_SHAPE, "folder");
        } else {
            System.getProperties().put(PROP_FRAMEWORK_SHAPE, "jar");
        }
        String string2 = new File(new File(uRL.getFile()).getParent()).getAbsolutePath();
        if (Character.isUpperCase(string2.charAt(0))) {
            objectArray = string2.toCharArray();
            objectArray[0] = Character.toLowerCase(objectArray[0]);
            string2 = new String((char[])objectArray);
        }
        System.getProperties().put(PROP_FRAMEWORK_SYSPATH, string2);
        objectArray = this.getArrayFromList(string);
        if (objectArray.length == 0) {
            if (!this.inDevelopmentMode && new File(uRL.getFile()).isDirectory()) {
                throw new IOException("Unable to initialize osgi.frameworkClassPath");
            }
            this.addEntry(uRL, arrayList);
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            char c = objectArray[i];
            try {
                if (c.equals(".")) {
                    this.addEntry(uRL, arrayList);
                }
                URL uRL2 = null;
                uRL2 = c.startsWith(FILE_SCHEME) ? new File(c.substring(5)).toURL() : new URL((String)c);
                this.addEntry(uRL2, arrayList);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                this.addEntry(new URL(uRL, (String)c), arrayList);
            }
        }
    }

    protected void addEntry(URL uRL, List list) {
        if (new File(uRL.getFile()).exists()) {
            list.add(uRL);
        }
    }

    private void addDevEntries(URL uRL, List list, String string) throws MalformedURLException {
        if (this.devClassPathProps == null) {
            return;
        }
        String string2 = this.devClassPathProps.getProperty(string);
        if (string2 == null) {
            string2 = this.devClassPathProps.getProperty("*");
        }
        String[] stringArray = this.getArrayFromList(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            URL uRL2;
            String string3 = stringArray[i];
            File file = new File(string3);
            if (file.isAbsolute()) {
                uRL2 = file.toURL();
            } else {
                char c = string3.charAt(string3.length() - 1);
                uRL2 = string3.endsWith(".jar") || c == '/' || c == '\\' ? new URL(uRL, string3) : new URL(uRL, string3 + "/");
            }
            this.addEntry(uRL2, list);
        }
    }

    protected URL[] getBootPath(String string) throws IOException {
        URL[] uRLArray;
        URL uRL = null;
        if (string != null) {
            uRL = Main.buildURL(string, true);
        } else {
            uRL = this.getInstallLocation();
            uRLArray = new File(uRL.getFile(), "plugins").toString();
            if ((uRLArray = this.searchFor(this.framework, (String)uRLArray)) == null) {
                throw new RuntimeException("Could not find framework");
            }
            uRL = uRL.getProtocol().equals("file") ? new File((String)uRLArray).toURL() : new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)uRLArray);
        }
        if (System.getProperty(PROP_FRAMEWORK) == null) {
            System.getProperties().put(PROP_FRAMEWORK, uRL.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Framework located:\n    " + uRL.toExternalForm());
        }
        uRLArray = this.getDevPath(uRL);
        if (this.debug) {
            System.out.println("Framework classpath:");
            for (int i = 0; i < uRLArray.length; ++i) {
                System.out.println("    " + uRLArray[i].toExternalForm());
            }
        }
        return uRLArray;
    }

    protected String searchFor(String string, String string2) {
        return this.searchFor(string, null, string2);
    }

    protected String searchFor(String string, String string2, String string3) {
        File file = Main.resolveFile(new File(string3));
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isMatchingCandidate(string, stringArray[i], file)) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        int n = this.findMax(string, stringArray2);
        if (n == -1) {
            return null;
        }
        File file2 = new File(string3, stringArray2[n]);
        return file2.getAbsolutePath().replace(File.separatorChar, '/') + (file2.isDirectory() ? "/" : "");
    }

    private boolean isMatchingCandidate(String string, String string2, File file) {
        int n;
        if (string2.equals(string)) {
            return true;
        }
        if (!string2.startsWith(string + "_")) {
            return false;
        }
        int n2 = string.length();
        int n3 = string2.lastIndexOf(95);
        File file2 = new File(file, string2);
        if (file2.isFile() && (string2.endsWith(".jar") || string2.endsWith(".zip"))) {
            n = string2.lastIndexOf(46);
            string2 = string2.substring(0, n);
        }
        if ((n = string2.lastIndexOf(46)) < n2) {
            return false;
        }
        while (n3 > n) {
            n3 = string2.lastIndexOf(95, n3 - 1);
        }
        return n3 == n2;
    }

    private String searchForBundle(String string, String string2) {
        if (string.startsWith(REFERENCE_SCHEME)) {
            File file;
            if (!(string = string.substring(REFERENCE_SCHEME.length())).startsWith(FILE_SCHEME)) {
                throw new IllegalArgumentException("Bundle URL is invalid: " + string);
            }
            string = string.substring(FILE_SCHEME.length());
            File file2 = file = new File(string);
            if (!file.isAbsolute()) {
                File file3 = Main.resolveFile(new File(string2));
                file2 = new File(file3, file.getPath());
            }
            return this.searchFor(file2.getName(), file2.getParentFile().getAbsolutePath());
        }
        return this.searchFor(string, string2);
    }

    protected int findMax(String string, String[] stringArray) {
        int n = -1;
        Object[] objectArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i] != null ? stringArray[i] : "";
            String string3 = "";
            if (string == null) {
                string3 = string2;
            } else if (string2.startsWith(string + "_")) {
                string3 = string2.substring(string.length() + 1);
            }
            Object[] objectArray2 = this.getVersionElements(string3);
            if (objectArray == null) {
                n = i;
                objectArray = objectArray2;
                continue;
            }
            if (this.compareVersion(objectArray, objectArray2) >= 0) continue;
            n = i;
            objectArray = objectArray2;
        }
        return n;
    }

    private int compareVersion(Object[] objectArray, Object[] objectArray2) {
        int n = ((Integer)objectArray[0]).compareTo((Integer)objectArray2[0]);
        if (n != 0) {
            return n;
        }
        n = ((Integer)objectArray[1]).compareTo((Integer)objectArray2[1]);
        if (n != 0) {
            return n;
        }
        n = ((Integer)objectArray[2]).compareTo((Integer)objectArray2[2]);
        if (n != 0) {
            return n;
        }
        return ((String)objectArray[3]).compareTo((String)objectArray2[3]);
    }

    private Object[] getVersionElements(String string) {
        if (string.endsWith(".jar")) {
            string = string.substring(0, string.length() - 4);
        }
        Object[] objectArray = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens() && n < 4) {
            String string2 = stringTokenizer.nextToken();
            if (n < 3) {
                try {
                    objectArray[n++] = new Integer(string2);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            objectArray[n++] = string2;
        }
        return objectArray;
    }

    private static URL buildURL(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        boolean bl2 = string.startsWith(FILE_SCHEME);
        try {
            if (bl2) {
                File file = new File(string.substring(5));
                if ((file = Main.resolveFile(file)).isDirectory()) {
                    return Main.adjustTrailingSlash(file.toURL(), bl);
                }
                return file.toURL();
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            if (bl2) {
                return null;
            }
            try {
                File file = new File(string);
                if (file.isDirectory()) {
                    return Main.adjustTrailingSlash(file.toURL(), bl);
                }
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static File resolveFile(File file) {
        String string;
        if (!file.isAbsolute() && (string = System.getProperties().getProperty(PROP_INSTALL_AREA)) != null) {
            if (string.startsWith(FILE_SCHEME)) {
                file = new File(string.substring(5), file.getPath());
            } else if (new File(string).exists()) {
                file = new File(string, file.getPath());
            }
        }
        return file;
    }

    private static URL adjustTrailingSlash(URL uRL, boolean bl) throws MalformedURLException {
        String string = uRL.getFile();
        if (bl == string.endsWith("/")) {
            return uRL;
        }
        string = bl ? string + "/" : string.substring(0, string.length() - 1);
        return new URL(uRL.getProtocol(), uRL.getHost(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL buildLocation(String string, URL uRL, String string2) {
        URL uRL2 = null;
        String string3 = System.getProperty(string);
        System.getProperties().remove(string);
        try {
            if (string3 == null) {
                uRL2 = uRL;
            } else {
                if (string3.equalsIgnoreCase(NONE)) {
                    URL uRL3 = null;
                    return uRL3;
                }
                if (string3.equalsIgnoreCase(NO_DEFAULT)) {
                    uRL2 = Main.buildURL(string3, true);
                } else {
                    if (string3.startsWith(USER_HOME)) {
                        String string4 = this.substituteVar(string3, USER_HOME, PROP_USER_HOME);
                        string3 = new File(string4, string2).getAbsolutePath();
                    } else if (string3.startsWith(USER_DIR)) {
                        String string5 = this.substituteVar(string3, USER_DIR, PROP_USER_DIR);
                        string3 = new File(string5, string2).getAbsolutePath();
                    }
                    uRL2 = Main.buildURL(string3, true);
                }
            }
        }
        finally {
            if (uRL2 != null) {
                System.getProperties().put(string, uRL2.toExternalForm());
            }
        }
        return uRL2;
    }

    private String substituteVar(String string, String string2, String string3) {
        String string4 = System.getProperty(string3, "");
        return string4 + string.substring(string2.length());
    }

    private String computeDefaultConfigurationLocation() {
        File file;
        URL uRL = this.getInstallLocation();
        if (uRL.getProtocol().equals("file") && Main.canWrite(file = new File(uRL.getFile()))) {
            return file.getAbsolutePath() + File.separator + CONFIG_DIR;
        }
        return this.computeDefaultUserAreaLocation(CONFIG_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File file) {
        if (!file.canWrite()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File file2 = null;
        try {
            file2 = File.createTempFile("writtableArea", ".dll", file);
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (file2 != null) {
                file2.delete();
            }
        }
        return true;
    }

    private String computeDefaultUserAreaLocation(String string) {
        Object object;
        int n;
        URL uRL = this.getInstallLocation();
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getFile());
        try {
            n = file.getCanonicalPath().hashCode();
        }
        catch (IOException iOException) {
            n = file.getAbsolutePath().hashCode();
        }
        if (n < 0) {
            n = -n;
        }
        String string2 = String.valueOf(n);
        String string3 = ".eclipse";
        File file2 = new File(file, PRODUCT_SITE_MARKER);
        if (file2.exists()) {
            object = new Properties();
            try {
                String string4;
                ((Properties)object).load(new FileInputStream(file2));
                String string5 = ((Properties)object).getProperty(PRODUCT_SITE_ID);
                if (string5 == null || string5.trim().length() == 0) {
                    string5 = ECLIPSE;
                }
                if ((string4 = ((Properties)object).getProperty(PRODUCT_SITE_VERSION)) == null || string4.trim().length() == 0) {
                    string4 = "";
                }
                string3 = string3 + File.separator + string5 + "_" + string4 + "_" + string2;
            }
            catch (IOException iOException) {
                string3 = string3 + File.separator + string2;
            }
        } else {
            string3 = string3 + File.separator + string2;
        }
        object = System.getProperty(PROP_USER_HOME);
        return new File((String)object, string3 + "/" + string).getAbsolutePath();
    }

    public static void main(String string) {
        Vector<Object> vector = new Vector<Object>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            vector.addElement(stringTokenizer.nextElement());
        }
        Main.main(vector.toArray(new String[vector.size()]));
    }

    public static void main(String[] stringArray) {
        int n = 0;
        try {
            n = new Main().run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (!Boolean.getBoolean(PROP_NOSHUTDOWN)) {
                System.exit(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] stringArray) {
        int n = 0;
        try {
            this.basicRun(stringArray);
            String string = System.getProperty(PROP_EXITCODE);
            try {
                n = string == null ? 0 : Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 17;
            }
        }
        catch (Throwable throwable) {
            if (!"13".equals(System.getProperty(PROP_EXITCODE))) {
                this.log("Exception launching the Eclipse Platform:");
                this.log(throwable);
                String string = "An error has occurred";
                string = this.logFile == null ? string + " and could not be logged: \n" + throwable.getMessage() : string + ".  See the log file\n" + this.logFile.getAbsolutePath();
                System.getProperties().put(PROP_EXITDATA, string);
            }
            n = 13;
        }
        finally {
            this.takeDownSplash();
            if (this.bridge != null) {
                this.bridge.uninitialize();
            }
        }
        System.getProperties().put(PROP_EXITCODE, Integer.toString(n));
        this.setExitData();
        return n;
    }

    private void setExitData() {
        String string = System.getProperty(PROP_EXITDATA);
        if (string == null) {
            return;
        }
        if (this.bridge == null || this.bridge.isLibraryLoadedByJava() && this.exitData == null) {
            System.out.println(string);
        } else {
            this.bridge.setExitData(this.exitData, string);
        }
    }

    protected String[] processCommandLine(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length == 0) {
            return stringArray;
        }
        int[] nArray = new int[stringArray.length];
        nArray[0] = -1;
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n2 = 0;
            if (stringArray[i].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(NOSPLASH)) {
                this.splashDown = true;
                n2 = 1;
            }
            if (stringArray[i].equalsIgnoreCase(NOEXIT)) {
                System.getProperties().put(PROP_NOSHUTDOWN, "true");
                n2 = 1;
            }
            if (stringArray[i].equalsIgnoreCase(APPEND_VMARGS) || stringArray[i].equalsIgnoreCase(OVERRIDE_VMARGS)) {
                n2 = 1;
            }
            if (stringArray[i].equalsIgnoreCase(INITIALIZE)) {
                this.initialize = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(DEV) && (i + 1 == stringArray.length || i + 1 < stringArray.length && stringArray[i + 1].startsWith("-"))) {
                this.inDevelopmentMode = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(SHOWSPLASH)) {
                this.showSplash = true;
                n2 = 1;
                if (i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                    nArray[n3++] = i++;
                    this.splashLocation = stringArray[i];
                }
            }
            if (n2 != 0) {
                nArray[n3++] = i;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(VMARGS)) {
                stringArray[i] = null;
                this.vmargs = new String[stringArray.length - ++i];
                n = 0;
                while (i < stringArray.length) {
                    this.vmargs[n++] = stringArray[i];
                    stringArray[i] = null;
                    ++i;
                }
                continue;
            }
            if (i == stringArray.length - 1 || stringArray[i + 1].startsWith("-")) continue;
            String string = stringArray[++i];
            if (stringArray[i - 1].equalsIgnoreCase(DEV)) {
                this.inDevelopmentMode = true;
                this.devClassPathProps = this.processDevArg(string);
                if (this.devClassPathProps == null) continue;
                this.devClassPath = this.devClassPathProps.getProperty(OSGI);
                if (this.devClassPath != null) continue;
                this.devClassPath = this.devClassPathProps.getProperty("*");
                continue;
            }
            if (stringArray[i - 1].equalsIgnoreCase(FRAMEWORK)) {
                this.framework = string;
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(OS)) {
                this.os = string;
                continue;
            }
            if (stringArray[i - 1].equalsIgnoreCase(WS)) {
                this.ws = string;
                continue;
            }
            if (stringArray[i - 1].equalsIgnoreCase(ARCH)) {
                this.arch = string;
                continue;
            }
            if (stringArray[i - 1].equalsIgnoreCase(INSTALL)) {
                System.getProperties().put(PROP_INSTALL_AREA, string);
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                System.getProperties().put(PROP_CONFIG_AREA, string);
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(EXITDATA)) {
                this.exitData = string;
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(NAME)) {
                System.getProperties().put(PROP_LAUNCHER_NAME, string);
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(STARTUP)) {
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(LAUNCHER)) {
                System.getProperties().put(PROP_LAUNCHER, string);
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(LIBRARY)) {
                this.library = string;
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(ENDSPLASH)) {
                this.endSplash = string;
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(VM)) {
                this.vm = string;
                n2 = 1;
            }
            if (stringArray[i - 1].equalsIgnoreCase(NL)) {
                System.getProperties().put(PROP_NL, string);
                n2 = 1;
            }
            if (n2 == 0) continue;
            nArray[n3++] = i - 1;
            nArray[n3++] = i;
        }
        String[] stringArray2 = new String[stringArray.length - n3 - (this.vmargs == null ? 0 : this.vmargs.length + 1)];
        n3 = 0;
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            if (n == nArray[n3]) {
                ++n3;
                continue;
            }
            if (stringArray[n] == null) continue;
            stringArray2[n2++] = stringArray[n];
        }
        return stringArray2;
    }

    private Properties processDevArg(String string) {
        if (string == null) {
            return null;
        }
        try {
            URL uRL = new URL(string);
            return this.load(uRL, null);
        }
        catch (MalformedURLException malformedURLException) {
            Properties properties = new Properties();
            properties.put("*", string);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private URL getConfigurationLocation() {
        if (this.configurationLocation != null) {
            return this.configurationLocation;
        }
        this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA, null, "");
        if (this.configurationLocation == null) {
            this.configurationLocation = this.buildLocation(PROP_CONFIG_AREA_DEFAULT, null, "");
            if (this.configurationLocation == null) {
                this.configurationLocation = Main.buildURL(this.computeDefaultConfigurationLocation(), true);
            }
        }
        if (this.configurationLocation != null) {
            System.getProperties().put(PROP_CONFIG_AREA, this.configurationLocation.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Configuration location:\n    " + this.configurationLocation);
        }
        return this.configurationLocation;
    }

    private void processConfiguration() {
        Object object;
        Object object2;
        Object object3;
        URL uRL = null;
        Object object4 = null;
        if (System.getProperty(PROP_CONFIG_AREA) == null) {
            object3 = System.getProperty(PROP_BASE_CONFIG_AREA);
            if (object3 != null) {
                uRL = Main.buildURL((String)object3, true);
            }
            if (uRL == null) {
                try {
                    uRL = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((object4 = this.loadConfiguration(uRL)) != null) {
                object2 = ((Properties)object4).getProperty(PROP_CONFIG_AREA);
                if (object2 != null) {
                    System.getProperties().put(PROP_CONFIG_AREA, object2);
                }
                if ((object2 = ((Properties)object4).getProperty(PROP_INSTALL_AREA)) != null && System.getProperty(PROP_INSTALL_AREA) == null) {
                    System.getProperties().put(PROP_INSTALL_AREA, object2);
                }
            }
        }
        if ((object3 = object4) == null || !this.getConfigurationLocation().equals(uRL)) {
            object3 = this.loadConfiguration(this.getConfigurationLocation());
        }
        this.mergeProperties(System.getProperties(), (Properties)object3, null);
        if ("false".equalsIgnoreCase(System.getProperty(PROP_CONFIG_CASCADED))) {
            System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
        } else {
            this.ensureAbsolute(PROP_SHARED_CONFIG_AREA);
            object2 = this.buildLocation(PROP_SHARED_CONFIG_AREA, null, "");
            if (object2 == null) {
                try {
                    object2 = new URL(this.getInstallLocation(), CONFIG_DIR);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (object2 != null) {
                if (((URL)object2).equals(this.getConfigurationLocation())) {
                    System.getProperties().remove(PROP_SHARED_CONFIG_AREA);
                } else {
                    object = object4;
                    if (!((URL)object2).equals(uRL)) {
                        object = this.loadConfiguration((URL)object2);
                    }
                    this.mergeProperties(System.getProperties(), (Properties)object, (Properties)object3);
                    System.getProperties().put(PROP_SHARED_CONFIG_AREA, ((URL)object2).toExternalForm());
                    if (this.debug) {
                        System.out.println("Shared configuration location:\n    " + ((URL)object2).toExternalForm());
                    }
                }
            }
        }
        object2 = System.getProperty(PROP_FRAMEWORK, null);
        if (object2 != null) {
            object2 = this.resolve((String)object2);
            this.getInstallLocation();
            object = Main.buildURL((String)object2, true);
            object2 = ((URL)object).toExternalForm();
            System.getProperties().put(PROP_FRAMEWORK, object2);
            this.bootLocation = object2;
        }
    }

    private void ensureAbsolute(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String string3 = uRL.getPath();
        if (string3.startsWith("/")) {
            return;
        }
        URL uRL2 = this.getInstallLocation();
        if (!uRL.getProtocol().equals(uRL2.getProtocol())) {
            return;
        }
        try {
            URL uRL3 = new URL(uRL2, string3);
            System.getProperties().put(string, uRL3.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private URL getInstallLocation() {
        if (this.installLocation != null) {
            return this.installLocation;
        }
        String string = System.getProperty(PROP_INSTALL_AREA);
        if (string != null) {
            this.installLocation = Main.buildURL(string, true);
            if (this.installLocation == null) {
                throw new IllegalStateException("Install location is invalid: " + string);
            }
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
            if (this.debug) {
                System.out.println("Install location:\n    " + this.installLocation);
            }
            return this.installLocation;
        }
        ProtectionDomain protectionDomain = Main.class.getProtectionDomain();
        CodeSource codeSource = null;
        URL uRL = null;
        if (protectionDomain != null) {
            codeSource = protectionDomain.getCodeSource();
        }
        if (codeSource == null || protectionDomain == null) {
            if (this.debug) {
                System.out.println("CodeSource location is null. Defaulting the install location to file:startup.jar");
            }
            try {
                uRL = new URL("file:startup.jar");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        String string2 = this.decode(uRL.getFile());
        File file = new File(string2);
        string2 = file.toString().replace('\\', '/');
        if (File.separatorChar == '\\' && Character.isUpperCase(string2.charAt(0))) {
            char[] cArray = string2.toCharArray();
            cArray[0] = Character.toLowerCase(cArray[0]);
            string2 = new String(cArray);
        }
        if (string2.toLowerCase().endsWith(".jar")) {
            string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
        }
        if (string2.toLowerCase().endsWith("/plugins/")) {
            string2 = string2.substring(0, string2.length() - "/plugins/".length());
        }
        try {
            try {
                string2 = new File(string2).toURL().getFile();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            this.installLocation = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
            System.getProperties().put(PROP_INSTALL_AREA, this.installLocation.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (this.debug) {
            System.out.println("Install location:\n    " + this.installLocation);
        }
        return this.installLocation;
    }

    private Properties loadConfiguration(URL uRL) {
        Properties properties;
        block6: {
            properties = null;
            try {
                uRL = new URL(uRL, CONFIG_FILE);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            try {
                if (this.debug) {
                    System.out.print("Configuration file:\n    " + uRL.toString());
                }
                properties = this.loadProperties(uRL);
                if (this.debug) {
                    System.out.println(" loaded");
                }
            }
            catch (IOException iOException) {
                if (!this.debug) break block6;
                System.out.println(" not found or not read");
            }
        }
        return properties;
    }

    private Properties loadProperties(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        Properties properties = null;
        IOException iOException = null;
        try {
            properties = this.load(uRL, null);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            try {
                properties = this.load(uRL, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException3) {
                try {
                    properties = this.load(uRL, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException4) {
                    throw iOException;
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(URL uRL, String string) throws IOException {
        if (string != null && !string.equals("")) {
            uRL = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + string);
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private void handleSplash(URL[] uRLArray) {
        if (this.initialize || this.splashDown || this.bridge == null) {
            this.showSplash = false;
            this.endSplash = null;
            return;
        }
        if (this.showSplash || this.endSplash != null) {
            try {
                Runtime.getRuntime().addShutdownHook(this.splashHandler);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.endSplash != null) {
            this.showSplash = false;
            return;
        }
        if (!this.showSplash) {
            return;
        }
        this.splashLocation = this.getSplashLocation(uRLArray);
        if (this.debug) {
            System.out.println("Splash location:\n    " + this.splashLocation);
        }
        if (this.splashLocation == null) {
            return;
        }
        this.bridge.setLauncherInfo(System.getProperty(PROP_LAUNCHER), System.getProperty(PROP_LAUNCHER_NAME));
        this.bridge.showSplash(this.splashLocation);
        long l = this.bridge.getSplashHandle();
        if (l != 0L && l != -1L) {
            System.getProperties().put(SPLASH_HANDLE, String.valueOf(l));
            System.getProperties().put(SPLASH_LOCATION, this.splashLocation);
            this.bridge.updateSplash();
        } else {
            this.splashDown = true;
        }
    }

    protected void takeDownSplash() {
        if (this.splashDown || this.bridge == null) {
            return;
        }
        this.splashDown = this.bridge.takeDownSplash();
        System.getProperties().remove(SPLASH_HANDLE);
        try {
            Runtime.getRuntime().removeShutdownHook(this.splashHandler);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getSplashLocation(URL[] uRLArray) {
        if (this.splashLocation != null && !Character.isDigit(this.splashLocation.charAt(0)) && new File(this.splashLocation).exists()) {
            System.getProperties().put(PROP_SPLASHLOCATION, this.splashLocation);
            return this.splashLocation;
        }
        String string = System.getProperty(PROP_SPLASHLOCATION);
        if (string != null) {
            return string;
        }
        String string2 = System.getProperty(PROP_SPLASHPATH);
        if (string2 != null) {
            String[] stringArray = this.getArrayFromList(string2);
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = this.resolve(stringArray[i]);
                if (string3 != null && string3.startsWith(FILE_SCHEME)) {
                    File file = new File(string3.substring(5).replace('/', File.separatorChar));
                    if ((string3 = this.searchFor(file.getName(), file.getParent())) == null) continue;
                    arrayList.add(string3);
                    continue;
                }
                this.log("Invalid splash path entry: " + stringArray[i]);
            }
            string = this.searchForSplash(arrayList.toArray(new String[arrayList.size()]));
            if (string != null) {
                System.getProperties().put(PROP_SPLASHLOCATION, string);
                return string;
            }
        }
        return string;
    }

    private String searchForSplash(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String string = (String)System.getProperties().get(PROP_NL);
        if (string == null) {
            string = Locale.getDefault().toString();
        }
        String[] stringArray2 = Main.buildNLVariants(string);
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                Object object;
                String string2 = stringArray[j];
                if (string2.startsWith(FILE_SCHEME)) {
                    string2 = string2.substring(5);
                }
                if (this.isJAR(string2)) {
                    object = this.extractFromJAR(string2, stringArray2[i]);
                    if (object == null) continue;
                    return object;
                }
                if (!string2.endsWith(File.separator)) {
                    string2 = string2 + File.separator;
                }
                if (!((File)(object = new File(string2 = string2 + stringArray2[i]))).exists()) continue;
                return ((File)object).getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void transferStreams(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[8096];
        while (true) {
            int n;
            try {
                n = -1;
                try {
                    n = inputStream.read(byArray);
                }
                catch (IOException iOException) {
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException2) {
                        return;
                    }
                    finally {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException3) {}
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            {
                if (n == -1) break;
                try {
                    outputStream.write(byArray, 0, n);
                }
                catch (IOException iOException) {
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException4) {
                        return;
                    }
                    finally {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException5) {}
                    }
                }
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String extractFromJAR(String string, String string2) {
        BufferedOutputStream bufferedOutputStream;
        ZipFile zipFile;
        String string3 = System.getProperty(PROP_CONFIG_AREA);
        if (string3 == null) {
            this.log("Configuration area not set yet. Unable to extract " + string2 + " from JAR'd plug-in: " + string);
            return null;
        }
        URL uRL = Main.buildURL(string3, false);
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getPath(), PLUGIN_ID);
        File file2 = new File(string);
        String string4 = file2.getName();
        if (string4.endsWith(".jar")) {
            string4 = string4.substring(0, string4.length() - 4);
        }
        file = new File(file, string4);
        if ((file = new File(file, string2)).exists()) {
            boolean bl = false;
            for (int i = 0; i < this.commands.length; ++i) {
                if (!CLEAN.equalsIgnoreCase(this.commands[i])) continue;
                bl = true;
                file.delete();
                break;
            }
            if (!bl) {
                return file.getAbsolutePath();
            }
        }
        try {
            zipFile = new ZipFile(string);
        }
        catch (IOException iOException) {
            this.log("Exception looking for " + string2 + " in JAR file: " + string);
            this.log(iOException);
            return null;
        }
        ZipEntry zipEntry = zipFile.getEntry(string2.replace(File.separatorChar, '/'));
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            this.log("Exception opening splash: " + zipEntry.getName() + " in JAR file: " + string);
            this.log(iOException);
            return null;
        }
        new File(file.getParent()).mkdirs();
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        Main.transferStreams(inputStream, bufferedOutputStream);
        return file.exists() ? file.getAbsolutePath() : null;
    }

    private boolean isJAR(String string) {
        return new File(string).isFile();
    }

    private static String[] buildNLVariants(String string) {
        String string2 = string;
        ArrayList<String> arrayList = new ArrayList<String>(4);
        while (true) {
            arrayList.add("nl" + File.separatorChar + string2.replace('_', File.separatorChar) + File.separatorChar + SPLASH_IMAGE);
            int n = string2.lastIndexOf(95);
            if (n == -1) break;
            string2 = string2.substring(0, n);
        }
        arrayList.add(SPLASH_IMAGE);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String resolve(String string) {
        if (string.startsWith(REFERENCE_SCHEME)) {
            string = string.substring(10);
        }
        if (string.startsWith(PLATFORM_URL)) {
            String string2 = string.substring(PLATFORM_URL.length());
            return this.getInstallLocation() + string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void log(Object object) {
        if (object == null) {
            return;
        }
        try {
            this.openLogFile();
            try {
                if (this.newSession) {
                    this.log.write(SESSION);
                    this.log.write(32);
                    String string = new Date().toString();
                    this.log.write(string);
                    this.log.write(32);
                    for (int i = SESSION.length() + string.length(); i < 78; ++i) {
                        this.log.write(45);
                    }
                    this.log.newLine();
                    this.newSession = false;
                }
                this.write(object);
            }
            finally {
                if (this.logFile == null) {
                    if (this.log != null) {
                        this.log.flush();
                    }
                } else {
                    this.closeLogFile();
                }
            }
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while writing to the platform log:");
            exception.printStackTrace(System.err);
            System.err.println("Logging to the console instead.");
            try {
                this.log = this.logForStream(System.err);
                this.write(object);
                this.log.flush();
            }
            catch (Exception exception2) {
                System.err.println("An exception occurred while logging to the console:");
                exception2.printStackTrace(System.err);
            }
        }
        finally {
            this.log = null;
        }
    }

    private void write(Object object) throws IOException {
        if (object == null) {
            return;
        }
        if (object instanceof Throwable) {
            this.log.write(STACK);
            this.log.newLine();
            ((Throwable)object).printStackTrace(new PrintWriter(this.log));
        } else {
            this.log.write(ENTRY);
            this.log.write(32);
            this.log.write(PLUGIN_ID);
            this.log.write(32);
            this.log.write(String.valueOf(4));
            this.log.write(32);
            this.log.write(String.valueOf(0));
            this.log.write(32);
            this.log.write(this.getDate(new Date()));
            this.log.newLine();
            this.log.write(MESSAGE);
            this.log.write(32);
            this.log.write(String.valueOf(object));
        }
        this.log.newLine();
    }

    protected String getDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPaddedInt(calendar.get(1), 4, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(2) + 1, 2, stringBuffer).append('-');
        this.appendPaddedInt(calendar.get(5), 2, stringBuffer).append(' ');
        this.appendPaddedInt(calendar.get(11), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(12), 2, stringBuffer).append(':');
        this.appendPaddedInt(calendar.get(13), 2, stringBuffer).append('.');
        this.appendPaddedInt(calendar.get(14), 3, stringBuffer);
        return stringBuffer.toString();
    }

    private StringBuffer appendPaddedInt(int n, int n2, StringBuffer stringBuffer) {
        if (--n2 == 0) {
            return stringBuffer.append(Integer.toString(n));
        }
        int n3 = (int)Math.pow(10.0, n2);
        if (n >= n3) {
            return stringBuffer.append(Integer.toString(n));
        }
        while (n3 > n && n3 > 1) {
            stringBuffer.append('0');
            n3 /= 10;
        }
        stringBuffer.append(n);
        return stringBuffer;
    }

    private void computeLogFileLocation() {
        String string = System.getProperty(PROP_LOGFILE);
        if (string != null) {
            if (this.logFile == null || !string.equals(this.logFile.getAbsolutePath())) {
                this.logFile = new File(string);
                new File(this.logFile.getParent()).mkdirs();
            }
            return;
        }
        URL uRL = Main.buildURL(System.getProperty(PROP_CONFIG_AREA), false);
        if (uRL == null) {
            return;
        }
        this.logFile = new File(uRL.getPath(), Long.toString(System.currentTimeMillis()) + ".log");
        new File(this.logFile.getParent()).mkdirs();
        System.getProperties().put(PROP_LOGFILE, this.logFile.getAbsolutePath());
    }

    private int hexToByte(byte by) {
        switch (by) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    private void openLogFile() throws IOException {
        this.computeLogFileLocation();
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException iOException) {
            this.logFile = null;
            throw iOException;
        }
    }

    private BufferedWriter logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    private void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        finally {
            this.log = null;
        }
    }

    private void mergeProperties(Properties properties, Properties properties2, Properties properties3) {
        if (properties == null || properties2 == null) {
            return;
        }
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (string3.equals(PROP_CLASSPATH)) {
                string2 = properties.getProperty(PROP_CLASSPATH);
                string = properties2.getProperty(PROP_CLASSPATH);
                string2 = string2 == null ? string : string2 + string;
                properties.put(PROP_CLASSPATH, string2);
                continue;
            }
            string2 = properties2.getProperty(string3);
            if (properties3 != null && !string3.endsWith(".override.user")) {
                boolean bl;
                string = string3 + ".override.user";
                boolean bl2 = bl = properties.getProperty(string) != null || properties2.getProperty(string) != null;
                if (bl && !properties3.contains(string3)) {
                    properties.put(string3, string2);
                    continue;
                }
            }
            if (properties.getProperty(string3) != null) continue;
            properties.put(string3, string2);
        }
    }

    private void setupVMProperties() {
        if (this.vm != null) {
            System.getProperties().put(PROP_VM, this.vm);
        }
        this.setMultiValueProperty(PROP_VMARGS, this.vmargs);
        this.setMultiValueProperty(PROP_COMMANDS, this.commands);
    }

    private void setMultiValueProperty(String string, String[] stringArray) {
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer(300);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('\n');
            }
            System.getProperties().put(string, stringBuffer.toString());
        }
    }

    private class StartupClassLoader
    extends URLClassLoader {
        public StartupClassLoader(URL[] uRLArray) {
            super(uRLArray);
        }

        public StartupClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super(uRLArray, classLoader);
        }

        public StartupClassLoader(URL[] uRLArray, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) {
            super(uRLArray, classLoader, uRLStreamHandlerFactory);
        }

        @Override
        protected String findLibrary(String string) {
            if (Main.this.extensionPaths == null) {
                return super.findLibrary(string);
            }
            String string2 = System.mapLibraryName(string);
            for (int i = 0; i < Main.this.extensionPaths.length; ++i) {
                File file = new File(Main.this.extensionPaths[i], string2);
                if (!file.isFile()) continue;
                return file.getAbsolutePath();
            }
            return super.findLibrary(string);
        }
    }

    private class EclipsePolicy
    extends Policy {
        private Policy policy;
        private URL[] urls;
        private PermissionCollection allPermissions;
        Permission allPermission = new AllPermission();

        EclipsePolicy(Policy policy, URL[] uRLArray) {
            this.policy = policy;
            this.urls = uRLArray;
            this.allPermissions = new PermissionCollection(){
                private static final long serialVersionUID = 3258131349494708277L;

                @Override
                public void add(Permission permission) {
                }

                @Override
                public boolean implies(Permission permission) {
                    return true;
                }

                public Enumeration elements() {
                    return new Enumeration(){
                        int cur = 0;

                        @Override
                        public boolean hasMoreElements() {
                            return this.cur < 1;
                        }

                        public Object nextElement() {
                            if (this.cur == 0) {
                                this.cur = 1;
                                return EclipsePolicy.this.allPermission;
                            }
                            throw new NoSuchElementException();
                        }
                    };
                }
            };
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codeSource) {
            if (this.contains(codeSource)) {
                return this.allPermissions;
            }
            return this.policy == null ? this.allPermissions : this.policy.getPermissions(codeSource);
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
            if (this.contains(protectionDomain.getCodeSource())) {
                return this.allPermissions;
            }
            return this.policy == null ? this.allPermissions : this.policy.getPermissions(protectionDomain);
        }

        @Override
        public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
            if (this.contains(protectionDomain.getCodeSource())) {
                return true;
            }
            return this.policy == null ? true : this.policy.implies(protectionDomain, permission);
        }

        @Override
        public void refresh() {
            if (this.policy != null) {
                this.policy.refresh();
            }
        }

        private boolean contains(CodeSource codeSource) {
            if (codeSource == null) {
                return false;
            }
            URL uRL = codeSource.getLocation();
            if (uRL == null) {
                return false;
            }
            for (int i = 0; i < this.urls.length; ++i) {
                if (this.urls[i] != uRL) continue;
                return true;
            }
            return false;
        }
    }

    static class Identifier {
        private static final String DELIM = ". _-";
        private int major;
        private int minor;
        private int service;

        Identifier(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.service = n3;
        }

        Identifier(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
            if (stringTokenizer.hasMoreTokens()) {
                this.major = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.minor = Integer.parseInt(stringTokenizer.nextToken());
            }
            try {
                if (stringTokenizer.hasMoreTokens()) {
                    this.service = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        boolean isGreaterEqualTo(Identifier identifier) {
            if (this.major < identifier.major) {
                return false;
            }
            if (this.major > identifier.major) {
                return true;
            }
            if (this.minor < identifier.minor) {
                return false;
            }
            if (this.minor > identifier.minor) {
                return true;
            }
            return this.service >= identifier.service;
        }
    }

    public final class SplashHandler
    extends Thread {
        @Override
        public void run() {
            Main.this.takeDownSplash();
        }

        public void updateSplash() {
            if (Main.this.bridge != null && !Main.this.splashDown) {
                Main.this.bridge.updateSplash();
            }
        }
    }
}

