/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.util;

import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.security.InvalidDigestException;
import de.vw.vaudes.diaghook.security.SecurityComponent;
import de.vw.vaudes.diaghook.transform.TranslatedTextTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessException;
import de.vw.vaudes.diaghook.util.JaxbUtils;
import de.vw.vaudes.xml.instpackage.TeilpaketTYPE;
import de.vw.vaudes.xml.instpackage.VAUDESInstallationspaket;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.partpackage.VAUDESTeilpaket;
import de.vw.vaudes.xml.stringtable.VAUDESStringTabelle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DiagnosticDataAccessHelper {
    private static final Log LOGGER = LogFactory.getLog((String)"de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper");

    private DiagnosticDataAccessHelper() {
    }

    public static Object parseFileFromJar(File file, String string, Class<?> clazz) throws DiagnosticDataAccessException {
        ZipEntry zipEntry;
        ZipFile zipFile;
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        InputStream inputStream2;
        Object var3_3;
        block17: {
            var3_3 = null;
            inputStream2 = null;
            inputStream = null;
            byteArrayOutputStream = null;
            zipFile = null;
            zipFile = new ZipFile(file);
            zipEntry = zipFile.getEntry(string);
            if (null != zipEntry) break block17;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Zip entry " + string + " does not exist in jarfile " + file.getAbsolutePath()));
            }
            Object var9_11 = var3_3;
            IOUtils.closeQuietly(inputStream2);
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
            if (null != zipFile) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    LOGGER.warn((Object)"Unable to close jar file. This may result in unnessesary file locks", (Throwable)iOException);
                }
            }
            return var9_11;
        }
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = zipFile.getInputStream(zipEntry);
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                SecurityComponent.getInstance().getSig().update(byArray, 0, n);
            }
            byte[] byArray2 = zipEntry.getExtra();
            if (null != byArray2 && !SecurityComponent.getInstance().getSig().verify(byArray2)) {
                throw new InvalidDigestException(file.getName(), zipEntry.getName());
            }
            inputStream2 = clazz.equals(VAUDESTeilpaket.class) || clazz.equals(VAUDESInstallationspaket.class) ? new ByteArrayInputStream(byteArrayOutputStream.toByteArray()) : new GZIPInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            var3_3 = JaxbUtils.unmarshal(inputStream2, clazz);
        }
        catch (Exception exception) {
            try {
                throw new DiagnosticDataAccessException("Error parsing file " + string + " in container file " + file.getAbsolutePath(), exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream2);
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(byteArrayOutputStream);
                if (null != zipFile) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {
                        LOGGER.warn((Object)"Unable to close jar file. This may result in unnessesary file locks", (Throwable)iOException);
                    }
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream2);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)byteArrayOutputStream);
        if (null != zipFile) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)"Unable to close jar file. This may result in unnessesary file locks", (Throwable)iOException);
            }
        }
        return var3_3;
    }

    public static Object getContentFileFromObject(IndicatedElement indicatedElement, String string, Class<?> clazz) {
        Object object = null;
        IndicatedElement indicatedElement2 = indicatedElement;
        if (null != indicatedElement2) {
            if (null != indicatedElement2.getInstallationIndexFile()) {
                try {
                    VAUDESInstallationspaket vAUDESInstallationspaket = JaxbUtils.unmarshal(indicatedElement2.getInstallationIndexFile(), VAUDESInstallationspaket.class);
                    for (VAUDESInstallationspaket.Teilpakete.Datei datei : vAUDESInstallationspaket.getTeilpakete().getDatei()) {
                        try {
                            Object object2 = DiagnosticDataAccessHelper.parseFileFromJar(new File(indicatedElement2.getInstallationIndexFile().getParentFile(), datei.getValue()), string, clazz);
                            if (object2 == null) continue;
                            object = object2;
                        }
                        catch (Exception exception) {
                            LOGGER.error((Object)exception);
                        }
                    }
                }
                catch (Exception exception) {
                    LOGGER.error((Object)("Error unmarshalling object with id " + indicatedElement + " from hotfix " + indicatedElement2.getInstallationIndexFile().getAbsolutePath()), (Throwable)exception);
                }
            } else {
                try {
                    String string2 = new File(indicatedElement.getUrl().getFile(), string).toURL().toString();
                    object = JaxbUtils.unmarshal(string2, VAUDESStringTabelle.class);
                }
                catch (Exception exception) {
                    LOGGER.error((Object)("Error parsing file " + indicatedElement.getUrl().getFile() + File.separator + string), (Throwable)exception);
                }
            }
        }
        return object;
    }

    public static Object parseFile(String string, Class<VAUDESObjekt> clazz) throws NonUniqueResultException {
        IndicatedElement indicatedElement = ObjectIndicator.getInstance().getObjectByIdOrSysName(string);
        if (null == indicatedElement) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"query database resolver");
            }
            return DatabaseResolver.getInstance().getFromDB(string, false);
        }
        return DiagnosticDataAccessHelper.parseFile(indicatedElement, clazz);
    }

    public static Object parseFileWithoutDatabase(String string, Class<VAUDESObjekt> clazz) {
        IndicatedElement indicatedElement = ObjectIndicator.getInstance().getObjectByIdOrSysName(string);
        if (null == indicatedElement) {
            return null;
        }
        return DiagnosticDataAccessHelper.parseFile(indicatedElement, clazz);
    }

    public static Object parseFile(IndicatedElement indicatedElement, Class<?> clazz) {
        Object var2_2 = null;
        if (null != indicatedElement.getInstallationIndexFile()) {
            try {
                File file = null;
                try {
                    file = new File(indicatedElement.getUrl().toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(indicatedElement.getUrl().getPath());
                }
                return DiagnosticDataAccessHelper.parseFileFromJar(file, indicatedElement.getFilename(), clazz);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error parsing object with id " + indicatedElement + " from hotfix " + indicatedElement.getInstallationIndexFile().getAbsolutePath()), (Throwable)exception);
            }
        } else {
            try {
                String string = new File(indicatedElement.getUrl().getFile(), indicatedElement.getFilename()).toURL().toString();
                var2_2 = JaxbUtils.unmarshal(string, clazz);
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error parsing object with id " + indicatedElement + " from atp " + indicatedElement.getUrl().getFile()), (Throwable)exception);
            }
        }
        return var2_2;
    }

    public static Object getLanguageDependentContentFileFromHotfix(File file, VAUDESObjekt.Dateien.Datei datei, Locale locale, Class<?> clazz) {
        Object object = null;
        VAUDESInstallationspaket vAUDESInstallationspaket = null;
        try {
            vAUDESInstallationspaket = JaxbUtils.unmarshal(file, VAUDESInstallationspaket.class);
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Error parsing installation index file " + file), (Throwable)exception);
        }
        if (!(vAUDESInstallationspaket instanceof VAUDESInstallationspaket)) {
            LOGGER.error((Object)("No installation index file found (expected: " + file.getAbsolutePath() + ")"));
            return object;
        }
        VAUDESInstallationspaket vAUDESInstallationspaket2 = vAUDESInstallationspaket;
        for (VAUDESInstallationspaket.Teilpakete.Datei datei2 : vAUDESInstallationspaket2.getTeilpakete().getDatei()) {
            if (!datei2.getTpTyp().equals((Object)TeilpaketTYPE.STRUKTUR_TP)) continue;
            try {
                Object object2;
                VAUDESTeilpaket vAUDESTeilpaket;
                Object object3 = DiagnosticDataAccessHelper.parseFileFromJar(new File(file.getParentFile() + File.separator + datei2.getValue()), "index.xml", VAUDESTeilpaket.class);
                if (!(object3 instanceof VAUDESTeilpaket) || !StringUtils.isNotEmpty((String)(vAUDESTeilpaket = (VAUDESTeilpaket)object3).getSprache()) || !TranslatedTextTransformHelper.isLocaleEqual(vAUDESTeilpaket.getSprache(), locale) || !((object2 = DiagnosticDataAccessHelper.parseFileFromJar(new File(file.getParentFile(), datei2.getValue()), datei.getValue(), VAUDESStringTabelle.class)) instanceof VAUDESStringTabelle)) continue;
                object = object2;
                break;
            }
            catch (Exception exception) {
                LOGGER.error((Object)("Error parsing file from hotfix " + file), (Throwable)exception);
            }
        }
        return object;
    }

    public static String getFilenameFromObject(VAUDESObjekt vAUDESObjekt, String string) {
        String string2 = "";
        if (null == vAUDESObjekt.getDateien()) {
            LOGGER.error((Object)("File id " + string + " not found at Object " + vAUDESObjekt.getId()));
            return string2;
        }
        for (VAUDESObjekt.Dateien.Datei datei : vAUDESObjekt.getDateien().getDatei()) {
            if (null == datei.getId() || !datei.getId().equals(string)) continue;
            return datei.getValue();
        }
        LOGGER.error((Object)("File id " + string + " not found at Object " + vAUDESObjekt.getId()));
        return string2;
    }
}

