/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.domainmodel.diag.bean.ITargetCurve;
import de.volkswagen.odis.vaudas.domainmodel.diag.factory.ITargetCurveFactory;
import de.vw.vaudes.diaghook.da.IDatabaseTargetCurve;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.IndicatedPresetMeasurementElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.TargetCurveTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.Validate;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TargetCurveFactoryImpl
implements ITargetCurveFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public List<ITargetCurve> getAllTargetCurves(List<ITargetCurve> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getAllTargetCurves(" + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<ITargetCurve>();
        }
        List<ITargetCurve> list2 = this.getAllTargetCurvesFromIndex(false);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("all target curves in index: " + list2));
        }
        this.mergeTargetCurves(list, list2);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("return merged " + list));
        }
        return list;
    }

    public List<ITargetCurve> getReleasedTargetCurves(List<ITargetCurve> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getReleasedTargetCurves(" + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<ITargetCurve>();
        }
        List<ITargetCurve> list2 = this.getAllTargetCurvesFromIndex(true);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("all released target curves in index: " + list2));
        }
        this.mergeTargetCurves(list, list2);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("return merged " + list));
        }
        return list;
    }

    public ITargetCurve getTargetCurveByGfsId(String string, ITargetCurve iTargetCurve) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTargetCurveByGfsId(" + string + ", " + iTargetCurve + ")"));
        }
        boolean bl = iTargetCurve != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                return iTargetCurve;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        try {
            ITargetCurve iTargetCurve2 = TargetCurveTransformHelper.createTargetCurveObjectFrom(vAUDESObjekt);
            if (iTargetCurve2 != null) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iTargetCurve2));
                }
                return iTargetCurve2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iTargetCurve));
                }
                return iTargetCurve;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (bl) {
                return iTargetCurve;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
    }

    public ITargetCurve getTargetCurveByKey(String string, ITargetCurve iTargetCurve) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getTargetCurveByKey(" + string + ", " + iTargetCurve + ")"));
        }
        boolean bl = iTargetCurve != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                return iTargetCurve;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            ITargetCurve iTargetCurve2 = TargetCurveTransformHelper.createTargetCurveObjectFrom(vAUDESObjekt);
            if (iTargetCurve2 != null) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iTargetCurve2));
                }
                return iTargetCurve2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iTargetCurve));
                }
                return iTargetCurve;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (bl) {
                return iTargetCurve;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
    }

    private List<ITargetCurve> getAllTargetCurvesFromIndex(boolean bl) {
        List<Object> list;
        ArrayList<ITargetCurve> arrayList = new ArrayList<ITargetCurve>();
        if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)"query database resolver");
            }
            list = null;
            list = bl ? DatabaseResolver.getInstance().getTargetCurves(bl) : DatabaseResolver.getInstance().getAllTargetCurves();
            arrayList.addAll(TargetCurveTransformHelper.transformTargetCurves(list));
        }
        list = new ArrayList();
        for (Map.Entry<String, IndicatedElement> entry : ObjectIndicator.getInstance().getObjectIndex().entrySet()) {
            if (!(entry.getValue() instanceof IndicatedPresetMeasurementElement)) continue;
            IndicatedPresetMeasurementElement indicatedPresetMeasurementElement = (IndicatedPresetMeasurementElement)entry.getValue();
            try {
                Object object;
                if ((!bl || !indicatedPresetMeasurementElement.isReleased()) && bl || !((object = DiagnosticDataAccessHelper.parseFile(entry.getKey(), VAUDESObjekt.class)) instanceof VAUDESObjekt)) continue;
                ITargetCurve iTargetCurve = TargetCurveTransformHelper.createTargetCurveObjectFrom((VAUDESObjekt)object);
                list.add((IDatabaseTargetCurve)iTargetCurve);
            }
            catch (Exception exception) {
                this.fLogger.error((Object)("Error while parsing object with id " + entry.getKey()), (Throwable)exception);
            }
        }
        this.mergeTargetCurves(arrayList, list);
        return arrayList;
    }

    private void mergeTargetCurves(List<ITargetCurve> list, Collection<ITargetCurve> collection) {
        if (list.isEmpty()) {
            list.addAll(collection);
            return;
        }
        ArrayList<ITargetCurve> arrayList = new ArrayList<ITargetCurve>();
        block0: for (ITargetCurve iTargetCurve : list) {
            if (iTargetCurve.getTargetCurveKey() == null) continue;
            for (ITargetCurve iTargetCurve2 : collection) {
                if (null == iTargetCurve2.getTargetCurveKey() || !iTargetCurve.getTargetCurveKey().equalsIgnoreCase(iTargetCurve2.getTargetCurveKey())) continue;
                TargetCurveTransformHelper.adjustTargetCurve(iTargetCurve, iTargetCurve2);
                arrayList.add(iTargetCurve2);
                continue block0;
            }
        }
        collection.removeAll(arrayList);
        list.addAll(collection);
    }
}

