/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.event.brand.Brand;
import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.domainmodel.diag.bean.IEquipmentNode;
import de.volkswagen.odis.vaudas.domainmodel.diag.factory.IEquipmentNodeFactory;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.IndicatedEquipmentNodeElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.EquipmentObjTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.Validate;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EquipmentTreeNodeFactoryImpl
implements IEquipmentNodeFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public IEquipmentNode getEquipmentNode(String string, IEquipmentNode iEquipmentNode) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEquipmentNode(" + string + ", " + iEquipmentNode + ")"));
        }
        boolean bl = iEquipmentNode != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iEquipmentNode));
                }
                return iEquipmentNode;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        try {
            IEquipmentNode iEquipmentNode2 = EquipmentObjTransformHelper.createEquipmentObjectFrom(vAUDESObjekt);
            if (null != iEquipmentNode2) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iEquipmentNode2));
                }
                return iEquipmentNode2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iEquipmentNode));
                }
                return iEquipmentNode;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (null == iEquipmentNode) {
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
            return iEquipmentNode;
        }
    }

    public List<IEquipmentNode> getEquipmentNodeChildren(String string, List<IEquipmentNode> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getEquipmentNodeChildren(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEquipmentNode>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(EquipmentObjTransformHelper.getEquipmentNodeChildrenFrom(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming equipment children objects from object " + string), (Throwable)exception);
            return list;
        }
    }

    public List<IEquipmentNode> getManufacturerNodesForBrand(Brand brand, List<IEquipmentNode> list) throws OdisBaseException {
        Validate.notNull(brand);
        Validate.notEmpty(brand.getKvpsKey());
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getManufacturerNodesForBrand(" + brand + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IEquipmentNode>();
        }
        if (list.size() > 1) {
            this.fLogger.error((Object)"More than one 'Manufacturer Node' received. Workin with object at index 1.");
        }
        try {
            IEquipmentNode iEquipmentNode = null;
            Object object = ObjectIndicator.getInstance().getObjectIndex().entrySet().iterator();
            while (object.hasNext()) {
                Object object2;
                Map.Entry<String, IndicatedElement> entry = object.next();
                if (!(entry.getValue() instanceof IndicatedEquipmentNodeElement) || !StringUtils.isNotEmpty((String)((IndicatedEquipmentNodeElement)entry.getValue()).getKvpsKey()) || !brand.getKvpsKey().equalsIgnoreCase(((IndicatedEquipmentNodeElement)entry.getValue()).getKvpsKey())) continue;
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("found brand " + brand + " in index"));
                }
                if (!((object2 = DiagnosticDataAccessHelper.parseFile(entry.getKey(), VAUDESObjekt.class)) instanceof VAUDESObjekt)) {
                    this.fLogger.error((Object)("Error on parsing object with id " + entry.getKey()));
                    break;
                }
                iEquipmentNode = EquipmentObjTransformHelper.createEquipmentObjectFrom((VAUDESObjekt)object2);
                break;
            }
            if (iEquipmentNode == null && DatabaseResolver.getInstance().isDatabaseAvailable()) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"query database resolver");
                }
                if ((object = DatabaseResolver.getInstance().getEuipmentNodeByKvpsKey(brand)) != null) {
                    iEquipmentNode = EquipmentObjTransformHelper.createEquipmentObjectFrom((VAUDESObjekt)object);
                }
            }
            if (iEquipmentNode != null) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"Found 'Manufacturer Node' in Hook scope");
                }
                list.clear();
                list.add(iEquipmentNode);
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + list));
                }
            } else if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return " + list));
            }
            return list;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming equipment objects for brand " + brand.getKvpsKey()), (Throwable)exception);
            return list;
        }
    }
}

