/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.wireadmin;

import java.io.Serializable;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.felix.wireadmin.EventManager;
import org.apache.felix.wireadmin.WireAdminImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.wireadmin.Consumer;
import org.osgi.service.wireadmin.Producer;
import org.osgi.service.wireadmin.Wire;

public class WireImpl
implements Wire,
Serializable {
    static final long serialVersionUID = -3637966367104019136L;
    private String m_producerPID;
    private String m_consumerPID;
    private Dictionary m_properties;
    private transient boolean m_isValid = true;
    private transient boolean m_isConnected = false;
    private transient Filter m_filter = null;
    private transient ServiceReference m_producerServiceRef;
    private transient Producer m_producer;
    private transient boolean m_producerIsComposite = false;
    private transient String[] m_producerScope = null;
    private transient ServiceReference m_consumerServiceRef;
    private transient Consumer m_consumer;
    private transient boolean m_consumerIsComposite = false;
    private transient String[] m_consumerScope = null;
    private transient BundleContext m_bundleContext;
    private transient EventManager m_eventManager;
    private transient Object m_lastValue;
    private transient String[] m_scope;
    private transient long m_lastUpdate;
    private transient boolean m_isFirstUpdate;
    transient FilterDictionary m_dictionary;

    WireImpl(String producerPID, String consumerPID, Dictionary properties) {
        this.m_producerPID = producerPID;
        this.m_consumerPID = consumerPID;
        this.m_properties = properties;
        this.m_scope = null;
    }

    void initialize(BundleContext ctxt, EventManager eventManager) {
        this.m_isValid = true;
        this.m_isConnected = false;
        this.m_bundleContext = ctxt;
        this.m_eventManager = eventManager;
        this.m_lastValue = null;
        this.m_lastUpdate = 0L;
        this.m_isFirstUpdate = true;
        this.m_dictionary = new FilterDictionary();
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public boolean isConnected() {
        return this.m_isConnected;
    }

    public Class[] getFlavors() {
        if (this.isConnected()) {
            try {
                return (Class[])this.m_consumerServiceRef.getProperty("wireadmin.consumer.flavors");
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return null;
    }

    public void update(Object value) {
        if (this.isConnected()) {
            if (this.m_producerIsComposite) {
                WireAdminImpl.traceln("WireImpl.update: update for composite producers not yet implemented");
                return;
            }
            long time = new Date().getTime();
            if (!this.m_isFirstUpdate && this.m_filter != null) {
                try {
                    this.m_dictionary.reset(value, time);
                    if (!this.m_filter.match((Dictionary)this.m_dictionary)) {
                        WireAdminImpl.traceln("### Update rejected (" + this.m_properties.get("wireadmin.pid") + ") filter evaluated to false:" + this.m_filter);
                        WireAdminImpl.traceln("  WIREVALUE_CURRENT.class" + this.m_dictionary.get("wirevalue.current").getClass().getName());
                        WireAdminImpl.traceln("  WIREVALUE_CURRENT=" + this.m_dictionary.get("wirevalue.current"));
                        WireAdminImpl.traceln("  WIREVALUE_PREVIOUS=" + this.m_dictionary.get("wirevalue.previous"));
                        WireAdminImpl.traceln("  WIREVALUE_DELTA_ABSOLUTE=" + this.m_dictionary.get("wirevalue.delta.absolute"));
                        WireAdminImpl.traceln("  WIREVALUE_DELTA_RELATIVE=" + this.m_dictionary.get("wirevalue.delta.relative"));
                        WireAdminImpl.traceln("  WIREVALUE_ELAPSED=" + this.m_dictionary.get("wirevalue.elapsed"));
                        return;
                    }
                }
                catch (Exception ex) {
                    WireAdminImpl.trace(ex);
                }
            }
            try {
                this.m_consumer.updated((Wire)this, value);
                if (this.m_isFirstUpdate) {
                    this.m_isFirstUpdate = false;
                }
                this.m_lastUpdate = time;
                this.m_lastValue = value;
                this.m_eventManager.fireEvent(128, this);
            }
            catch (Exception ex) {
                this.m_eventManager.fireEvent(2, this, ex);
            }
        }
    }

    public Object poll() {
        if (this.isConnected()) {
            try {
                Object value = this.m_producer.polled((Wire)this);
                Class[] flavors = this.getFlavors();
                boolean valueOk = false;
                int i = 0;
                while (i < flavors.length) {
                    Class currentClass = flavors[i];
                    if (currentClass.isInstance(value)) {
                        valueOk = true;
                    }
                    ++i;
                }
                if (valueOk) {
                    this.m_eventManager.fireEvent(128, this);
                    this.m_lastValue = value;
                    return this.m_lastValue;
                }
                WireAdminImpl.traceln("WireImpl.poll: value returned by producer is not undestood by consumer");
                return null;
            }
            catch (Exception ex) {
                this.m_eventManager.fireEvent(1, this, ex);
                return null;
            }
        }
        return null;
    }

    public Object getLastValue() {
        return this.m_lastValue;
    }

    public Dictionary getProperties() {
        return this.m_properties;
    }

    public String[] getScope() {
        return this.m_scope;
    }

    public boolean hasScope(String name) {
        if (this.m_scope != null) {
            int i = 0;
            while (i < this.m_scope.length) {
                if (name.equals(this.m_scope[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":[" + this.getProperties().get("wireadmin.pid") + "," + this.getProperties().get("wireadmin.producer.pid") + "," + this.getProperties().get("wireadmin.consumer.pid") + "]";
    }

    void bindConsumer(ServiceReference consumerRef) {
        if (this.m_consumerServiceRef != null) {
            WireAdminImpl.traceln("WireImpl: consumer already bound!");
            return;
        }
        if (consumerRef.getProperty("service.pid") == null) {
            WireAdminImpl.traceln("WireImpl: Consumer service has no PID " + consumerRef);
            return;
        }
        if (consumerRef.getProperty("wireadmin.consumer.flavors") == null) {
            WireAdminImpl.traceln("WireImpl: Consumer service has no WIREADMIN_CONSUMER_FLAVORS " + consumerRef);
            return;
        }
        if (consumerRef.getProperty("wireadmin.consumer.composite") != null) {
            this.m_consumerIsComposite = true;
            this.m_consumerScope = (String[])consumerRef.getProperty("wireadmin.consumer.scope");
        }
        this.m_consumerServiceRef = consumerRef;
        this.m_consumer = (Consumer)this.m_bundleContext.getService(consumerRef);
        if (this.m_producer != null) {
            if (this.m_producerIsComposite && !this.matchComposites()) {
                WireAdminImpl.traceln("WireImpl.bindConsumer : warning composite identities do not match");
            }
            this.m_isConnected = true;
            this.m_eventManager.fireEvent(32, this);
        }
    }

    void unbindConsumer() {
        if (this.m_consumerServiceRef != null) {
            this.m_bundleContext.ungetService(this.m_consumerServiceRef);
            if (this.m_isConnected) {
                this.m_isConnected = false;
                this.m_eventManager.fireEvent(64, this);
            }
            this.m_consumer = null;
            this.m_consumerServiceRef = null;
        }
    }

    void bindProducer(ServiceReference producerRef) {
        String filter;
        if (this.m_producerServiceRef != null) {
            WireAdminImpl.traceln("WireImpl: producer already bound!");
            return;
        }
        if (producerRef.getProperty("service.pid") == null) {
            WireAdminImpl.traceln("WireImpl.bindProducer: Producer service has no PID " + producerRef);
            return;
        }
        if (producerRef.getProperty("wireadmin.producer.flavors") == null) {
            WireAdminImpl.traceln("WireImpl: Consumer service has no WIREADMIN_PRODUCER_FLAVORS " + producerRef);
            return;
        }
        if (producerRef.getProperty("wireadmin.producer.composite") != null) {
            this.m_producerIsComposite = true;
            this.m_producerScope = (String[])producerRef.getProperty("wireadmin.producer.scope");
        }
        this.m_producerServiceRef = producerRef;
        this.m_producer = (Producer)this.m_bundleContext.getService(producerRef);
        if (producerRef.getProperty("wireadmin.producer.filters") == null && (filter = (String)this.m_properties.get("wireadmin.filter")) != null) {
            try {
                this.m_filter = this.m_bundleContext.createFilter(filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                WireAdminImpl.traceln("WireImpl.bindProducer: Ignoring filter with invalid syntax " + filter);
            }
        }
        if (this.m_consumer != null) {
            if (this.m_consumerIsComposite && !this.matchComposites()) {
                WireAdminImpl.traceln("WireImpl.bindProducer : warning composite identities do not match");
            }
            this.m_isConnected = true;
            this.m_eventManager.fireEvent(32, this);
        }
    }

    void unbindProducer() {
        if (this.m_producerServiceRef != null) {
            this.m_bundleContext.ungetService(this.m_producerServiceRef);
            if (this.m_isConnected) {
                this.m_isConnected = false;
                this.m_eventManager.fireEvent(64, this);
            }
            this.m_producer = null;
            this.m_producerServiceRef = null;
        }
    }

    private boolean matchComposites() {
        String[] producerIdentities = (String[])this.m_producerServiceRef.getProperty("wireadmin.producer.composite");
        String[] consumerIdentities = (String[])this.m_producerServiceRef.getProperty("wireadmin.producer.composite");
        boolean match = false;
        int i = 0;
        while (i < producerIdentities.length) {
            String currentProducerIdentity = producerIdentities[i];
            int j = 0;
            while (j < consumerIdentities.length) {
                String currentConsumerIdentity = consumerIdentities[j];
                if (currentProducerIdentity.equals(currentConsumerIdentity)) {
                    match = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (this.m_consumerScope != null && this.m_producerScope != null) {
            if (this.m_consumerScope.length == 1 && this.m_consumerScope[0].equals("*")) {
                this.m_scope = this.m_producerScope;
            } else if (this.m_producerScope.length == 1 && this.m_producerScope[0].equals("*")) {
                this.m_scope = this.m_consumerScope;
            }
        } else {
            this.m_scope = null;
        }
        return match;
    }

    void invalidate() {
        if (this.m_isValid) {
            this.unbindProducer();
            this.unbindConsumer();
            this.m_isValid = false;
        }
    }

    void updateProperties(Dictionary properties) {
        this.m_properties = properties;
    }

    ServiceReference getProducerServiceRef() {
        return this.m_producerServiceRef;
    }

    Producer getProducer() {
        return this.m_producer;
    }

    String getProducerPID() {
        return this.m_producerPID;
    }

    ServiceReference getConsumerServiceRef() {
        return this.m_consumerServiceRef;
    }

    Consumer getConsumer() {
        return this.m_consumer;
    }

    String getConsumerPID() {
        return this.m_consumerPID;
    }

    class FilterDictionary
    extends Dictionary {
        private Object m_value;
        private long m_time;

        FilterDictionary() {
        }

        void reset(Object value, long time) {
            this.m_value = value;
            this.m_time = time;
        }

        public Object get(Object key) {
            if (key.equals("wirevalue.current")) {
                return this.m_value;
            }
            if (key.equals("wirevalue.previous")) {
                return WireImpl.this.m_lastValue;
            }
            if (this.m_value instanceof Number && key.equals("wirevalue.delta.absolute")) {
                return null;
            }
            if (this.m_value instanceof Number && key.equals("wirevalue.delta.relative")) {
                return null;
            }
            if (key.equals("wirevalue.elapsed")) {
                if (WireImpl.this.m_lastUpdate == 0L) {
                    return new Long(0L);
                }
                long delay = this.m_time - WireImpl.this.m_lastUpdate;
                return new Long(delay);
            }
            WireAdminImpl.traceln("### key not found:" + key);
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public Object remove(Object obj) {
            return null;
        }

        public int size() {
            return 5;
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public Enumeration keys() {
            Vector<String> keys = new Vector<String>();
            keys.addElement("wirevalue.elapsed");
            keys.addElement("wirevalue.current");
            keys.addElement("wirevalue.previous");
            keys.addElement("wirevalue.delta.absolute");
            keys.addElement("wirevalue.delta.relative");
            return keys.elements();
        }

        public Enumeration elements() {
            return null;
        }
    }
}

