# -------------------- debugger --------------------
import bdb
import time
# from java.awt import *

# engine status
#
#    0 = uninitialized
# 1 = running with delay
# 2 = paused
# 3 = debug
# 4 = stop - will stop the debugger
# initialized in the interpreter by MacroEngine.Java
#state = 0

# debug modes
# 1 = single step
# 0 = animate
# initialized in the interpreter by MacroEngine.Java
#debug_mode = 0

# toggle for single step
do_step = 0

# delay between two steps in timed mode
# initialized in the interpreter by MacroEngine.Java
#period = 0.1

# the current linenumber
lineNumber = 0

# global variables
globals = ""

# global variables
locals = ""

# macro file
#theFile = ""
# the debugger class
#
#    Parameter: the python debugger library class to be extended
class Tdb(bdb.Bdb):

    # methods

    # performs the interaction on call, line, return and exception
    # parameters: frame    current frame
    # reason text to display in front of line
    def interact(self, frame, reason):
        #import linecache    # stores the code
        global state
        global debug_mode
        global do_step
        global lineNumber
        global globals
        global locals
        global mainpyfile
        import java.lang.System

        # get attributes of the current frame
        name = frame.f_code.co_name
        # the main module does not have a name
        if not name: name = '???'

        # if we are not in the current macro file, we do nothing
        fn = frame.f_code.co_filename
        if fn != mainpyfile:
            #print "no debug: ", fn #, " not ", theFile
            return

        lineNumber = frame.f_lineno
        # print "----------------------> ", state, debug_mode, lineNumber
        if state == 1:
            #timed mode -- running
            try:
                if period < 0.001:
                    # we have to use a minimum delay of 1 ms, because otherwhiles
                    # there is no chance to interrupt the macro with pause or stop
                    time.sleep(0.001)
                else:
                    time.sleep(period)
            except:
                state = 4;
        elif state == 2:
            # pause
            while state == 2:
                time.sleep(0.1)
        elif state == 4:
            # stop
            print "macro aborted by user"
            self.set_quit()
        elif state == 3:
            # debug mode
            lineNumber = frame.f_lineno

            locals = ""
            for loc in frame.f_locals:
                curLine = "%s = %s\n" % (loc,frame.f_locals[loc])
                locals = locals + curLine

            globals = ""
            for loc in frame.f_globals:
                if loc != "__builtins__":
                    curLine = "%s = %s\n" % (loc,frame.f_globals[loc])
                    globals = globals + curLine
            try:
                if period < 0.1:
                    time.sleep(0.1)
                else:
                    time.sleep(period)
            except:
                state = 4;
            # wait for STEP-Button to be pressed
            while do_step == 0 and debug_mode == 1 and state == 3:
                time.sleep(0.1)
                    #print '*', state,
            #reset toggle
            do_step = 0
        else:
            # dazed and confused ...
            print "wrong state: ", state
            state = 4

    # actions taken, when a line of code is executed
    def user_line(self, frame):
        self.interact(frame, "line")
        # print "function ", "user_line "

    # actions taken, when an exception occured
    def user_exception(self, frame, exc_stuff):
        if state == 3:
            print '++++ exception ++++', exc_stuff
            fn = self.canonic(frame.f_code.co_filename)
            line = linecache.getline(fn, frame.f_lineno)
            print frame.f_lineno, frame.f_code.co_name, ':', line.strip()

# main method, loading the file to debug and start execution
    def debug(self,event):
        filename = mainpyfile
        # start with a fresh set of global and local variables
        globals_ = {"__name__" : "__main__", "__file__" : filename}
        locals_ = globals_
        runmode = 0
    #    t.run('import target; target.doit(10)')
        pyfile = t.canonic(filename)
        statement = 'execfile( "%s")' % filename
        print filename
        self.run(statement, globals=globals_, locals=locals_)

# main program
import sys
import os

if not os.path.exists(mainpyfile):
    print 'Error: ', mainpyfile, ' does not exist'
    state = 4
    sys.exit(1)

#theFile = mainpyfile
# set script's dir in module search path.
sys.path[0] = os.path.dirname(mainpyfile)
# append path of the automation classes, if not already present
if sys.path.count(diag_interface) < 1:
    sys.path.append(diag_interface)
#sys.path.append("C:/cmsynergy/soe/ccm_wa/odis/Odis Engineering/VAUDAS-SE~soe/VAUDAS-SE/VAUDAS/vaudas.junit.business.vehiclefunction.automation/bin")
#from de.volkswagen.odis.vaudas.vehiclefunction.automation.zecret import DiagnosticInterfaceImpl

# start the debugger
t = Tdb()
t.debug(mainpyfile)
#t.dbgwin.dispose()
del t
print "macro execution finished"
state = 4
lineNumber = 0
# end
