<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- version of this stylesheet document  -->
	<xsl:param name="ODIS_E_SNAPSHOT_STYLESHEET_VERSION">0.2.01</xsl:param>

	<xsl:param name="Text_DtcSnapshotExport">DTC Snapshot Export</xsl:param> 
	<xsl:param name="Text_DevDtcSnapshotExport">Developer DTC Snapshot Export</xsl:param> 
	
	<xsl:param name="Text_CurTime">Uhrzeit</xsl:param>
	<xsl:param name="Text_CurDate">Datum</xsl:param>
	
	<xsl:param name="Text_DtcCode">Ereigniscode</xsl:param>
	<xsl:param name="Text_DtcSaeCode">SAE-Code</xsl:param>
	<xsl:param name="Text_DtcErrorText">Ereignistext</xsl:param>
	<xsl:param name="Text_DtcState">Status</xsl:param>
	<xsl:param name="Text_DtcStateActive">aktiv</xsl:param>
	<xsl:param name="Text_DtcStateSporadic">sporadisch</xsl:param>
	<xsl:param name="Text_DtcRDID">RDID</xsl:param>

	<xsl:param name="Text_DtcMeasurementName">Snapshot Messwertname</xsl:param>
	<xsl:param name="Text_DtcEnvName">Umgebungsbedingung Typ/Name</xsl:param>
	<xsl:param name="Text_DtcEnvValues">Wert</xsl:param>

	<xsl:param name="Text_Vehicle">Fahrzeug</xsl:param>
	<xsl:param name="Text_Ecu">ECU</xsl:param>
	<xsl:param name="Text_Dtc">DTC</xsl:param>
	
	<xsl:template match="protocol">
	  <html>
		<head>
		  <style type="text/css">
			.default_style_ecu {background-color:#efefef;margin-top:4;margin-bottom:4;font-size:10pt;font-family:Arial;direction:ltr;width:200mm}

			.table_overview_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:220mm}
			.table_overview_title_row_spec {border: 1px solid black;background-color:#efefef;width:110mm;text-align:center}
			.table_overview_key_row_spec {border: 1px solid black;background-color:#efefef;width:40mm;text-align:left}
			.table_overview_value_row_spec {border: 1px solid black;width:180mm;text-align:left}

			.table_env_spec {border-width:0;border-collapse:collapse;padding:0;margin:0;width:220mm}
			.table_env_column_label_spec {border: 1px solid black;background-color:#efefef;text-align:left;font-weight:bold;width:25mm}
			.table_env_value_spec {border: 1px solid black;width:10mm;text-align:left}
			
			.table_snapshot_spec {border-width:0;border-collapse:collapse;padding:0;margin:0}
			.table_snapshot_dtc_row_spec {border: 1px solid black;background-color:#efefef;text-align:left}
			.table_snapshot_column_label_spec {border: 1px solid black;background-color:#efefef;text-align:left;font-weight:bold;width:25mm}
			.table_snapshot_value_spec {border: 1px solid black;width:10mm;text-align:left}
		  </style>

		  <xsl:if test="vehicle/communications/ecus/ecu/ecu_master[@type='event_memory_snapshot_export']">
		    <title><xsl:value-of select="$Text_DtcSnapshotExport" /></title>
		  </xsl:if>
		  <xsl:if test="vehicle/communications/ecus/ecu/ecu_master[@type='dev_event_memory_snapshot_export']">
		    <title><xsl:value-of select="$Text_DevDtcSnapshotExport" /></title>
		  </xsl:if>
		</head>

		<body>
		  <xsl:call-template name="display_overview_table"/>
		  <br/>
		  <br/>

		  <xsl:call-template name="display_dtc_snapshot_tables"/>
		</body>
	  </html>
	</xsl:template>

	<!-- display a snapshot table for each 'ecu_master' -->
	<xsl:template name="display_dtc_snapshot_tables">
	  <xsl:for-each select="/protocol/vehicle/communications/ecus/ecu/ecu_master[@type='dev_event_memory_snapshot_export']">
		<!-- repeat for each dtc entry -->
		<xsl:for-each select="values">
		  <!-- display the current snapshot records for the current dtc -->
		  <xsl:call-template name="display_dtc_snapshot_table" />
		  <br/>
	    </xsl:for-each>
	  </xsl:for-each>
	  <xsl:for-each select="/protocol/vehicle/communications/ecus/ecu/ecu_master[@type='event_memory_snapshot_export']">
		<!-- repeat for each dtc entry -->
		<xsl:for-each select="values">
		  <!-- display the current snapshot records for the current dtc -->
		  <xsl:call-template name="display_dtc_snapshot_table" />
		  <br/>
	    </xsl:for-each>
	  </xsl:for-each>
	</xsl:template>

	<!-- display the dtc environment values -->
	<xsl:template name="display_dtc_environment">
	  <xsl:if test="count(./measurement_values/values) &gt; 0">
	  	<xsl:call-template name="display_dtc_env_column_labels" />
		<xsl:for-each select="./measurement_values/values">
		  <xsl:call-template name="display_generic_dtc_env_table">
			<xsl:with-param name="divlevel" select="0" />
			<xsl:with-param name="measurement_name">
			  <xsl:call-template name="display_measurement_name">
			    <xsl:with-param name="measurement_display_name"><xsl:value-of select="./display_name" /></xsl:with-param>
			  </xsl:call-template>
			</xsl:with-param>
  		  </xsl:call-template>	  
	    </xsl:for-each>
	  </xsl:if>
	</xsl:template>

	<!-- display the snapshot table -->
	<xsl:template name="display_dtc_snapshot_table">

	  <xsl:if test="count(./snapshot_values/values) = 0">
	    <table class="table_env_spec">
		  <xsl:call-template name="display_dtc_header" />
		  <xsl:call-template name="display_dtc_environment" />
        </table>
	  </xsl:if>

	  <xsl:if test="count(./snapshot_values/values) &gt; 0">
	    <table class="table_snapshot_spec">
		  <xsl:call-template name="display_dtc_header" />
		  <xsl:call-template name="display_dtc_environment" />

		  <!-- display column labels -->
		  <xsl:call-template name="display_dtc_snapshot_column_labels" />
		  <!-- repeat for each snapshot measurement -->
		  <xsl:for-each select="./snapshot_values/values">
	        <xsl:call-template name="display_generic_dtc_snapshots_table">
			  <xsl:with-param name="divlevel" select="0" />
			  <xsl:with-param name="measurement_name">
			    <xsl:call-template name="display_measurement_name">
				  <xsl:with-param name="measurement_display_name"><xsl:value-of select="./display_name" /></xsl:with-param>
				</xsl:call-template>
			  </xsl:with-param>
			  <xsl:with-param name="measurement_rdid">
			    <xsl:call-template name="display_measurement_rdid">
				  <xsl:with-param name="measurement_display_name"><xsl:value-of select="./display_name" /></xsl:with-param>
				</xsl:call-template>
			  </xsl:with-param>
			</xsl:call-template>	  
		  </xsl:for-each>
        </table>
      </xsl:if>	
	</xsl:template>

	<!-- display the current ecu -->
	<xsl:template name="display_ecu_entry">
	  <xsl:value-of select="ecu_id" />
	  <xsl:text> - </xsl:text>
	  <xsl:value-of select="ecu_name" />
	  &#160;
	  <xsl:text> (</xsl:text>
	  <xsl:value-of select="logicallink" />
	  <xsl:if test="tester_odx_variant">
		<xsl:text> / </xsl:text><xsl:value-of select="tester_odx_variant" />
	  </xsl:if>
	  <xsl:text>)</xsl:text>
	</xsl:template>

	<!-- display the dtc header -->
	<xsl:template name="display_dtc_header">
	  <tr>
	    <td class="table_snapshot_dtc_row_spec" colspan="20">
		  <b><xsl:value-of select="$Text_DtcCode" /><xsl:text>: </xsl:text></b>
		  <xsl:value-of select="./hex_fault_number"/>
		  <xsl:text> (</xsl:text>
		  <xsl:value-of select="./fault_number"/>
		  <xsl:text>)   </xsl:text>

		  <br/><b><xsl:value-of select="$Text_DtcSaeCode" /><xsl:text>: </xsl:text></b>
		  <xsl:value-of select="./sae_number"/>

		  <br/><b><xsl:value-of select="$Text_DtcState" /><xsl:text>: </xsl:text></b>
		  <xsl:choose>
			  <xsl:when test="./event_status/event[display_name='ERRORSTATE']/display_value='sporadic'"><xsl:value-of select="$Text_DtcStateSporadic"/></xsl:when>
			  <xsl:when test="./event_status/event[display_name='ERRORSTATE']/display_value='static'"><xsl:value-of select="$Text_DtcStateActive"/></xsl:when>
		  </xsl:choose>

		  <br/><b><xsl:value-of select="$Text_DtcErrorText" /><xsl:text>: </xsl:text></b>
		  <xsl:value-of select="./display_name"/>
		  <xsl:text> (</xsl:text>
		    <xsl:value-of select="./dtc_text"/>
		  <xsl:text>)</xsl:text>
	    </td>
      </tr>
	</xsl:template>

	<!-- display the labels of the environment table -->
	<xsl:template name="display_dtc_env_column_labels">
	  <tr>
		<td class="table_env_column_label_spec">
			<xsl:value-of select="$Text_DtcEnvName" />
		</td>
		<td class="table_env_column_label_spec" colspan="20">
			<xsl:value-of select="$Text_DtcEnvValues" />
		</td>
	  </tr>
	</xsl:template>

	<!-- display the labels of the snapshot table -->
	<xsl:template name="display_dtc_snapshot_column_labels">
	  <tr>
		<td class="table_snapshot_column_label_spec">
			<xsl:value-of select="$Text_DtcMeasurementName" />
		</td>
		<td class="table_snapshot_column_label_spec" style='width:8mm'>
			<xsl:value-of select="$Text_DtcRDID" />
		</td>
		<!-- insert a descriptor for each snapshot record -->
		<xsl:call-template name="insert_snapshot_column_descriptor" />
	  </tr>
	</xsl:template>

	<!-- display the column descriptor for each snapshot number -->
	<xsl:template name="insert_snapshot_column_descriptor">
      <xsl:if test="count(./snapshot_values[1]/values[1]/values[1]/values[1]/values[1]/values[display_name='Snapshot 1']) &gt; 0">
		<xsl:for-each select="./snapshot_values[1]/values[1]/values[1]/values[1]/values[1]/values">
		  <td class="table_snapshot_column_label_spec">
		    <xsl:value-of select="./display_name" />
		  </td>
		</xsl:for-each>
	  </xsl:if>		
	  <xsl:if test="count(./snapshot_values[1]/values[1]/values[1]/values[1]/values[display_name='Snapshot 1']) &gt; 0">
	    <xsl:for-each select="./snapshot_values[1]/values[1]/values[1]/values[1]/values">
		  <td class="table_snapshot_column_label_spec">
		    <xsl:value-of select="./display_name" />
		  </td>
        </xsl:for-each>
      </xsl:if>
	  <xsl:if test="count(./snapshot_values[1]/values[1]/values[1]/values[display_name='Snapshot 1']) &gt; 0">
		<xsl:for-each select="./snapshot_values[1]/values[1]/values[1]/values">
		  <td class="table_snapshot_column_label_spec">
		    <xsl:value-of select="./display_name" />
		  </td>
        </xsl:for-each>
      </xsl:if>
	  <xsl:if test="count(./snapshot_values[1]/values[1]/values[display_name='Snapshot 1']) &gt; 0">
	    <xsl:for-each select="./snapshot_values[1]/values[1]/values">
		  <td class="table_snapshot_column_label_spec">
		    <xsl:value-of select="./display_name" />
		  </td>
        </xsl:for-each>
      </xsl:if>
	</xsl:template>

	<!-- diplay the table for the dtc-environment -->
	<xsl:template name="display_generic_dtc_env_table">
	  <xsl:param name="divlevel" />
	  <xsl:param name="measurement_name" />
	  <!-- add row only if name or value is available -->
	  <xsl:if test="string-length($measurement_name) != 0 or string-length(./display_value) != 0">
        <tr>
		  <!-- DTC-Measurement-(Structure)-Name -->
		  <td class="table_env_value_spec" style='width:110mm'>
		    <xsl:choose>
		      <!--<xsl:when test="$divlevel='0'"><b><xsl:value-of select="$measurement_name" /></b></xsl:when>-->
			  <xsl:when test="$divlevel='0'"><xsl:value-of select="$measurement_name" /></xsl:when>
			  <xsl:when test="$divlevel='1'">&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			  <xsl:when test="$divlevel='2'">&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			  <xsl:when test="$divlevel='3'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			  <xsl:when test="$divlevel='4'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			  <xsl:when test="$divlevel='5'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			  <xsl:when test="$divlevel='6'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			  <xsl:when test="$divlevel='7'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
		    </xsl:choose>
          </td>
		  <td class="table_env_value_spec" style='width:110mm' colspan="20">
	        <xsl:for-each select="display_value"><xsl:value-of select="." /></xsl:for-each>
          </td>
	    </tr>
      </xsl:if>
	  <!-- call template to display sub values -->
	  <xsl:if test="values">
		<xsl:for-each select="values">
          <xsl:call-template name="display_generic_dtc_env_table">
		    <xsl:with-param name="divlevel"><xsl:value-of select="$divlevel+1" /></xsl:with-param>
			<xsl:with-param name="measurement_name"><xsl:value-of select="./display_name" /></xsl:with-param>
		  </xsl:call-template>
		</xsl:for-each>
	  </xsl:if>
    </xsl:template>

	<!-- diplay the table for the dtc-snapshots -->
	<xsl:template name="display_generic_dtc_snapshots_table">
	  <xsl:param name="divlevel" />
	  <xsl:param name="measurement_name" />
	  <xsl:param name="measurement_rdid" />
	  <tr>
		<!-- DTC-Measurement-(Structure)-Name -->
		<td class="table_snapshot_value_spec" style='width:110mm'>
		  <xsl:choose>
		    <xsl:when test="$divlevel='0'"><b><xsl:value-of select="$measurement_name" /></b></xsl:when>
			<xsl:when test="$divlevel='1'">&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			<xsl:when test="$divlevel='2'">&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			<xsl:when test="$divlevel='3'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			<xsl:when test="$divlevel='4'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			<xsl:when test="$divlevel='5'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			<xsl:when test="$divlevel='6'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
			<xsl:when test="$divlevel='7'">&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$measurement_name" /></xsl:when>
		  </xsl:choose>
        </td>
		<!-- DTC-Measurement-RDID -->
		<td class="table_snapshot_value_spec" >
		  <xsl:value-of select="$measurement_rdid" />
		</td>
   		<xsl:if test="starts-with(./values/display_name, 'Snapshot')">
		  <xsl:for-each select="values">
		    <td class="table_snapshot_value_spec" >
			  <xsl:call-template name="display_table_measurement_value"></xsl:call-template>
			</td>
		  </xsl:for-each>  
		</xsl:if>
		<xsl:call-template name="fill_table_cells"></xsl:call-template>
	  </tr>
	  <!-- call template to display sub values -->
	  <xsl:if test="values">
		<xsl:for-each select="values">
		  <xsl:if test="not(starts-with(display_name, 'Snapshot'))">
			<xsl:call-template name="display_generic_dtc_snapshots_table">
			  <xsl:with-param name="divlevel"><xsl:value-of select="$divlevel+1" /></xsl:with-param>
			  <xsl:with-param name="measurement_name"><xsl:value-of select="./display_name" /></xsl:with-param>
			  <xsl:with-param name="measurement_rdid"></xsl:with-param>
			</xsl:call-template>
		  </xsl:if>
		</xsl:for-each>
	  </xsl:if>
    </xsl:template>

	<!-- fill table cells for measurement without values -->	
	<xsl:template name="fill_table_cells">
	  <xsl:if test="not(starts-with(./values/display_name, 'Snapshot'))">
	    <xsl:if test="count(./values[1]/values[display_name='Snapshot 1']) &gt; 0">
		  <xsl:for-each select="./values[1]/values">
		    <td class="table_snapshot_value_spec"></td>
		  </xsl:for-each>
		</xsl:if>
		<xsl:if test="count(./values[1]/values[1]/values[display_name='Snapshot 1']) &gt; 0">
		  <xsl:for-each select="./values[1]/values[1]/values">
			<td class="table_snapshot_value_spec"></td>
		  </xsl:for-each>
		</xsl:if>
		<xsl:if test="count(./values[1]/values[1]/values[1]/values[display_name='Snapshot 1']) &gt; 0">
		  <xsl:for-each select="./values[1]/values[1]/values[1]/values">
			<td class="table_snapshot_value_spec"></td>
		  </xsl:for-each>
		</xsl:if>
	  </xsl:if>
	</xsl:template>

	<!-- display the overview table -->
	<xsl:template name="display_overview_table">
	  <table class="table_overview_spec">
 	    <!-- title -->
		<tr>
          <td class="table_overview_title_row_spec" colspan="2">
			<xsl:if test="vehicle/communications/ecus/ecu/ecu_master[@type='event_memory_snapshot_export']">
				<xsl:value-of select="$Text_DtcSnapshotExport" />    
			</xsl:if>
			<xsl:if test="vehicle/communications/ecus/ecu/ecu_master[@type='dev_event_memory_snapshot_export']">
				<xsl:value-of select="$Text_DevDtcSnapshotExport" />
			</xsl:if>
		  </td>
		</tr>
		<!-- date -->
		<tr>
          <td class="table_overview_key_row_spec">
			<xsl:value-of select="$Text_CurDate" />
          </td>
		  <td class="table_overview_value_row_spec">
			<xsl:call-template name="display_date">
			  <xsl:with-param name="date"><xsl:value-of select="time_of_issue"/></xsl:with-param>
			</xsl:call-template>
          </td>
		</tr>
		<!-- time -->
		<tr>
          <td class="table_overview_key_row_spec">
			<xsl:value-of select="$Text_CurTime" />
          </td>
		  <td class="table_overview_value_row_spec">
		  	<xsl:call-template name="display_time">
			  <xsl:with-param name="date"><xsl:value-of select="time_of_issue"/></xsl:with-param>
			</xsl:call-template>
          </td>
		</tr>
		<!-- VIN -->
		<tr>
          <td class="table_overview_key_row_spec">
			<xsl:value-of select="$Text_Vehicle" />
          </td>
		  <td class="table_overview_value_row_spec">
			<xsl:for-each select="vehicle/vehicle_data[display_name='vin']">
				<xsl:value-of select="display_value" />
			</xsl:for-each>
          </td>
		</tr>
		<!-- ecu -->
		<tr>
          <td class="table_overview_key_row_spec">
			<xsl:value-of select="$Text_Ecu" />
          </td>
		  <td class="table_overview_value_row_spec">
			<xsl:for-each select="/protocol/vehicle/communications/ecus/ecu">
				<!-- display the current ecu entry -->
				<xsl:call-template name="display_ecu_entry" />
			</xsl:for-each>
          </td>
		</tr>
	  </table>
	</xsl:template>
	
	<!-- display the time -->
	<xsl:template name="display_time">
	  <xsl:param name="date" />
	  <xsl:if test="$date!=''">
        <xsl:value-of select="substring($date,12,8)"/>
      </xsl:if>  
    </xsl:template>
	
	<!-- display the date -->
	<xsl:template name="display_date">
	  <xsl:param name="date" />
	  <xsl:if test="$date!=''">
		<xsl:value-of select="substring($date,9,2)"/><xsl:text>.</xsl:text>
        <xsl:value-of select="substring($date,6,2)"/><xsl:text>.</xsl:text>
        <xsl:value-of select="substring($date,1,4)"/>
      </xsl:if>  
    </xsl:template>

	<!-- display the record data identifier for a measurement -->
	<xsl:template name="display_measurement_rdid">
	  <xsl:param name="measurement_display_name" />
	  <xsl:if test="contains($measurement_display_name, ' [') and contains($measurement_display_name, ']')">
		<xsl:value-of select="substring-before(substring-after($measurement_display_name, ' ['),']')"/>
      </xsl:if>  
	</xsl:template>

	<!-- display the measurement name without the rdid -->
	<xsl:template name="display_measurement_name">
	  <xsl:param name="measurement_display_name" />

  	  <xsl:if test="contains($measurement_display_name, ' [') and contains($measurement_display_name, ']')">
		<xsl:value-of select="substring-before($measurement_display_name, ' [')"/>
      </xsl:if>

	  <xsl:if test="not (contains($measurement_display_name, ' [') and contains($measurement_display_name, ']'))">
		<xsl:value-of select="$measurement_display_name"/>
      </xsl:if>
    </xsl:template>
	
	<xsl:template name="display_table_measurement_value">
	  <xsl:for-each select="display_value">
		<xsl:value-of select="." />
	  </xsl:for-each>

	  <xsl:text> </xsl:text>
	  <xsl:for-each select="display_unit">
		<xsl:value-of select="." />
	  </xsl:for-each>
	
	  <xsl:if test="position()=last()">
		<p class="p_small"></p>
	  </xsl:if>
	</xsl:template>
</xsl:stylesheet>