/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.diag.bean.ITargetCurve;
import de.vw.vaudes.diaghook.da.IDatabaseTargetCurve;
import de.vw.vaudes.diaghook.dto.HookTargetCurveWrapper;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TargetCurveTransformHelper {
    private static final Log LOG = LogFactory.getLog(TargetCurveTransformHelper.class);

    private TargetCurveTransformHelper() {
    }

    public static boolean transformTargetCurve(ITargetCurve iTargetCurve, VAUDESObjekt vAUDESObjekt) {
        boolean bl = false;
        if (null == vAUDESObjekt.getVoreingestellteMessung()) {
            LOG.error((Object)"Attempt to transform a non voreingestellte messung object to a voreingestellte messung object");
        } else {
            iTargetCurve.setFilename(DiagnosticDataAccessHelper.getFilenameFromObject(vAUDESObjekt, vAUDESObjekt.getVoreingestellteMessung().getVMDatei().getDateiRef()));
            iTargetCurve.setIsPublic(vAUDESObjekt.getVoreingestellteMessung().isMesstechnik());
            if (null != vAUDESObjekt.getAnzeigename()) {
                iTargetCurve.setName(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getAnzeigename().getStringRef()));
            } else {
                iTargetCurve.setName(null);
            }
            iTargetCurve.setTargetCurveGfsId(vAUDESObjekt.getSystemname());
            iTargetCurve.setTargetCurveKey(vAUDESObjekt.getId());
            iTargetCurve.setJarPath(null);
            bl = true;
        }
        return bl;
    }

    public static ITargetCurve createTargetCurveObjectFrom(VAUDESObjekt vAUDESObjekt) {
        HookTargetCurveWrapper hookTargetCurveWrapper = null;
        HookTargetCurveWrapper hookTargetCurveWrapper2 = new HookTargetCurveWrapper();
        if (TargetCurveTransformHelper.transformTargetCurve(hookTargetCurveWrapper2, vAUDESObjekt)) {
            hookTargetCurveWrapper = hookTargetCurveWrapper2;
        }
        return hookTargetCurveWrapper;
    }

    public static void adjustTargetCurve(ITargetCurve iTargetCurve, ITargetCurve iTargetCurve2) {
        iTargetCurve.setFilename(iTargetCurve2.getFilename());
        iTargetCurve.setIsPublic(iTargetCurve2.getIsPublic());
        iTargetCurve.setJarPath(iTargetCurve2.getJarPath());
        iTargetCurve.setName(iTargetCurve2.getName());
        iTargetCurve.setTargetCurveGfsId(iTargetCurve2.getTargetCurveGfsId());
        iTargetCurve.setTargetCurveKey(iTargetCurve2.getTargetCurveKey());
    }

    public static List<ITargetCurve> transformTargetCurves(List<IDatabaseTargetCurve> list) {
        ArrayList<ITargetCurve> arrayList = new ArrayList<ITargetCurve>();
        for (IDatabaseTargetCurve iDatabaseTargetCurve : list) {
            arrayList.add(TargetCurveTransformHelper.transformTargetCurve(iDatabaseTargetCurve));
        }
        return arrayList;
    }

    private static ITargetCurve transformTargetCurve(IDatabaseTargetCurve iDatabaseTargetCurve) {
        HookTargetCurveWrapper hookTargetCurveWrapper = new HookTargetCurveWrapper();
        hookTargetCurveWrapper.setFilename(iDatabaseTargetCurve.getFilename());
        hookTargetCurveWrapper.setIsPublic(iDatabaseTargetCurve.getIsReleased());
        hookTargetCurveWrapper.setJarPath(null);
        hookTargetCurveWrapper.setName(DbgHookTransformHelper.createTextIdFrom(iDatabaseTargetCurve.getTargetCurveKey(), "Default_TargetCurve_Name_TextId"));
        hookTargetCurveWrapper.setTargetCurveGfsId(iDatabaseTargetCurve.getTargetCurveGfsId());
        hookTargetCurveWrapper.setTargetCurveKey(iDatabaseTargetCurve.getTargetCurveKey());
        return hookTargetCurveWrapper;
    }
}

