/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IVehicleStateAttribute;
import de.volkswagen.odis.vaudas.domainmodel.gfs.factory.IVehicleStateAttributeFactory;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.dto.HookTextIdWrapper;
import de.vw.vaudes.diaghook.dto.HookVehicleStateAttributeWrapper;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.xml.object.FahrzeugzustandTabelle;
import de.vw.vaudes.xml.object.TextquelleDOM;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class VehicleStateAttributeFactoryImpl
implements IVehicleStateAttributeFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public List<IVehicleStateAttribute> getAllVehicleStateAttributes(List<IVehicleStateAttribute> list) throws OdisBaseException {
        Object object;
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getAllVehicleStateAttributes(" + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IVehicleStateAttribute>();
        }
        if (DatabaseResolver.getInstance().isDatabaseAvailable()) {
            try {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)"query database resolver");
                }
                if (null != (object = DatabaseResolver.getInstance().getFromDB("Fahrzeugzustandstexte", false))) {
                    this.mergeVehicleStates(list, this.getVehicleStates((VAUDESObjekt)object));
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)"received vehicle states from database");
                    }
                }
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
            }
            catch (Exception exception) {
                this.fLogger.error((Object)"error during transformation", (Throwable)exception);
            }
        }
        if (null == (object = ObjectIndicator.getInstance().getObjectByIdOrSysName("Fahrzeugzustandstexte"))) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return " + list));
            }
            return list;
        }
        try {
            Object object2 = DiagnosticDataAccessHelper.parseFile((IndicatedElement)object, VAUDESObjekt.class);
            if (!(object2 instanceof VAUDESObjekt)) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + list));
                }
                return list;
            }
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)"found requested object in index");
            }
            VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object2;
            this.mergeVehicleStates(list, this.getVehicleStates(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return merged " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)"error during getAllVehicleStateAttributes", (Throwable)exception);
            return list;
        }
    }

    private List<IVehicleStateAttribute> getVehicleStates(VAUDESObjekt vAUDESObjekt) {
        ArrayList<IVehicleStateAttribute> arrayList = new ArrayList<IVehicleStateAttribute>();
        if (null == vAUDESObjekt.getFahrzeugzustandTabelle()) {
            this.fLogger.warn((Object)"Attempt to transform a non vehicle state object to a vehicle state object ... aborting");
        }
        for (FahrzeugzustandTabelle.FzgZustandGruppe fzgZustandGruppe : vAUDESObjekt.getFahrzeugzustandTabelle().getFzgZustandGruppe()) {
            for (FahrzeugzustandTabelle.FzgZustandGruppe.FzgZustand fzgZustand : fzgZustandGruppe.getFzgZustand()) {
                HookVehicleStateAttributeWrapper hookVehicleStateAttributeWrapper = new HookVehicleStateAttributeWrapper();
                hookVehicleStateAttributeWrapper.setAttributeId(Integer.valueOf(fzgZustandGruppe.getOsFzgzsdGrpID()));
                HookTextIdWrapper hookTextIdWrapper = new HookTextIdWrapper();
                hookTextIdWrapper.setId(fzgZustand.getFzgzsdStrID());
                hookTextIdWrapper.setSource(TextquelleDOM.FAHRZEUGZUSTANDSTEXTE.value());
                hookVehicleStateAttributeWrapper.setMessage(hookTextIdWrapper);
                hookVehicleStateAttributeWrapper.setAttributeValue(fzgZustand.getOsFzgzsdID());
                arrayList.add(hookVehicleStateAttributeWrapper);
            }
        }
        return arrayList;
    }

    private void mergeVehicleStates(List<IVehicleStateAttribute> list, List<IVehicleStateAttribute> list2) {
        if (list.isEmpty()) {
            list.addAll(list2);
            return;
        }
        ArrayList<IVehicleStateAttribute> arrayList = new ArrayList<IVehicleStateAttribute>();
        block0: for (IVehicleStateAttribute iVehicleStateAttribute : list) {
            for (IVehicleStateAttribute iVehicleStateAttribute2 : list2) {
                if (iVehicleStateAttribute.getAttributeId() != iVehicleStateAttribute2.getAttributeId() || !iVehicleStateAttribute.getAttributeValue().equals(iVehicleStateAttribute2.getAttributeValue())) continue;
                this.adjustVehicleStates(iVehicleStateAttribute, iVehicleStateAttribute2);
                arrayList.add(iVehicleStateAttribute2);
                continue block0;
            }
        }
        list2.removeAll(arrayList);
        list.addAll(list2);
    }

    private void adjustVehicleStates(IVehicleStateAttribute iVehicleStateAttribute, IVehicleStateAttribute iVehicleStateAttribute2) {
        iVehicleStateAttribute.setAttributeId(iVehicleStateAttribute2.getAttributeId());
        iVehicleStateAttribute.setAttributeValue(iVehicleStateAttribute2.getAttributeValue());
        iVehicleStateAttribute.setMessage(iVehicleStateAttribute2.getMessage());
    }
}

