/*!
 * \file    hvmt-id.h
 *
 * \brief   Konstanten fuer die IDs von Modulen, Interfaces und Operationen.
 *
 * \version 1.9.1.0
 * \date    07.12.2018
 * \author  rd electronic GmbH (rde)
 *
 * \hist    \li 1.9.2.0		07.12.2018  rde     neue Operation "setCalibrationMode"
 * 		    \li 1.9.1.0		27.07.2017  rde     neue Operation "setCheckContact"
 * 			\li 1.9.0.0		02.05.2016	rde		Neue Operation "setConvergenceMode"
 *			\li 1.3.0.0		22.11.2011	rde		Ergaenzung isConnected, Korrektur von Rechtschreibfehlern (conntect -> connect)
 *												Operationsnamne und Namen der Operations-IDs korrigiert (analog ODIS-HVMT-API)
 *			\li	1.0.0.0		11.11.2011	rde		Erstellung
 */


// ---------- CONSTANTS ----------
//                ==>1234567890123456789012345678901<== max. length 31 characters!!

// Module xm (externe Messtechnik)
const unsigned short AId_HVMT                             				= 2000;	///< ID des Moduls \ref HVMT.

// interface Device
const unsigned short AId_fnDevice										= 2100;	///< ID des Interfaces \ref HVMT.Device.

// operations of voltage measurement
const unsigned short Id_fnDev_prepareVoltageMeasurement 				= 2101;	///< ID der Operation \ref HVMT.Device.prepareVoltageMeasurement.
const unsigned short Id_fnDev_setInternalResistance 					= 2102;	///< ID der Operation \ref HVMT.Device.setInternalResistance.
const unsigned short Id_fnDev_getVoltageMeasurementResult 				= 2103;	///< ID der Operation \ref HVMT.Device.getVoltageMeasurementResult.
const unsigned short Id_fnDev_setConvergenceMode 						= 2104;	///< ID der Operation \ref HVMT.Device.setConvergenceMode.
const unsigned short Id_fnDev_setCheckContact 							= 2105;	///< ID der Operation \ref HVMT.Device.setCheckContact.
const unsigned short Id_fnDev_setCalibrationMode						= 2106;	///< ID der Operation \ref HVMT.Device.setCalibrationMode.

// operations of resistance measurement
const unsigned short Id_fnDev_prepareResistanceMeasurement 				= 2111;	///< ID der Operation \ref HVMT.Device.prepareResistanceMeasurement.
const unsigned short Id_fnDev_runCalibration 							= 2112;	///< ID der Operation \ref HVMT.Device.runCalibration.
const unsigned short Id_fnDev_getResistanceMeasurementResult 			= 2113;	///< ID der Operation \ref HVMT.Device.getResistanceMeasurementResult.

// operations of diode measurement
const unsigned short Id_fnDev_prepareDiodeMeasurement 					= 2121;	///< ID der Operation \ref HVMT.Device.prepareDiodeMeasurement.
const unsigned short Id_fnDev_getDiodeMeasurementResult 				= 2122;	///< ID der Operation \ref HVMT.Device.getDiodeMeasurementResult.

// operations of isolation measurement
const unsigned short Id_fnDev_prepareHVIsolationMeasurement 			= 2131;	///< ID der Operation \ref HVMT.Device.prepareHVIsolationMeasurement.
const unsigned short Id_fnDev_setTestVoltage 							= 2132;	///< ID der Operation \ref HVMT.Device.setTestVoltage.
const unsigned short Id_fnDev_getHVIsolationMeasurementResult 			= 2133;	///< ID der Operation \ref HVMT.Device.getHVIsolationMeasurementResult.

// operations of SAE J1766 isolation measurement
const unsigned short Id_fnDev_prepareHVIsolationSAEJ1766Measurement 	= 2141;	///< ID der Operation \ref HVMT.Device.prepareHVIsolationSAEJ1766Measurement.
const unsigned short Id_fnDev_getHVIsolationSAEJ1766MeasurementResult 	= 2142;	///< ID der Operation \ref HVMT.Device.getHVIsolationSAEJ1766MeasurementResult.

// operations of potential equalization measurement
const unsigned short Id_fnDev_preparePotentialEqualizationMeasurement 	= 2151;	///< ID der Operation \ref HVMT.Device.preparePotentialEqualizationMeasurement.
const unsigned short Id_fnDev_setMeasurementCurrent 					= 2152;	///< ID der Operation \ref HVMT.Device.setMeasurementCurrent.
const unsigned short Id_fnDev_getPotentialEqualizationMeasurementResult	= 2153;	///< ID der Operation \ref HVMT.Device.getPotentialEqualizationMeasurementResult.

// operations of selftest
const unsigned short Id_fnDev_prepareSelftest 							= 2161;	///< ID der Operation \ref HVMT.Device.prepareSelftest.
const unsigned short Id_fnDev_runSelftest 								= 2162;	///< ID der Operation \ref HVMT.Device.runSelftest.

// operations of device safety check
const unsigned short Id_fnDev_prepareDeviceSafetyCheck					= 2171;	///< ID der Operation \ref HVMT.Device.prepareDeviceSafetyCheck.
const unsigned short Id_fnDev_runDeviceSafetyCheck 						= 2172;	///< ID der Operation \ref HVMT.Device.runDeviceSafetyCheck.

// operations of trigger button
const unsigned short Id_fnDev_waitForButtonPress 						= 2181;	///< ID der Operation \ref HVMT.Device.waitForButtonPress.
const unsigned short Id_fnDev_waitForButtonRelease 						= 2182;	///< ID der Operation \ref HVMT.Device.waitForButtonRelease.

// operations of generell measurement
const unsigned short Id_fnDev_startMeasurement 							= 2191;	///< ID der Operation \ref HVMT.Device.startMeasurement.
const unsigned short Id_fnDev_stopMeasurement 							= 2192;	///< ID der Operation \ref HVMT.Device.stopMeasurement.
const unsigned short Id_fnDev_finishCurrentMode 						= 2193;	///< ID der Operation \ref HVMT.Device.finishCurrentMode.
const unsigned short Id_fnDev_abortMeasurement 							= 2194;	///< ID der Operation \ref HVMT.Device.abortMeasurement.

// operations of generell version information and identification
const unsigned short Id_fnDev_getFMVersionAvailable 					= 2202;	///< ID der Operation \ref HVMT.Device.getFMVersionAvailable.
const unsigned short Id_fnDev_getDeviceIdentification 					= 2205;	///< ID der Operation \ref HVMT.Device.getDeviceIdentification.

// operations of connection-handling
const unsigned short Id_fnDev_connect 									= 2301;	///< ID der Operation \ref HVMT.Device.connect.
const unsigned short Id_fnDev_disconnect 								= 2302;	///< ID der Operation \ref HVMT.Device.disconnect.
const unsigned short Id_fnDev_isConnected 								= 2303;	///< ID der Operation \ref HVMT.Device.isConnected.
