/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.launcher;

public class JNIBridge {
    private static final boolean VERBOSE = false;
    private String library;
    private boolean libraryLoaded = false;

    private native void _set_exit_data(String var1, String var2);

    private native void _set_launcher_info(String var1, String var2);

    private native void _update_splash();

    private native long _get_splash_handle();

    private native void _show_splash(String var1);

    private native void _takedown_splash();

    private native int OleInitialize(int var1);

    private native void OleUninitialize();

    private void print(Throwable throwable) {
        System.out.println("---- exception in JNIBridge: " + throwable);
        throwable.printStackTrace();
    }

    public JNIBridge(String string) {
        this.library = string;
    }

    private void loadLibrary() {
        if (this.library != null) {
            try {
                int n;
                if (this.library.indexOf("wpf") != -1 && (n = this.library.indexOf("eclipse_")) != -1) {
                    String string = this.library.substring(0, n) + "com_";
                    string = string + this.library.substring(n + 8, this.library.length());
                    Runtime.getRuntime().load(string);
                    this.OleInitialize(0);
                }
                Runtime.getRuntime().load(this.library);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.print(unsatisfiedLinkError);
            }
        }
        this.libraryLoaded = true;
    }

    public boolean setExitData(String string, String string2) {
        try {
            this._set_exit_data(string, string2);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.print(unsatisfiedLinkError);
            if (!this.libraryLoaded) {
                this.loadLibrary();
                return this.setExitData(string, string2);
            }
            return false;
        }
    }

    public boolean setLauncherInfo(String string, String string2) {
        try {
            this._set_launcher_info(string, string2);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.print(unsatisfiedLinkError);
            if (!this.libraryLoaded) {
                this.loadLibrary();
                return this.setLauncherInfo(string, string2);
            }
            return false;
        }
    }

    public boolean showSplash(String string) {
        try {
            this._show_splash(string);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.print(unsatisfiedLinkError);
            if (!this.libraryLoaded) {
                this.loadLibrary();
                return this.showSplash(string);
            }
            return false;
        }
    }

    public boolean updateSplash() {
        try {
            this._update_splash();
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.print(unsatisfiedLinkError);
            if (!this.libraryLoaded) {
                this.loadLibrary();
                return this.updateSplash();
            }
            return false;
        }
    }

    public long getSplashHandle() {
        try {
            return this._get_splash_handle();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.print(unsatisfiedLinkError);
            if (!this.libraryLoaded) {
                this.loadLibrary();
                return this.getSplashHandle();
            }
            return -1L;
        }
    }

    boolean isLibraryLoadedByJava() {
        return this.libraryLoaded;
    }

    public boolean takeDownSplash() {
        try {
            this._takedown_splash();
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.print(unsatisfiedLinkError);
            if (!this.libraryLoaded) {
                this.loadLibrary();
                return this.takeDownSplash();
            }
            return false;
        }
    }

    public boolean uninitialize() {
        if (this.libraryLoaded && this.library != null && this.library.indexOf("wpf") != -1) {
            try {
                this.OleUninitialize();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.print(unsatisfiedLinkError);
                return false;
            }
        }
        return true;
    }

    public String getOSRecommendedFolder() {
        return null;
    }
}

