<!-- ************************************************************************ -->
<!-- * This file converts the XML snippets in a proprietary format to HTML. * -->
<!-- * @author EMEY                                                         * -->
<!-- * Changes: MEH                                                         * -->
<!-- * Version: $Id: ca6362f26e0f19edf6d80eb1e6ac5ff34d8d1f44 $                                                 * -->
<!-- ************************************************************************ -->
<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:odis="de.volkswagen.odis.vaudas.core.xml"
	extension-element-prefixes="odis" exclude-result-prefixes="xalan"
	version="1.1">
  <xsl:output method="html"/>
  <xsl:param name="FallbackAppendId">0</xsl:param>

  <xalan:component prefix="odis" functions="xslResolve xslTranslate">
    <xalan:script lang="javaclass" src="xalan://de.volkswagen.odis.vaudas.core.xml.ConvertToHtml"/>
  </xalan:component>

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template String ******************************************************************-->
  <!-- **********************************************************************************-->
	<xsl:template match="String">
		<xsl:choose>
			<xsl:when test="@fallback_language">
				<span style="background-color:yellow;">
					<xsl:text>[</xsl:text>
					<xsl:value-of select="@fallback_language" />
					<xsl:text>]</xsl:text>
					<xsl:apply-templates />
					<br />
					<xsl:text>&#xA;</xsl:text>
				</span>
				<xsl:if test="$FallbackAppendId = '1'">
					<xsl:text> (</xsl:text>
					<xsl:value-of select="@textsource" />
					<xsl:text>).(</xsl:text>
					<xsl:value-of select="@textid" />
					<xsl:text>)</xsl:text>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates />
				<br />
				<xsl:text>&#xA;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
  <!-- **********************************************************************************-->
  <!-- template Format  *****************************************************************-->
  <!-- **********************************************************************************-->
  <xsl:template match="Format">
    <font>
      <xsl:attribute name="face"><xsl:value-of select="@fontname"/></xsl:attribute>
      <xsl:attribute name="style">
      	<xsl:if test="@bold='true'">font-weight:bold;</xsl:if>
      	<xsl:if test="@bold='false'">font-weight:normal;</xsl:if>
      	<xsl:if test="@color">color:<xsl:value-of select="@color"/>;</xsl:if>
      	<xsl:if test="@italic='true'">font-style:italic;</xsl:if>
      	<xsl:if test="@italic='false'">font-style:normal;</xsl:if>
      	<xsl:if test="@fontsize">font-size:<xsl:value-of select="@fontsize"/>;</xsl:if>
      	<xsl:if test="@underline='true'">text-decoration:underline;</xsl:if>
      	<xsl:if test="@underline='false'">text-decoration:none;</xsl:if>
      </xsl:attribute>
      <xsl:apply-templates/>
    </font>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template SpecialChar  ************************************************************-->
  <!-- **********************************************************************************-->
  <xsl:template match="SpecialChar">
    <xsl:choose>
      <xsl:when test="@name = 'alpha_kl'">
        <xsl:text disable-output-escaping="yes">&amp;alpha;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'beta_kl'">
        <xsl:text disable-output-escaping="yes">&amp;beta;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'gamma_kl'">
        <xsl:text disable-output-escaping="yes">&amp;gamma;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'delta_kl'">
        <xsl:text disable-output-escaping="yes">&amp;delta;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'delta_gr'">
        <xsl:text disable-output-escaping="yes">&amp;Delta;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'lambda_kl'">
        <xsl:text disable-output-escaping="yes">&amp;lambda;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'my_kl'">
        <xsl:text disable-output-escaping="yes">&amp;mu;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'pi_kl'">
        <xsl:text disable-output-escaping="yes">&amp;pi;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'omega_kl'">
        <xsl:text disable-output-escaping="yes">&amp;omega;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'omega_gr'">
        <xsl:text disable-output-escaping="yes">&amp;Omega;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'phi_gr'">
        <xsl:text disable-output-escaping="yes">&amp;Phi;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'sigma_gr'">
        <xsl:text disable-output-escaping="yes">&amp;Sigma;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'durchschnitt'">
        <xsl:text disable-output-escaping="yes">&amp;Oslash;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'ungefaehr_gleich'">
        <xsl:text disable-output-escaping="yes">&amp;asymp;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'ungleich'">
        <xsl:text disable-output-escaping="yes">&amp;ne;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'kleiner_gleich'">
        <xsl:text disable-output-escaping="yes">&amp;le;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'groesser_gleich'">
        <xsl:text disable-output-escaping="yes">&amp;ge;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'plusminus'">
        <xsl:text disable-output-escaping="yes">&amp;plusmn;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'unendlich'">
        <xsl:text disable-output-escaping="yes">&amp;infin;</xsl:text>
      </xsl:when>
      <xsl:when test="@name = 'OHM_BIG'">
        <xsl:text disable-output-escaping="yes">&amp;Omega;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="@name"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- **********************************************************************************-->
  <!-- template Icon  *******************************************************************-->
  <!-- **********************************************************************************-->
  <xsl:template match="Icon">
    <xsl:variable name="myicon">
      <xsl:value-of select="@name"/>
    </xsl:variable>
    <img>
      <xsl:attribute name="src">
		<xsl:value-of select="odis:ConvertToHtml.xslResolve($myicon,'.png')" />
      </xsl:attribute>
    </img>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template text()  *****************************************************************-->
  <!-- **********************************************************************************-->
  <xsl:template match="text()">
    <xsl:call-template name="break"/>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template BR  *********************************************************************-->
  <!-- **********************************************************************************-->
  <xsl:template match="BR">
    <br/>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template Tab  ********************************************************************-->
  <!-- **********************************************************************************-->
  <xsl:template match="Tab">
    <xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;</xsl:text>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template break  ******************************************************************-->
  <!-- **********************************************************************************-->
  <xsl:template name="break">
    <xsl:param name="text" select="."/>
    <xsl:choose>
      <xsl:when test="contains($text, '\n')">
        <xsl:value-of select="substring-before($text, '\n')"/>
        <br/>
        <xsl:call-template name="break">
          <xsl:with-param name="text" select="substring-after($text, '\n')"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template NBSP  *******************************************************************-->
  <!-- This tag is for ODIS Service internal use only.                                   -->
  <!-- This tag is not part of the VAUDESString XML schema definition.                   -->
  <!-- The tag replaces white spaces in variable (tag "Var") values if and only if the   -->
  <!-- variable is formatted by Courier font.                                            -->
  <!-- **********************************************************************************-->
  <xsl:template match="NBSP">
    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
  </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template table  ******************************************************************-->
  <!--                                                                                   -->
  <!-- **********************************************************************************-->
    <xsl:template match="table">
        <xsl:if test="@name">
            <a name="{@name}"/>
        </xsl:if>
        <xsl:copy>
            <xsl:copy-of select="@*[local-name() != 'name']"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
  <!-- **********************************************************************************-->
  <!-- template StandardNote  ***********************************************************-->
  <!-- **********************************************************************************-->
	<xsl:template match="StandardNote">
		<xsl:variable name="notificationType">
			<!-- translation of schema constants into internally used constants -->
			<xsl:choose>
				<xsl:when test="@name = 'ANSI_Z535_6_ZUSATZINFO'">
					<xsl:value-of select="'INFO'"/>
				</xsl:when>
				<xsl:when test="@name = 'ANSI_Z535_6_HINWEIS'">
					<xsl:value-of select="'HINT'"/>
				</xsl:when>
				<xsl:when test="@name = 'ANSI_Z535_6_VORSICHT'">
					<xsl:value-of select="'CAUTION'"/>
				</xsl:when>
				<xsl:when test="@name = 'ANSI_Z535_6_WARNUNG'">
					<xsl:value-of select="'WARNING'"/>
				</xsl:when>
				<xsl:when test="@name = 'ANSI_Z535_6_GEFAHR'">
					<xsl:value-of select="'DANGER'"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<xsl:when test="$notificationType='INFO'">
				<xsl:call-template name="info"/>
			</xsl:when>
			<xsl:when test="$notificationType='HINT'">
				<xsl:call-template name="hint"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="notification">
					<xsl:with-param name="type"><xsl:value-of select="$notificationType"/></xsl:with-param>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
  <!-- **********************************************************************************-->
  <!-- template notification                                                             -->
  <!-- Builds a HTML table for a notification text.                                      -->
  <!-- Table style depends on the type of the notification.                              -->
  <!-- The table contains 2 rows and 1 column.                                           -->
  <!-- **********************************************************************************-->
	<xsl:template name="notification">
		<xsl:param name="type"/>
		<xsl:variable name="hash"><xsl:text disable-output-escaping="yes">#</xsl:text></xsl:variable>
		<xsl:variable name="headerBackgroundColor">
			<xsl:choose>
				<xsl:when test="$type = 'CAUTION'">
					<xsl:value-of select="concat($hash,'FFF200')"/>
				</xsl:when>
				<xsl:when test="$type = 'WARNING'">
					<xsl:value-of select="concat($hash,'F58220')"/>
				</xsl:when>
				<xsl:when test="$type = 'DANGER'">
					<xsl:value-of select="concat($hash,'ED1C24')"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="textId">
			<xsl:choose>
				<xsl:when test="$type = 'CAUTION'">
					<xsl:value-of select="'Caution'"/>
				</xsl:when>
				<xsl:when test="$type = 'WARNING'">
					<xsl:value-of select="'Warning'"/>
				</xsl:when>
				<xsl:when test="$type = 'DANGER'">
					<xsl:value-of select="'Danger'"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="headerForegroundColor">
			<xsl:choose>
				<xsl:when test="$type = 'CAUTION'">
					<xsl:value-of select="'black'"/>
				</xsl:when>
				<xsl:when test="$type = 'WARNING'">
					<xsl:value-of select="'black'"/>
				</xsl:when>
				<xsl:when test="$type = 'DANGER'">
					<xsl:value-of select="'white'"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="headerIcon">
			<xsl:choose>
				<xsl:when test="$type = 'CAUTION'">
					<xsl:value-of select="'VAUDES_VORSICHT_2'"/>
				</xsl:when>
				<xsl:when test="$type = 'WARNING'">
					<xsl:value-of select="'VAUDES_WARNUNG'"/>
				</xsl:when>
				<xsl:when test="$type = 'DANGER'">
					<xsl:value-of select="'VAUDES_GEFAHR'"/>
				</xsl:when>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="borderWidth">
			<xsl:value-of select="5"/>
		</xsl:variable>
		<xsl:variable name="fontStyle">
			<xsl:value-of select="'normal'"/>
		</xsl:variable>
		<table>
			<xsl:attribute name="style">
				<xsl:value-of select="concat('border-style:solid; border-collapse: collapse; border-width:', $borderWidth,'px; border-color:black; margin:5px 5px; width:auto;')"/>
			</xsl:attribute>
			<tbody>
				<tr>
					<td>
						<xsl:attribute name="bgcolor">
							<xsl:value-of select="$headerBackgroundColor"/>
						</xsl:attribute>
						<font>
							<xsl:attribute name="style">
								<xsl:value-of select="concat('font-family:Arial Unicode;font-size:16px;font-style:',$fontStyle,';color:',$headerForegroundColor,';font-weight:bold')"/>
							</xsl:attribute>
							<span>
								<img>
									<xsl:attribute name="src">
										<xsl:value-of select="odis:ConvertToHtml.xslResolve($headerIcon,'.png')" />
									</xsl:attribute>
									<xsl:attribute name="alt">
										<xsl:value-of select="odis:ConvertToHtml.xslTranslate('StartUpWarningDialog.', $textId,'.Title')"/>
									</xsl:attribute>
									<!-- Scale image relative to font size -->
									<xsl:attribute name="style">
										height:1em;
									</xsl:attribute>
								</img>
								<xsl:value-of select="odis:ConvertToHtml.xslTranslate('StartUpWarningDialog.', $textId,'.Title')"/>
							</span>
						</font>
					</td>
				</tr>
				<tr>
					<td>
						<span>
							<font>
								<xsl:attribute name="style">
    								<xsl:call-template name="ansiFont"/>
								</xsl:attribute>
								<xsl:apply-templates/>
							</font>
						</span>
					</td>
				</tr>
			</tbody>
		</table>
	</xsl:template>
  <!-- **********************************************************************************-->
  <!-- template hint                                                                     -->
  <!-- Builds a HTML table for a notification text.                                      -->
  <!-- Table style depends on the type of the notification.                              -->
  <!-- The table contains 2 rows and 1 column.                                           -->
  <!-- **********************************************************************************-->
	<xsl:template name="hint">
		<xsl:param name="type"/>
		<xsl:variable name="hash"><xsl:text disable-output-escaping="yes">#</xsl:text></xsl:variable>
		<xsl:variable name="headerBackgroundColor">
			<xsl:value-of select="concat($hash,'90AED6')"/>
		</xsl:variable>
		<xsl:variable name="textId">
			<xsl:value-of select="'Remark'"/>
		</xsl:variable>
		<xsl:variable name="headerForegroundColor">
			<xsl:value-of select="'white'"/>
		</xsl:variable>
		<xsl:variable name="headerIcon">
			<xsl:value-of select="'VAUDES_HINWEIS_2'"/>
		</xsl:variable>
		<xsl:variable name="borderWidth">
			<xsl:value-of select="5"/>
		</xsl:variable>
		<xsl:variable name="fontStyle">
			<xsl:value-of select="'italic'"/>
		</xsl:variable>
		<table>
			<xsl:attribute name="style">
				<xsl:value-of select="concat('border-style:solid; border-collapse: collapse; border-width:', $borderWidth,'px; border-color:black; margin:5px 5px; width:auto;')"/>
			</xsl:attribute>
			<tbody>
				<tr>
					<td>
						<font>
							<xsl:attribute name="style">
								<xsl:value-of select="concat('font-family:Arial Unicode;font-size:16px;font-style:',$fontStyle,';color:',$headerForegroundColor,';background-color:',$headerBackgroundColor,';font-weight:bold')"/>
							</xsl:attribute>
							<img>
								<xsl:attribute name="src">
									<xsl:value-of select="odis:ConvertToHtml.xslResolve($headerIcon,'.png')" />
								</xsl:attribute>
								<xsl:attribute name="alt">
									<xsl:value-of select="odis:ConvertToHtml.xslTranslate('StartUpWarningDialog.', $textId,'.Title')"/>
								</xsl:attribute>
								<!-- Scale image relative to font size -->
								<xsl:attribute name="style">
									height:1em;
								</xsl:attribute>
							</img>
							<xsl:value-of select="odis:ConvertToHtml.xslTranslate('StartUpWarningDialog.', $textId,'.Title')"/>
							<xsl:text/>&#160;<xsl:text/>
						</font>
					</td>
				</tr>
				<tr>
					<td>
						<font>
							<xsl:attribute name="style">
    							<xsl:call-template name="ansiFont"/>
							</xsl:attribute>
							<xsl:apply-templates />
						</font>
					</td>
				</tr>
			</tbody>
		</table>
	</xsl:template>
  <!-- **********************************************************************************-->
  <!-- template info                                                                     -->
  <!-- Builds a HTML table for an information text.                                      -->
  <!-- The table contains 1 row and 2 column.                                            -->
  <!-- **********************************************************************************-->
  <xsl:template name="info">
	<table>
		<tbody>
			<tr>
				<td>
					<font>
						<xsl:attribute name="style">
    						<xsl:call-template name="ansiFont"/>
						</xsl:attribute>
						<img>
							<xsl:attribute name="src">
								<xsl:value-of select="odis:ConvertToHtml.xslResolve('VAUDES_INFORMATION','.png')" />
							</xsl:attribute>
							<!-- Scale image relative to font size -->
							<xsl:attribute name="style">
								height:2em;
							</xsl:attribute>
						</img>
					</font>
				</td>
				<td>
					<font>
						<xsl:attribute name="style">
    						<xsl:call-template name="ansiFont"/>
						</xsl:attribute>
						<xsl:apply-templates />
					</font>
				</td>
			</tr>
		</tbody>
	</table>
  </xsl:template>

  <!-- **********************************************************************************-->
  <!-- template ansi font                                                                -->
  <!-- template to create the font for ansi symbols                                      -->
  <!-- **********************************************************************************-->
  <xsl:template name="ansiFont">
    <xsl:variable name="ansifontsize">
    	  <xsl:text>font-size:16px;</xsl:text>
    </xsl:variable>
	<xsl:value-of select="concat('font-family:Arial Unicode; color:black; font-weight:bold;', $ansifontsize)" />
  </xsl:template>

  <!-- **********************************************************************************-->
  <!-- template *  *****************************************************************-->
  <!-- **********************************************************************************-->
    <xsl:template match="*">
        <xsl:copy>
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates/>
        </xsl:copy>
    </xsl:template>
 </xsl:stylesheet>
