// Propagate information that the page was scrolled completely to the bottom.
// - needed for activating the OK button when the disclaimer is opened during start of program.
window.onscroll = function(ev)
{
	var height = 'innerHeight' in window
		? window.innerHeight
		: document.documentElement.offsetHeight;
	if ((height +  document.documentElement.scrollTop) >= document.body.offsetHeight) 
	{
		document.title = 'disclaimer finished scrolling';
	}
};

// Propagate information that the page content is fully loaded
// - needed to determine the timepoint when the table of content should be made visible
window.onload = function(ev)
{
	document.title = 'disclaimer document fully loaded';
}

// Needed to make the table of content visible
function showTableOfContents() 
{
	var toc = document.getElementById('disclaimerTableOfContent');
	toc.style.display = "block";
	toc.style.visibility = "visible";
	var allJumps = document.getElementsByTagName('a');
	// The following command is not available for all embedded IE versions
	//var allJumps = document.getElementsByClassName('jumpToTableOfContent');
	for (var i = 0; i < allJumps.length; i++) 
	{
		allJumps[i].style.display = "inline-block";
		allJumps[i].style.visibility = "visible";
	};
};
