/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.transform;

import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IRequiredVersion;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IStartEndModule;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.ITestProgram;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.ITestProgramReference;
import de.vw.vaudes.diaghook.dto.HookRequiredVersionWrapper;
import de.vw.vaudes.diaghook.dto.HookStartEndModuleWrapper;
import de.vw.vaudes.diaghook.dto.HookTestProgramReferenceWrapper;
import de.vw.vaudes.diaghook.dto.HookTestProgramWrapper;
import de.vw.vaudes.diaghook.dto.HookTextIdWrapper;
import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.IndicatedTestProgramElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.fkc.FkcMetaData;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.StartEndModuleComparator;
import de.vw.vaudes.xml.object.Diagnoseobjekt;
import de.vw.vaudes.xml.object.Funktionscode;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import de.vw.vaudes.xml.object.VariantenObjektverweisTYPE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TestProgramTransformHelper {
    private static final Log LOG = LogFactory.getLog(TestProgramTransformHelper.class);

    private TestProgramTransformHelper() {
    }

    public static boolean transformTestProgram(ITestProgram iTestProgram, VAUDESObjekt vAUDESObjekt) {
        boolean bl = false;
        if (null == vAUDESObjekt.getFunktionscode()) {
            LOG.warn((Object)"Attempt to transform a non functioncode object to functioncode object ... Aborting");
        } else {
            iTestProgram.setClassName(StringUtils.replaceChars((String)vAUDESObjekt.getSystemname(), (char)'@', (char)'_'));
            iTestProgram.setDescription(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getFunktionscode().getBeschreibungTester().getStringRef()));
            iTestProgram.setTestProgramGfsId(vAUDESObjekt.getSystemname());
            iTestProgram.setTestProgramKey(vAUDESObjekt.getId());
            iTestProgram.setTitle(DbgHookTransformHelper.createTextIdFrom(vAUDESObjekt.getId(), vAUDESObjekt.getFunktionscode().getTitel().getStringRef()));
            iTestProgram.getRequiredVersions().clear();
            iTestProgram.getRequiredVersions().addAll(TestProgramTransformHelper.getRequiredVersionsFrom(vAUDESObjekt));
            iTestProgram.setJarPath(null);
            bl = true;
        }
        return bl;
    }

    public static void adjustRequiredVersionObjects(IRequiredVersion iRequiredVersion, IRequiredVersion iRequiredVersion2) {
        iRequiredVersion.setComponent(iRequiredVersion2.getComponent());
        iRequiredVersion.setRequiredVersion(iRequiredVersion2.getRequiredVersion());
        iRequiredVersion.setTestProgramKey(iRequiredVersion2.getTestProgramKey());
    }

    public static List<IRequiredVersion> getRequiredVersionsFrom(VAUDESObjekt vAUDESObjekt) {
        ArrayList<IRequiredVersion> arrayList = new ArrayList<IRequiredVersion>();
        if (null == vAUDESObjekt.getFunktionscode()) {
            LOG.warn((Object)"Attempt to transform a non functioncode object to functioncode object ... Aborting");
            return arrayList;
        }
        if (null == vAUDESObjekt.getFunktionscode().getModulverwendung()) {
            return arrayList;
        }
        for (Funktionscode.Modulverwendung.PruefsprachModul pruefsprachModul : vAUDESObjekt.getFunktionscode().getModulverwendung().getPruefsprachModul()) {
            HookRequiredVersionWrapper hookRequiredVersionWrapper = new HookRequiredVersionWrapper();
            hookRequiredVersionWrapper.setRequiredVersion(pruefsprachModul.getVersion());
            hookRequiredVersionWrapper.setComponent(pruefsprachModul.getModulRef());
            hookRequiredVersionWrapper.setTestProgramKey(vAUDESObjekt.getId());
            arrayList.add(hookRequiredVersionWrapper);
        }
        return arrayList;
    }

    public static ITestProgram createTestProgramObjectFrom(VAUDESObjekt vAUDESObjekt) {
        HookTestProgramWrapper hookTestProgramWrapper = null;
        HookTestProgramWrapper hookTestProgramWrapper2 = new HookTestProgramWrapper();
        if (TestProgramTransformHelper.transformTestProgram(hookTestProgramWrapper2, vAUDESObjekt)) {
            hookTestProgramWrapper = hookTestProgramWrapper2;
        }
        return hookTestProgramWrapper;
    }

    public static Set<IStartEndModule> getKnowledgebaseModulsByType(VAUDESObjekt vAUDESObjekt, int n) {
        TreeSet<IStartEndModule> treeSet = new TreeSet<IStartEndModule>(new StartEndModuleComparator());
        if (null == vAUDESObjekt.getWissensbasis()) {
            LOG.warn((Object)"Attempt to transform a non knowledge base object to knowledge base object ... Aborting");
            return treeSet;
        }
        List<VariantenObjektverweisTYPE> list = null;
        if (n == 7 && null != vAUDESObjekt.getWissensbasis().getHatStartModulTests()) {
            list = vAUDESObjekt.getWissensbasis().getHatStartModulTests().getVerweis();
        } else if (n == 8 && null != vAUDESObjekt.getWissensbasis().getHatEndModulTests()) {
            list = vAUDESObjekt.getWissensbasis().getHatEndModulTests().getVerweis();
        } else if (n == 9 && null != vAUDESObjekt.getWissensbasis().getHatHintergrundStartModulTests()) {
            list = vAUDESObjekt.getWissensbasis().getHatHintergrundStartModulTests().getVerweis();
        } else if (n == 10 && null != vAUDESObjekt.getWissensbasis().getHatEndModulVorLoeschen()) {
            list = vAUDESObjekt.getWissensbasis().getHatEndModulVorLoeschen().getVerweis();
        } else if (n == 11 && null != vAUDESObjekt.getWissensbasis().getHatEndModulNachLoeschen()) {
            list = vAUDESObjekt.getWissensbasis().getHatEndModulNachLoeschen().getVerweis();
        }
        if (null == list) {
            return treeSet;
        }
        int n2 = 0;
        for (VariantenObjektverweisTYPE variantenObjektverweisTYPE : list) {
            HookStartEndModuleWrapper hookStartEndModuleWrapper = new HookStartEndModuleWrapper();
            hookStartEndModuleWrapper.setKnowledgeBaseKey(vAUDESObjekt.getId());
            hookStartEndModuleWrapper.setModuleSeqNr(n2);
            hookStartEndModuleWrapper.setModuleType(n);
            hookStartEndModuleWrapper.setTestProgramKey(variantenObjektverweisTYPE.getObjektRef());
            if (null != variantenObjektverweisTYPE.getVariantenregel()) {
                hookStartEndModuleWrapper.setVariantRule(DbgHookTransformHelper.transformVariantRule(variantenObjektverweisTYPE.getVariantenregel()));
            }
            treeSet.add(hookStartEndModuleWrapper);
            ++n2;
        }
        return treeSet;
    }

    public static void adjustStartEndModulObjects(IStartEndModule iStartEndModule, IStartEndModule iStartEndModule2) {
        iStartEndModule.setKnowledgeBaseKey(iStartEndModule2.getKnowledgeBaseKey());
        iStartEndModule.setModuleSeqNr(iStartEndModule2.getModuleSeqNr());
        iStartEndModule.setModuleType(iStartEndModule2.getModuleType());
        iStartEndModule.setTestProgramKey(iStartEndModule2.getTestProgramKey());
        iStartEndModule.setVariantRule(iStartEndModule2.getVariantRule());
    }

    public static List<ITestProgramReference> getTestProgramReferencesFromDiagnosticObject(VAUDESObjekt vAUDESObjekt) {
        ArrayList<ITestProgramReference> arrayList = new ArrayList<ITestProgramReference>();
        if (null == vAUDESObjekt.getDiagnoseobjekt()) {
            LOG.warn((Object)"Attempt to transform a non diagnostic object to diagnostic object ... Aborting");
            return arrayList;
        }
        if (null == vAUDESObjekt.getDiagnoseobjekt().getHatFunktionstests()) {
            return arrayList;
        }
        for (Diagnoseobjekt.HatFunktionstests.Verweis verweis : vAUDESObjekt.getDiagnoseobjekt().getHatFunktionstests().getVerweis()) {
            HookTestProgramReferenceWrapper hookTestProgramReferenceWrapper = new HookTestProgramReferenceWrapper();
            hookTestProgramReferenceWrapper.setDiagObjectKey(vAUDESObjekt.getId());
            hookTestProgramReferenceWrapper.setSporadicError(verweis.isSporadischerFehler());
            hookTestProgramReferenceWrapper.setTestProgramKey(verweis.getObjektRef());
            if (verweis.isOhne12VVersorgung() != null) {
                hookTestProgramReferenceWrapper.set12Vrequired(verweis.isOhne12VVersorgung() == false);
            } else {
                hookTestProgramReferenceWrapper.set12Vrequired(true);
            }
            if (null != verweis.getVariantenregel()) {
                hookTestProgramReferenceWrapper.setVariantRule(DbgHookTransformHelper.transformVariantRule(verweis.getVariantenregel()));
            }
            arrayList.add(hookTestProgramReferenceWrapper);
        }
        return arrayList;
    }

    public static void adjustTestProgramReferenceObjects(ITestProgramReference iTestProgramReference, ITestProgramReference iTestProgramReference2) {
        iTestProgramReference.setDiagObjectKey(iTestProgramReference2.getDiagObjectKey());
        iTestProgramReference.setSporadicError(iTestProgramReference2.getSporadicError());
        iTestProgramReference.setTestProgramKey(iTestProgramReference2.getTestProgramKey());
        iTestProgramReference.setVariantRule(iTestProgramReference2.getVariantRule());
        iTestProgramReference.set12Vrequired(iTestProgramReference2.is12Vrequired());
    }

    public static VAUDESObjekt getTestProgramByClassnameFromIndex(String string) {
        String string2 = string + ".class";
        VAUDESObjekt vAUDESObjekt = null;
        for (Map.Entry<String, IndicatedElement> entry : ObjectIndicator.getInstance().getObjectIndex().entrySet()) {
            if (!(entry.getValue() instanceof IndicatedTestProgramElement)) continue;
            IndicatedTestProgramElement indicatedTestProgramElement = (IndicatedTestProgramElement)entry.getValue();
            try {
                Object object;
                if (null == indicatedTestProgramElement.getClassname() || !indicatedTestProgramElement.getClassname().equals(string2) || !((object = DiagnosticDataAccessHelper.parseFile(entry.getKey(), VAUDESObjekt.class)) instanceof VAUDESObjekt)) continue;
                vAUDESObjekt = (VAUDESObjekt)object;
                break;
            }
            catch (Exception exception) {
                LOG.error((Object)("Error while parsing object with id " + entry.getKey()), (Throwable)exception);
            }
        }
        return vAUDESObjekt;
    }

    public static ITestProgram createDummyFkcDto(FkcMetaData fkcMetaData) {
        HookTestProgramWrapper hookTestProgramWrapper = new HookTestProgramWrapper();
        try {
            hookTestProgramWrapper.setClassName(StringUtils.replaceChars((String)fkcMetaData.getModuleId(), (char)'@', (char)'_'));
            hookTestProgramWrapper.setTestProgramGfsId(fkcMetaData.getModuleId());
            hookTestProgramWrapper.setTestProgramKey(fkcMetaData.getObjectId());
            HookTextIdWrapper hookTextIdWrapper = new HookTextIdWrapper();
            hookTextIdWrapper.setId(fkcMetaData.getTitleTextId());
            hookTextIdWrapper.setSource(fkcMetaData.getObjectId());
            hookTestProgramWrapper.setTitle(hookTextIdWrapper);
            HookTextIdWrapper hookTextIdWrapper2 = new HookTextIdWrapper();
            hookTextIdWrapper2.setId(fkcMetaData.getDescriptionTextId());
            hookTextIdWrapper2.setSource(fkcMetaData.getObjectId());
            hookTestProgramWrapper.setDescription(hookTextIdWrapper2);
            hookTestProgramWrapper.setRequiredVersions(Collections.EMPTY_LIST);
        }
        catch (Exception exception) {
            LOG.error((Object)exception);
        }
        return hookTestProgramWrapper;
    }
}

