/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.index.ext.rule;

import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.IndicatedPresetMeasurementElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.ext.ExtendedDataIndicator;
import de.vw.vaudes.diaghook.index.ext.VaudesObjectDigester;
import de.vw.vaudes.diaghook.index.ext.rule.IExtendedIndicationRule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PresetMeasurementIndicationRule
implements IExtendedIndicationRule {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    @Override
    public void run(Map<String, IndicatedElement> map) throws URISyntaxException {
        Map<URI, List<IndicatedPresetMeasurementElement>> map2 = this.filterPresetMeasurementNodes(map);
        VaudesObjectDigester vaudesObjectDigester = new VaudesObjectDigester();
        for (Map.Entry<URI, List<IndicatedPresetMeasurementElement>> entry : map2.entrySet()) {
            try {
                if (null == entry.getValue().get(0).getInstallationIndexFile()) {
                    for (IndicatedPresetMeasurementElement indicatedPresetMeasurementElement : entry.getValue()) {
                        String string = entry.getKey().toURL().toString() + indicatedPresetMeasurementElement.getFilename();
                        vaudesObjectDigester.run(string);
                        ((IndicatedPresetMeasurementElement)ObjectIndicator.getInstance().getObjectById(indicatedPresetMeasurementElement.getObjectId())).setReleased(vaudesObjectDigester.isMesstechnik());
                    }
                    continue;
                }
                for (IndicatedPresetMeasurementElement indicatedPresetMeasurementElement : entry.getValue()) {
                    try {
                        vaudesObjectDigester.run(ExtendedDataIndicator.resolveFile(entry.getKey().toURL()), indicatedPresetMeasurementElement.getFilename());
                        ((IndicatedPresetMeasurementElement)ObjectIndicator.getInstance().getObjectById(indicatedPresetMeasurementElement.getObjectId())).setReleased(vaudesObjectDigester.isMesstechnik());
                    }
                    catch (Exception exception) {
                        this.fLogger.error((Object)("Error while parsing object " + indicatedPresetMeasurementElement.getFilename()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.fLogger.error((Object)"error during rule execution", (Throwable)exception);
            }
        }
    }

    private Map<URI, List<IndicatedPresetMeasurementElement>> filterPresetMeasurementNodes(Map<String, IndicatedElement> map) throws URISyntaxException {
        HashMap<URI, List<IndicatedPresetMeasurementElement>> hashMap = new HashMap<URI, List<IndicatedPresetMeasurementElement>>();
        for (Map.Entry<String, IndicatedElement> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof IndicatedPresetMeasurementElement)) continue;
            URI uRI = entry.getValue().getUrl().toURI();
            if (null == hashMap.get(uRI)) {
                ArrayList<IndicatedPresetMeasurementElement> arrayList = new ArrayList<IndicatedPresetMeasurementElement>();
                arrayList.add((IndicatedPresetMeasurementElement)entry.getValue());
                hashMap.put(uRI, arrayList);
                continue;
            }
            ((List)hashMap.get(uRI)).add((IndicatedPresetMeasurementElement)entry.getValue());
        }
        return hashMap;
    }
}

