/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.core.exception.ids.Topology;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDiagnosticObject;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDocumentInheritance;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.ISuspicion;
import de.volkswagen.odis.vaudas.domainmodel.gfs.factory.IDiagnosticObjectFactory;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.DiagnosticObjTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.Validate;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DiagnosticObjectFactoryImpl
implements IDiagnosticObjectFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public IDiagnosticObject getDiagnosticObject(String string, IDiagnosticObject iDiagnosticObject) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getDiagnosticObject(" + string + ", " + iDiagnosticObject + ")"));
        }
        boolean bl = iDiagnosticObject != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iDiagnosticObject));
                }
                return iDiagnosticObject;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            IDiagnosticObject iDiagnosticObject2 = DiagnosticObjTransformHelper.createDiagnosticObjectFrom(vAUDESObjekt);
            if (null != iDiagnosticObject2) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iDiagnosticObject2));
                }
                return iDiagnosticObject2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iDiagnosticObject));
                }
                return iDiagnosticObject;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming object " + string), (Throwable)exception);
            if (bl) {
                return iDiagnosticObject;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
    }

    public List<IDiagnosticObject> getDiagnosticObjectChildren(String string, List<IDiagnosticObject> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getDiagnosticObjectChildren(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IDiagnosticObject>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return " + list));
            }
            return list;
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        try {
            List<IDiagnosticObject> list2 = DiagnosticObjTransformHelper.getDiagnosticChildObjectsFrom(vAUDESObjekt);
            list.clear();
            list.addAll(list2);
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming diagnostic objects from object " + string), (Throwable)exception);
            return list;
        }
    }

    public IDiagnosticObject getKnowledgeBaseRoot(String string, IDiagnosticObject iDiagnosticObject) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getKnowledgeBaseRoot(" + string + ", " + iDiagnosticObject + ")"));
        }
        boolean bl = iDiagnosticObject != null;
        Validate.notNull(string);
        Validate.notEmpty(string);
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iDiagnosticObject));
                }
                return iDiagnosticObject;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("found object with id " + string + " ... proceed searching corresponding knowledge base object"));
        }
        if (vAUDESObjekt.getAusstattungsmerkmal() != null && vAUDESObjekt.getAusstattungsmerkmal().getGrundmerkmal() != null && vAUDESObjekt.getAusstattungsmerkmal().getGrundmerkmal().getFahrzeugtyp() != null && vAUDESObjekt.getAusstattungsmerkmal().getGrundmerkmal().getFahrzeugtyp().getHatWissensbasis() != null) {
            try {
                object = DiagnosticDataAccessHelper.parseFile(vAUDESObjekt.getAusstattungsmerkmal().getGrundmerkmal().getFahrzeugtyp().getHatWissensbasis().getVerweis().getObjektRef(), VAUDESObjekt.class);
            }
            catch (NonUniqueResultException nonUniqueResultException) {
                throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
            }
            catch (Exception exception) {
                this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
            }
            if (!(object instanceof VAUDESObjekt)) {
                if (bl) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return " + iDiagnosticObject));
                    }
                    return iDiagnosticObject;
                }
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
            vAUDESObjekt = (VAUDESObjekt)object;
            try {
                IDiagnosticObject iDiagnosticObject2 = DiagnosticObjTransformHelper.createKnowledgeBaseRoot(vAUDESObjekt);
                if (null != iDiagnosticObject2) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return new " + iDiagnosticObject2));
                    }
                    return iDiagnosticObject2;
                }
                if (bl) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return " + iDiagnosticObject));
                    }
                    return iDiagnosticObject;
                }
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
            catch (Exception exception) {
                this.fLogger.error((Object)("Error transforming diagnostic objects from object " + string), (Throwable)exception);
                if (bl) {
                    if (this.fLogger.isDebugEnabled()) {
                        this.fLogger.debug((Object)("return " + iDiagnosticObject));
                    }
                    return iDiagnosticObject;
                }
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
        }
        this.fLogger.warn((Object)"Object found but it got no reference to knowledge base");
        if (iDiagnosticObject == null) {
            throw new OdisBaseException("Can't satisfy IDiagnosticObjectFactory#getKnowledgeBaseRoot() without transfer object", Topology.database().dbReadFailed());
        }
        return iDiagnosticObject;
    }

    public List<ISuspicion> getSuspicions(String string, List<ISuspicion> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getSuspicions(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<ISuspicion>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return " + list));
            }
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        list.clear();
        list.addAll(DiagnosticObjTransformHelper.getSuspicionsFromDiagnosticObject(vAUDESObjekt));
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("return new " + list));
        }
        return list;
    }

    public List<IDocumentInheritance> getDocumentInheritances(String string, List<IDocumentInheritance> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getDocumentInheritances(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IDocumentInheritance>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return " + list));
            }
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(DbgHookTransformHelper.getAllDocumentInheritanceReferencesFrom(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error transforming diagnostic objects from object " + string), (Throwable)exception);
            return list;
        }
    }

    public IDiagnosticObject getDiagnosticObjectByGfsId(String string, IDiagnosticObject iDiagnosticObject) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"getDiagnosticObjectByGfsId called ... delegating");
        }
        return this.getDiagnosticObject(string, iDiagnosticObject);
    }
}

