@echo off

REM ####################################################
REM ### Uninstall ModuleBalancer VAS6910 ###############
REM ####################################################
REM 
REM Changelog
REM v 1.1.0 - 20.02.2025 -- # [OS] [  ]	- Product-Key zum Loeschen hinzugefuegt (Modulebalancer Version 1.1.6)
REM v 1.0.9 - 31.01.2025 -- # [OS] [  ]	- Product-Key zum Loeschen hinzugefuegt
REM v 1.0.8 - 23.09.2024 -- # [OS] [  ]	- Product-Key zum Loeschen hinzugefuegt
REM v 1.0.7 - 28.08.2024 -- # [OS] [  ]	- Product-Key zum Loeschen hinzugefuegt
REM v 1.0.6 - 07.06.2024 -- # [OS] [  ]	- Loeschen des Ordners DiTest nochmal angepasst
REM v 1.0.5 - 06.06.2024 -- # [OS] [  ]	- Loeschen des Ordners DiTest angepasst
REM v 1.0.4 - 05.06.2024 -- # [OS] [  ]	- Ein Product-Key zum Loeschen hinzugefuegt
REM v 1.0.3 - 02.05.2024 -- # [OS] [  ]	- Zwei weitere Product-Keys zum Loeschen hinzugefuegt
REM v 1.0.2 - 14.12.2023 -- # [OS] [  ]	- Loeschen des Ordners DiTest unter Program Files und ProgramData
REM v 1.0.1 - 29.11.2023 -- # [OS] [  ]	- Returncode 1641, 3010 and 1605 are treated as success
REM v 1.0.0 - 23.11.2023 -- # [OS] [  ]	- Script initial erstellt
REM 
REM ####################################################

cd /d "%~dp0"
set SCRIPTVERSION=110
call :getMyDateMyTime
set logfile="%programdata%\Diag_SetupLogs\Uninstall_VAS6910_v%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""


rem Set error flag
set errorSum=0

rem Remove legacy versions
call :UNINSTALL 0F5F01A0-0E2C-42B8-926A-3A9B3CF3460C
call :UNINSTALL 4AA2A454-DF88-4776-80B8-C7497A63EED5
call :UNINSTALL EDE79B27-EE0A-477C-B2AA-83CA4C70CB3C
call :UNINSTALL 1DDAEE8E-F357-4152-9B44-E2A4727CCEB4
call :UNINSTALL 4A5DC20E-417A-46B8-AE8B-8576D13126C9
call :UNINSTALL 9AC0DE07-134D-4FE9-8062-D50DBD0B82C9
call :UNINSTALL 7E20A6EC-D609-41B2-9703-E459817FD915
call :UNINSTALL 7CDDC3FC-A494-47CD-831B-CBD8AB433413
call :UNINSTALL 7A806937-2C0E-48B0-9B94-DEADDB96072B
call :CLEANUP
goto :END


REM ####################################################
REM ### MSI UNINSTALLER ################################
REM ####################################################
:UNINSTALL
call :LOG "%time%" "- - - uninstalling MsiExec Code %1  - - - - - - - -"
REM C:\Windows\SysWOW64\msiexec.exe /x {%1} /qn /norestart /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1
msiexec.exe /x {%1} /qn /norestart /L*v "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile% 2>&1

set returncode=%errorlevel%
call :LOG "%time%" "- - - RETURNCODE: %returncode% - - -"
if %returncode% neq 0 (
	rem The codes 0=ERROR_SUCCESS,1641=ERROR_SUCCESS_REBOOT_INITIATED,3010=ERROR_SUCCESS_REBOOT_REQUIRED,1605=ERROR_UNKNOWN_PRODUCT are treated as success
    if %returncode% neq 1641 (
        if %returncode% neq 3010 (
            if %returncode% neq 1605 (
                set /a errorSum = %errorSum% + 1
            )
        )
    )
)

call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
call :LOG "%time%" "- - - MSI Logfile:  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
type "%programdata%\Diag_SetupLogs\MTtemp.txt">>%logfile%
call :LOG "%time%" "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -"
goto :EOF


REM ####################################################
REM ### Cleanup process ################################
REM ####################################################
:CLEANUP
rem Delete temp log file
del "%programdata%\Diag_SetupLogs\MTtemp.txt" /f /q >>%logfile% 2>&1
call :LOG "%time%" "	- Delete temp file completed with: %ERRORLEVEL%"

rem Delete DiTest folder under ProgramData
set DiTestPath=%programdata%\DiTest
if exist "%DiTestPath%" (
	rd "%DiTestPath%" /s /q >>%logfile% 2>&1
	call :LOG "%time%" "	- Delete folder %DiTestPath% completed with: %ERRORLEVEL%"
)
goto :EOF


REM ################################################
REM ### END process ################################
REM ################################################
:END
call :LOG "%time%" "	- Sum of all uninstall errors: %errorSum%"

cd %ProgramFiles%

set DiTestPath=C:\Program Files\DiTest
if exist "%DiTestPath%" (
	call :LOG "%time%" "	- Delete folder %DiTestPath% and exit with %errorSum%"
	goto 2>nul & rd /s /q "%DiTestPath%" & cmd /c exit /B %errorSum%
) else (
	call :LOG "%time%" "	- And exit with: %errorSum%"
	goto 2>nul & cmd /c exit /B %errorSum%
)


REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ####################################### >> %logfile%
	echo ### ODIS Uninstall ModuleBalancer   ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%                 ### >> %logfile%
	echo ### Logfile %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ####################################### >> %logfile%
	echo.>> %logfile%
	)
echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
goto :EOF