@echo off
color 08
set SCRIPTVERSION=417


REM TODO: :ADD_ENVIRONMENT_VARIABLES mit OS / OE Trennung
REM TODO: Test ob set local notwendig ist


REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
REM - - - - Inhalt  - - - -
REM - - - - - - - - - - - -
REM Shortname: VW_D_PDU_API_
REM
REM	[OS OE] Zertifikate installieren
REM	[OS OE] VWMCD Uninstaller ablegen
REM [OS   ] config.ini - de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=true
REM [   OE] config.ini - eclipse.registry.nulltoken=true
REM [OS OE] PDUAPI_VW.ini - keine Anpassungen - deaktiviert
REM [OS OE] MCD3D_SERVER.ini - MCD3D_LogDirectory=C:/ProgramData/OS|OE/log
REM [OS OE] converter.ini - LogDirectory=C:/ProgramData/OS|OE/log
REM [OS   ] GDI_PA_ Umgebungsvariablen setzen
REM [OS   ] Windows Error Reporting - aktiviert
REM [OS OE] Clean folder Manuals und queue\news - aktiviert
REM [     ] OE Workarounds - deaktiviert
REM [OS OE] Grant permissions on ini files - aktiviert
REM [   OE] Replace java security file - deaktiviert
REM [OS   ] appsettings.json - Parallelbetrieb HV Messmodul und Modul Balancer
REM [OS   ] loggerSettings.json - path=%ProgramData%/Diag_SetupLogs/DiTEST/EmobServiceGRPC/log.txt
REM [OS   ] net.properties - java.net.useSystemProxies=true
REM [OS   ] UpdateProxy deinstallieren - aktiviert
REM [OS OE] Cleanup des Diag_SetupLogs Ordners - aktiviert
REM
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
REM - - - Changelog - - - -
REM - - - - - - - - - - - -
REM
REM V4.1.7 -- 28.02.2025 -- # [OS] [OE]	- :CLEANUP_DIAG_SETUPLOGS erstellt - Cleanup des Diag_SetupLogs Ordners
REM V4.1.6 -- 20.02.2025 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Product-Key zum Loeschen hinzugefuegt (Modulebalancer Version 1.1.6)
REM V4.1.5 -- 31.01.2025 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Product-Key zum Loeschen hinzugefuegt
REM V4.1.4 -- 14.01.2025 -- # [OS] [  ]	- :MOD_MCD3D_SERVER_INI - Add new parameter de.volkswagen.odis.vaudas.systemProxyCheckURL
REM V4.1.3 -- 18.11.2024 -- # [OS] [  ]	- :MOD_MB_LOGGERSETTINGS - Permission change only after the creation of the folder Diag_SetupLogs\DiTEST
REM V4.1.2 -- 14.11.2024 -- # [OS] [  ]	- :MOD_MB_LOGGERSETTINGS - Permission change only on the folder Diag_SetupLogs\DiTEST
REM                         # [OS] [  ]	- :MOD_NET_PROPERTIES - The creation of the update.property file is commented out
REM V4.1.1 -- 02.10.2024 -- # [OS] [  ]	- :MOD_MB_LOGGERSETTINGS - Permission change of the folder Diag_SetupLogs so that users without admin rights can delete it
REM V4.1.0 -- 01.10.2024 -- # [OS] [  ]	- Initialisierung :MOD_MB_APPSETTINGS fuer OS - Parallelbetrieb HV Messmodul und Modul Balancer
REM V4.0.1 -- 23.09.2024 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Product-Key zum Loeschen hinzugefuegt
REM V4.0.0 -- 09.09.2024 -- # [OS] [  ]	- Initialisierung :MOD_MB_LOGGERSETTINGS fuer OS
REM                         # [OS] [  ]	- :MOD_MCD3D_SERVER_INI - Leere Zeilen in der INI-Datei werden beibehalten
REM                         # [OS] [  ]	- :MOD_CONVERTER_INI - Leere Zeilen in der INI-Datei werden beibehalten
REM V3.9.1 -- 29.08.2024 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Product-Key zum Loeschen hinzugefuegt
REM V3.9.0 -- 13.08.2024 -- # [OS] [  ]	- Initialisierung :MOD_NET_PROPERTIES fuer OS - java.net.useSystemProxies auf true gesetzt
REM V3.8.3 -- 07.06.2024 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Loeschen des Ordners DiTest nochmal angepasst
REM V3.8.2 -- 06.06.2024 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Loeschen des Ordners DiTest angepasst
REM V3.8.1 -- 05.06.2024 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Product-Key zum Loeschen hinzugefuegt
REM V3.8.0 -- 03.05.2024 -- # [OS] [OE]	- Zertifikate VW-CA-ROOT-06.cer und VW-CA-PROC-09.cer hinzugefuegt
REM V3.7.0 -- 02.05.2024 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Zwei weitere Product-Keys zum Loeschen hinzugefuegt fuer MB 1.0.1
REM V3.6.6 -- 12.04.2024 -- # [OS] [  ]	- :ENABLE_WER (Windows Error Reporting) - DumpFolder auf %ProgramData%\Diag_SetupLogs\CoreDump gesetzt
REM V3.6.5 -- 26.01.2024 -- # [  ] [OE]	- Deaktivierung :REPLACE_JAVA_SECURITY fuer OE
REM V3.6.4 -- 14.12.2023 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Statt EmobServiceGRPC wird der Ordner DiTest geloescht
REM V3.6.3 -- 08.12.2023 -- # [OS] [  ]	- Zertifikat hinzufuegen QuoVadis_Global_SSL_ICA_G3.crt
REM                         # [OS] [  ]	- :ADD_MB_UNINSTALLER - Anlegen Ordner %ProgramFiles%\DiTest\EmobServiceGRPC falls nicht vorhanden
REM                         # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Korrektur der SCRIPTVERSION und exit parameter
REM V3.6.2 -- 06.12.2022 -- # [OS] [OE]	- Ausbau der abgelaufenen Zertifikate - QuoVadis_Global_SSL_ICA_G3.crt und Symantec_SHA.cer
REM V3.6.1 -- 29.11.2023 -- # [OS] [  ]	- Anpassung Uninstall_VAS6910.bat - Returncode 1641, 3010 and 1605 are treated as success
REM V3.6.0 -- 23.11.2023 -- # [OS] [  ]	- Uninstaller Uninstall_VAS6910.bat fuer ModuleBalancer hinzugefuegt
REM V3.5.0 -- 23.06.2023 -- # [  ] [OE]	- Initialisierung :REPLACE_JAVA_SECURITY fuer OE
REM V3.4.0 -- 13.06.2023 -- # [OS] [  ]	- Initialisierung :REPLACE_JAVA_SECURITY fuer OS
REM V3.3.7 -- 11.05.2023 -- # [OS] [OE]	- :CLEAN_FOLDER - Ordner Manuals und queue\news im Installationsverzeichnis werden aufgeraeumt (Defect#22999)
REM V3.3.6 -- 11.04.2023 -- # [  ] [OE]	- Ordner Manuals und queue\news im Installationsverzeichnis werden entfernt (Defect#22999)
REM V3.3.5 -- 21.03.2023 -- # [OS] [  ]	- :UNINSTALL_UPDATEPROXY - UpdateProxy wird deinstalliert wenn uninstall.exe vorhanden ist
REM V3.3.4 -- 16.03.2023 -- # [  ] [OE]	- Eintrag "de.volkswagen.odis.vaudas.selfdiag.flashing.PDUSizeLimit=65535" in config.ini fuer OE entfernt
REM V3.3.3 -- 02.02.2023 -- # [OS] [OE]	- Das Praefix "odis" der Logdatei ersetzt durch "diag"
REM V3.3.2 -- 16.01.2023 -- # [OS] [OE]	- Aenderung der Berechtigung des Ordners Diag_SetupLogs, damit er ohne Adminrechte geloescht werden kann
REM V3.3.1 -- 05.12.2022 -- # [OS] [  ] - :MOD_CFG - de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=true
REM V3.3.0 -- 01.12.2022 -- # [OS] [  ]	- :ENABLE_WER (Windows Error Reporting) - DumpFolder auf %ProgramData%\Diag_SetupLogs gesetzt
REM V3.2.9 -- 07.11.2022 -- # [OS] [  ]	- :ENABLE_WER (Windows Error Reporting) - aktiviert
REM V3.2.8 -- 21.10.2022 -- # [OS] [  ] - :MOD_CFG - de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=false
REM V3.2.7 -- 18.10.2022 -- # [OS] [OE] - :CHECK_ADMIN_RIGHTS hinzugefuegt
REM                         # [OS] [OE]	- :MOD_MCD3D_SERVER_INI - Anpassung von doppelten Anfuehrungszeichen
REM                         # [OS] [OE]	- :MOD_CONVERTER_INI - Anpassung von doppelten Anfuehrungszeichen
REM V3.2.6 -- 10.10.2022 -- # [OS] [OE]	- Uninstall_all_VWMCD.bat v1.0.9 - Ordner ODIS_SetupLogs ersetzt durch Diag_SetupLogs
REM V3.2.5 -- 12.09.2022 -- # [OS] [OE]	- WIN10_ACTIVITIES umbenannt in GRANT_INI
REM                         # [OS] [OE]	- :GRANT_INI Grant modify permissions on ini files aktiviert
REM                         # [OS] [OE]	- msg.exe * "message" aufrufen statt TEMPmessage.vbs
REM                         # [  ] [OE] - Ordner MCD-PROJECTS-Engineering ersetzt durch MCD-PROJECTS-E
REM V3.2.4 -- 25.08.2022 -- # [OS] [OE] - ODIS Pfade ODIS-[S|E] ersetzt durch OS|OE
REM                         # [OS] [OE]	- Ordner ODIS_SetupLogs ersetzt durch Diag_SetupLogs
REM V3.2.3 -- 24.08.2022 -- # [OS] [OE] - ODIS Pfade Offboard_Diagnostic_Information_System_[Service|Engineering] ersetzt durch ODIS-[S|E]
REM                         # [OS] [OE]	- Grant modify permissions on ini files in :WIN10_ACTIVITIES (deaktiviert)
REM V3.2.2 -- 23.06.2022 -- # [OS] [OE] - iniPath gesetzt auf C:\ProgramData\vw_mcd_[os|oe] in :MOD_MCD3D_SERVER_INI und :MOD_CONVERTER_INI
REM V3.2.1 -- 02.06.2022 -- # [OS] [OE] - :MOD_CONVERTER_INI fuer ODX-Converter Logging erstellt
REM							  [OS] [OE] - Parameter LogDirectory gesetzt auf C:/ProgramData/Offboard_Diagnostic_Information_System_[Engineering|Service]/log
REM                         # [OS] [OE]	- :Uninstall_all_VWMCD.bat fuer VWMCD 18
REM V3.2.0 -- 19.05.2022 -- # [OS] [OE]	- :MOD_MCD3D_SERVER_INI erstellt
REM							  [OS] [OE] - Parameter MCD3D_LogDirectory gesetzt auf C:/ProgramData/Offboard_Diagnostic_Information_System_[Engineering|Service]/log
REM V3.1.9 -- 05.04.2022 -- # [OS] [OE] - Bereitstellung alter :Uninstall_all_VWMCD.bat fuer VWMCD 17.2 aus der Version 3.1.4
REM V3.1.8 -- 17.03.2022 -- # [OS] [  ] - Loeschung des MDG1 Eintrags in der Config.ini fuer OS
REM V3.1.7 -- 09.03.2022 -- # [OS] [OE]	- Ausbau der Microsoft Patches
REM 						# [OS] [OE]	- Ausbau des abgelaufenen Zertifikats - VW-CA-PROC-07.cer
REM V3.1.6 -- 09.02.2022 -- # :MOD_CFG [OS] - de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=true
REM V3.1.5 -- 26.11.2021 -- # [OS] [OE]	- :Uninstall_all_VWMCD.bat neu fuer VWMCD 18
REM V3.1.4 -- 24.11.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :MOD_CFG [OS] - de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=false
REM V3.1.3 -- 22.11.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :MOD_CFG [OS] - de.volkswagen.odis.vaudas.diag.vehicledata.check_mdg1_engine=false
REM V3.1.2 -- 22.09.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :MOD_CFG
REM																	[OS] - de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=true
REM V3.1.1 -- 11.06.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- ::MOD_PDU_INI - deaktiviert
REM V3.1.0 -- 27.04.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :ENABLE_WER - deaktiviert
REM																- :RUN_OE_WORKAROUND - deaktiviert
REM V3.0.8 -- 22.04.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :ENABLE_WER
REM																	[OS] - DumpCount auf 1 gesetzt, damit nur maximal 1 Dump vorliegt
REM V3.0.7 -- 20.03.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :MOD_PDU_INI
REM																	[OE][OS] - Shortname Anpassung von XS_D_PDU_API_zu VW_D_PDU_API_
REM V3.0.6 -- 18.03.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :RUN_OE_WORKAROUND erstellt
REM																	[OE] - .install Datei wird erzeugt
REM																	[OE] - Umbenennen der Ordner DSVR-ProdiMCD zu VWMCD in den OS und OE Fahrzeugprojekt-Hauptordnern (im ProgramData\Offboard_Diagnostic_Information_System_Engineering)
REM																	[OE] - Kopieren von VWVIN ind VWFLEET vom OS in den OE Fahrzeugprojekt-Hauptordner (im ProgramData\Offboard_Diagnostic_Information_System_Engineering)
REM V3.0.5 -- 11.03.2021 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- config.ini - Backup Timestamp korrigiert
REM																	[OS] - Deaktivierung de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing
REM																- :MOD_PDU_INI erstellt
REM																	- neuer Pfad und Dateiname wegen de-Branding der PDU API (kein XS oder ACTIA)
REM																	[OS] - PDUAPI_VW.ini - LogLevel=ERROR
REM																	[OS] - PDUAPI_VW.ini - CanTrace=off
REM																	[OS] - PDUAPI_VW.ini - DoIPTrace=off
REM																	[OS] - PDUAPI_VW.ini - DoIPMirrorTrace=off
REM																- :ADD_ENVIRONMENT_VARIABLES erstellt
REM																	[OS] - GDI_PA_LOGDIR C:\ProgramData\Offboard_Diagnostic_Information_System_Service\log
REM																	[OS] - GDI_PALOG_LEN 4.000.000
REM																	[OS] - GDI_PALOG_NAMESTAMP TIME
REM																- :ENABLE_WER erstellt
REM																	[OS] aktiviert das Windows Error Reporting fuer den ODIS Launcher
REM V3.0.4 -- 30.07.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- Uninstall_all_VWMCD.bat - getMyDateMyTime - neu erstellt, um laenderspezifische Datumsformate zu verarbeiten
REM V3.0.3 -- 29.07.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- getMyDateMyTime - neu erstellt, um laenderspezifische Datumsformate zu verarbeiten
REM																	- entfernt Variable product=OE
REM																	- logging um "temp" erweitert
REM V3.0.2 -- 23.07.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- Uninstall_all_VWMCD.bat v1.0.6 - Timestamp in Loop gefixt, Tiemout fuer VWMCD 15 als workaround eingebaut
REM V3.0.1 -- 09.07.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- Uninstall_all_VWMCD.bat v1.0.5 - Alle Uninstaller sollen Log schreiben, welches an das haupt-Log angefuegt wird
REM																- Logfile setzen: Anpassung des Logifile Namens
REM V3.0.0 -- 23.04.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- Umstellung auf 64 Bit
REM																- [ENTFERNT]:PDUAPI_FIX - wird mit neuer PDU API ueberfluessig
REM 															- :ADD_VWMCD_UNINSTALLER - %ProgramFiles(x86)% ersetzt durch %ProgramFiles%
REM
REM - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
REM V2.1.0 -- 16.04.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG]	- :PDUAPI_FIX - neue PDUAPI_I+ME_ACTIA_XS.dll kopieren fuer ODIS Service VW PDU API
REM V2.0.9 -- 09.03.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG][OE] - Kommentare erweitert, Klammern in Kommentar entfernt
REM V2.0.8 -- 26.02.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG][OE] - Rechtschreibfehler "ovverriding"
REM V2.0.7 -- 20.02.2020 -- # [REMOVE NEXT TIME] [FIX_CONFIG][OE] - Weitere Kommentare werden in die config.ini geschreiben, Defect #21018
REM V2.0.6 -- 13.12.2019 -- # [REMOVE NEXT TIME] [FIX_CONFIG][OE] - Aktivierung der Variable in OE,  "de.volkswagen.odis.vaudas.selfdiag.flashing.PDUSizeLimit=65535"
REM												 [FIX_CONFIG][OS] - alle AEnderungen entfernt, fuer OS wird nichts angepasst
REM V2.0.5 -- 06.09.2019 -- # [REMOVE NEXT TIME] [FIX_CONFIG][OE][OS] - Umbenennung der Variable in OS,  "de.volkswagen.odis.vaudas.business.timeoutDoipSearchInSeconds=20"
REM V2.0.4 -- 05.09.2019 -- # [REMOVE NEXT TIME] [FIX_CONFIG][OE][OS] - Neuer Eintrag in der Config.ini, "de.volkswagen.odis.vaudas.ecucomframework.Toatl_Cyclic_VehicleId_Request_Time=20"
REM V2.0.3 -- 02.09.2019 -- # [REMOVE NEXT TIME] [FIX_CONFIG][OE] - Neuer Eintrag in der Config.ini, "# Allow dynamic extension registration. Required for dynamic brand theme definitions.eclipse.registry.nulltoken=true"
REM V2.0.2 -- 08.08.2019 -- # Neuer Uninstall_all_VWMCD 1.0.3, der sich und auch das VWMCD Verzeichnis entfernt
REM V2.0.1 -- 18.06.2019 -- # Softing_2016.cer wird nicht mehr zum keystre hinzugefuegt
REM							Argument "Product" an erste stelle gesetzt, ob mehrere Argumente funktionieren ist fraglich
REM V2.0.0 -- 24.05.2019 -- # neue main Version fuer neue versionslose Manifeste
REM							OE Workaround (OE hardcoded) entfernt, jetzt produktlos
REM							GMD FIX komplett entfernt
REM							config.ini komplett entfernt
REM							Softing_2016.cer entfernt, da Zertifikat abgelaufen (muss auch aus Manifest Raus)
REM
REM
REM V1.3.3 -- 24.05.2018 -- # [OE] Workaround - Datei neu angelegt, da korrupt
REM V1.3.2 -- 24.05.2018 -- # [OE] Workaround
REM							  GMD FIX deaktiviert, wird ab OE 10.0.0 und OS 6.0.0 nicht mehr benoetigt
REM V1.3.1 -- 24.05.2018 -- # [OE] Workaround fuer OE, weil $Product$ nicht korrekt befuellt wird -> Wird hardcoded auf OE gesetzt
REM V1.3.0 -- 15.05.2018 -- # Ordner fuers Logging vereinheitlicht
REM 						  Uninstall_all_VWMCD aktiviert (ein Uninstaller fuer alle VWMCD Produkte)
REM V1.2.6 -- 05.04.2018 -- # GMD_FIX korrigiert (Datei wurde nicht kopiert)
REM 						  Logging erweitert: Ausfuehrungsverzeichniss
REM 						  Logdatei wird nun unter ProgramDta/ODIS_PFU abgelegt (kein Adminuser mehr notwendig)
REM V1.2.5 -- 01.04.2018 -- # Logging der Windows Buildnummer hinzugefuegt
REM 						  config.ini aus ODIS Service 5.1.4 hinzugefuegt
REM V1.2.4 -- 26.03.2018 -- # GMD_FIX hinzugefuegt: kopiert eine default config.xml in den configuratiopn Ordner, damit GMD immer angezeigt wird.
REM 						  Originale config.xml wird hierbei gesichert
REM 						  os_path Variable hinzugefuegt
REM V1.2.3 -- 14.03.2018 -- # Zertifikat hinzugefuegt QuoVadis_Global_SSL_ICA_G3.crt
REM			                  Zertifikat hinzugefuegt QuoVadis_Root_CA_2_G3.crt
REM							  Inhalt von ADD_VWMCD_UNINSTALLER auskommentiert, da seitesn ODIS der Parameter $PRODUCT$ uebergeben werden muss. Dieser ist allerdings noch nicht implementiert.
REM V1.2.2 -- 15.02.2018 -- # verhalten korrigiert, damit GET_WIN_VERSION ausgefuehrt wird
REM			  ADD_VWMCD_UNINSTALLER hinzugefuegt. Dieser kopiert die Uninstall_all_VWMCD.bat ins VWMCD Zielverzeichnis, abhaengig vom Produkt OS oder OE. Das Produkt wird dabei als uebergabeparameter 1 mitgegeben.
REM V1.2.1 -- 31.01.2018 -- # "Zertifikate hinzufuegen" vorgeschoben, damit diese immer hinzugefuegt werden. Ansonsten gab es bei Win10 kein Hinzufuegen neuer Zertifikate
REM V1.2.0 -- 25.01.2018 -- # VW-CA-PROC-08.cer hinzugefuegt
REM			  VW-CA-PROC-06.cer entfernt
REM			  VW-CA-ROOT-04.cer entfernt
REM V1.1.9 -- 17.08.2017 -- # Thawte-Primary-Root-CA.cer zum  WINDOWS Zertifikatsspeicher hinzugefuegt
REM V1.1.8 -- 31.05.2017 -- # SAVE_VAS6154 wieder entfernt: wird nicht mehr benoetigt
REM V1.1.7 -- 28.04.2017 -- # Zertifikat hinzufuegen # PROC_06 und ROOT_04 zum WINDOWS Zertifikatsspeicher hinzugefuegt, Warung des IE zu unterdruecken
REM V1.1.6 -- 10.04.2017 -- # Zertifikat hinzufuegen # PROC_07 und ROOT_05 zum WINDOWS Zertifikatsspeicher hinzugefuegt, Warung des IE zu unterdruecken
REM V1.1.5 -- Rueckgabewerte fuer Rebbot und Exception angepasst
REM V1.1.4 -- Logging fuer uebergabeparamtere hinzugefuegt
REM         - SAVE_VAS6154 hinzugefuegt: Suchen und kopieren der vci.properties um die WLAn Einstellungen des VAS6154 zu sichern
REM V1.1.3 -- Loeschen des temp. Keystores fuer den Markt USA
REM V1.1.2 -- Path fuer WMIC erweitert um C:\Windows UND C:\Windows\System32
REM V1.1.1 -- Path fuer WMIC erweitert um C:\Windows\System32\wbem
REM V1.1.0 -- Win10 Erkennung eingebaut
REM           Wenn Win10 vorhanden, wird garnichts gemacht, das Script beendet sich
REM           So kann die Pruefung verwendet werden:
REM           if %winversion%==1 (
REM           	call :LOG "%time%" "	OS is Win10 - KB2921916 is not supported and will be skipped"
REM           	SET SUCCESS=1
REM           	GOTO END_SCRIPT
REM           )
REM V1.0.6 -- 15.06.2016 der Hotfix soll optional sein, im Falle eines Fehlers soll Installation fortgesetzt werden. 
REM           Dazu wird der Wert "-2145124329" als i.O. eingestuft
REM V1.0.4 -- Rechtschreibfehler korrigiert
REM V1.0.2 -- 26.04.2015 bat zu PF_UPDATE.bat umbenannt
REM			- bat angepasst: Zertifikat hinzufuegen
REM			- Manifest angepasst: bat. Dateiname und das Zertifikat mit Komma getrennt hinzugefuegt
REM			- LOG Mechanismus implementiert
REM			- Windows6.1-KB2921916-x64.msu hinzugefuegt
REM			- Zertifikate werden installiert Softing_2016.cer,Symantec_SHA.cer,Verisign_G5.cer
REM V1.0.1 -- Windows KB3033929 Checker


REM ####################################################
REM ### PATH erweitern fuer wmic #######################
REM ####################################################
SET "path=%path%;C:\Windows\;C:\Windows\System32\;C:\Windows\System32\wbem"

REM ####################################################
REM ### Returnvariablen definieren #####################
REM ####################################################
set SUCCESS=0
set REBOOT=0
set FAILURE=0
set NOADMIN=0

REM ####################################################
REM ### Logfile setzen #################################
REM ####################################################
REM if exist "%ProgramData%\ODIS_SetupLogs" rmdir /s /q "%ProgramData%\ODIS_SetupLogs"
if not exist "%ProgramData%\Diag_SetupLogs" md "%ProgramData%\Diag_SetupLogs"
call :getMyDateMyTime
set logfile="%ProgramData%\Diag_SetupLogs\diag_PFU_v%SCRIPTVERSION%_%myDate%_%myTime%.log"
call :LOG "%time%" ""
REM ### Changing the permission of the folder Diag_SetupLogs so that it can be deleted by users without admin rights ###
icacls "%ProgramData%\Diag_SetupLogs" /grant Users:F /T >>%logfile% 2>&1

REM ####################################################
REM ### Uebergabeparameter & Sonstiges #################
REM ####################################################
call :LOG "%time%" "Uebergabeparameter 1   (Product): %~1"
call :LOG "%time%" "Uebergabeparameter 2 (ODIS Path): %~2"
call :LOG "%time%" "Uebergabeparameter 3            : %~3"
call :LOG "%time%" ""
call :LOG "%time%" ""
for /f "tokens=*" %%i in ('ver') do set WindowsBuildNumber=%%i
call :LOG "%time%" "    Windows Version: %WindowsBuildNumber%"
call :LOG "%time%" "Aktueller Dateipfad: %~dp0"
call :LOG "%time%" "     Aktuelle Datei: %0"
call :LOG "%time%" "               Temp: %temp%"

cd %~dp0
set ODIS_product=%~1
set ODIS_path=%~2

GOTO :CHECK_ADMIN_RIGHTS


REM ##################################################################
REM #### Check Admin Rights ##########################################
REM ##################################################################
:CHECK_ADMIN_RIGHTS
call :LOG ###
call :LOG "%time%" "Check Admin rights"
net session >nul 2>&1
if %ERRORLEVEL% == 0 (
	call :LOG "%time%" " 	... user has Admin rights."

) else (
	call :LOG "%time%" " 	... user has no Admin rights."
	set NOADMIN=1
	REM GOTO :END_SCRIPT
)
GOTO :ADD_CERTIFICATES


REM ####################################################
REM ### Zertifikat hiinzufuegen ########################
REM ####################################################
:ADD_CERTIFICATES
call :LOG ###
call :LOG "%time%" "Adding the Verisign_G5 certificate to the trusted publishers in the Windows cert store"
certutil -f -addstore Root Verisign_G5.cer >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

call :LOG "%time%" "Adding the ROOT 05 certificate to the Windows cert store"
certutil -f -addstore AuthRoot VW-CA-ROOT-05.cer >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

call :LOG "%time%" "Adding the ROOT 06 certificate to the Windows cert store"
certutil -f -addstore AuthRoot VW-CA-ROOT-06.cer >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

call :LOG "%time%" "Adding the PROC 08 certificate to the  Windows cert store"
certutil -f -addstore CA VW-CA-PROC-08.cer >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

call :LOG "%time%" "Adding the PROC 09 certificate to the  Windows cert store"
certutil -f -addstore CA VW-CA-PROC-09.cer >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

call :LOG "%time%" "Adding the Thawte-Primary-Root-CA.cer certificate to the Windows cert store"
certutil -f -addstore AuthRoot Thawte-Primary-Root-CA.cer >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

call :LOG "%time%" "Adding the QuoVadis_Root_CA_2_G3.crt certificate to the Windows Root cert store"
certutil -f -addstore Root QuoVadis_Root_CA_2_G3.crt >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

call :LOG "%time%" "Adding the QuoVadis_Global_SSL_ICA_G3.crt certificate to the Windows CA cert store"
certutil -f -addstore CA QuoVadis_Global_SSL_ICA_G3.crt >>%logfile% 2>&1
set wert_certutil=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_certutil%"

GOTO :ADD_VWMCD_UNINSTALLER


REM ####################################################
REM ### Add VWMCD Uninstaller ##########################
REM ####################################################
:ADD_VWMCD_UNINSTALLER
call :LOG ###
call :LOG "%time%" "Add Uninstall_all_VWMCD.bat to %ProgramFiles%\VW_MCD_%ODIS_product%\Uninstall_all_VWMCD.bat"
copy Uninstall_all_VWMCD.bat "%ProgramFiles%\VW_MCD_%ODIS_product%\Uninstall_all_VWMCD.bat" /Y >>%logfile% 2>&1
set wert_copy=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_copy%"
if %wert_copy% NEQ 0 (
	call :LOG "%time%" " 	! ! ! Uninstall_all_VWMCD.bat could not be copied ! ! ! Script will continue"
)
GOTO :ADD_MB_UNINSTALLER


REM ####################################################
REM ### Add ModuleBalancer Uninstaller #################
REM ####################################################
:ADD_MB_UNINSTALLER
call :LOG ###
if not exist "%ProgramFiles%\DiTest\EmobServiceGRPC" md "%ProgramFiles%\DiTest\EmobServiceGRPC"
call :LOG "%time%" "Add Uninstall_VAS6910.bat to %ProgramFiles%\DiTest\EmobServiceGRPC\Uninstall_VAS6910.bat"
copy Uninstall_VAS6910.bat "%ProgramFiles%\DiTest\EmobServiceGRPC\Uninstall_VAS6910.bat" /Y >>%logfile% 2>&1
set wert_copy=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_copy%"
if %wert_copy% NEQ 0 (
	call :LOG "%time%" " 	! ! ! Uninstall_VAS6910.bat could not be copied ! ! ! Script will continue"
)
GOTO :MOD_CFG


REM ############################################################
REM ### MOD CONFIG.INI #########################################
REM ############################################################
:MOD_CFG
call :LOG ###
call :LOG "%time%" "Fix config.ini"
if %ODIS_product%.==OS. set ODIS_path="C:\ProgramData\OS"
if %ODIS_product%.==OE. set ODIS_path="C:\ProgramData\OE"
call :LOG "%time%" " 	ODIS Path is set to: %ODIS_path%"
cd /d "%ODIS_path%\configuration"
call :LOG "%time%" " 	Backing up config.ini from:"
cd >> %logfile%
if not exist "%ODIS_path%\configuration\config.ini" (
	call :LOG "%time%" " 	%ODIS_path%\configuration\config.ini not found"
	SET FAILURE=1
	GOTO END_SCRIPT
)
copy config.ini "config_backup_%myDate%_%myTime%.ini" /Y >>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" "	- copy process finished with: %wert%"

REM ### modify the ini file for OS ####################################
	if %ODIS_product%.==OS. (
		call :LOG "%time%" " 	OS changes"
		call :LOG "%time%" " 	Adding new line ### # Flag to determine whether the tracing is enabled aftrer the start of ODIS."
		call :LOG "%time%" " 	Adding new line ### # If the flag is set to 'true', the tracing is enabled (default)."
		call :LOG "%time%" " 	Adding new line ### # If the flag is set to 'false' the is off."
		call :LOG "%time%" " 	Adding new line ### # It is possible to change the tracing mode in the admin area."
		call :LOG "%time%" " 	Adding new line ### de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=true"
		
		REM delete entries, replace all space with . in the search string
		type config.ini^
		| findstr /v "determine.whether.the.tracing.is.enabled"^
		| findstr /v "the.tracing.is.enabled.(default)"^
		| findstr /v "If.the.flag.is.set.to.'false'.the.is.off."^
		| findstr /v "tracing.mode.in.the.admin.area."^
		| findstr /v "de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing"^
		| findstr /v "file.marker"^
		| findstr /v "eof=eof" >output.txt
		
		REM add entries
		echo # Flag to determine whether the tracing is enabled aftrer the start of ODIS.>> output.txt
		echo # If the flag is set to 'true', the tracing is enabled ^(default^).>> output.txt
		echo # If the flag is set to 'false' the is off.>> output.txt
		echo # It is possible to change the tracing mode in the admin area.>> output.txt
		echo de.volkswagen.odis.vaudas.ui.diag.automatic_bus_tracing=true>> output.txt
		echo.>> output.txt
		
		REM create EOF
		call :LOG "%time%" " 	Adding new line ### # End of file marker - must be here"
		call :LOG "%time%" " 	Adding new line ### eof=eof"
		echo # End of file marker - must be here>> output.txt
		echo eof=eof>> output.txt
	)

REM ### modify the ini file for OE ####################################
	if %ODIS_product%.==OE. (
		call :LOG "%time%" " 	OE changes"
		call :LOG "%time%" " 	Adding new line ### # Allow dynamic extension registration. Required for dynamic brand theme definitions."
		call :LOG "%time%" " 	Adding new line ### eclipse.registry.nulltoken=true"

		REM delete enries, replace all space with .
		type config.ini^
		| findstr /v "Allow.dynamic.extension"^
		| findstr /v "eclipse.registry.nulltoken"^
		| findstr /v "file.marker"^
		| findstr /v "eof=eof" >output.txt
		
		REM add entries
		echo # Allow dynamic extension registration. Required for dynamic brand theme definitions.>> output.txt
		echo eclipse.registry.nulltoken=true>> output.txt
		echo.>> output.txt
		
		REM create EOF
		call :LOG "%time%" " 	Adding new line ### End of file marker - must be here"
		call :LOG "%time%" " 	Adding new line ### eof=eof"
		echo # End of file marker - must be here>> output.txt
		echo eof=eof>> output.txt
	)
	

REM ### final operations #############################################
call :LOG "%time%" " 	delete old config.ini"
del config.ini /f /q >>%logfile% 2>&1
call :LOG "%time%" " 	write new config.ini"
copy output.txt config.ini /Y >>%logfile% 2>&1
call :LOG "%time%" " 	delete temporary file"
del output.txt /f /q >>%logfile% 2>&1
cd %~dp0

set SUCCESS=1
REM GOTO :MOD_PDU_INI
REM GOTO :ADD_ENVIRONMENT_VARIABLES
GOTO :MOD_MCD3D_SERVER_INI


REM ############################################################
REM ### MOD PDUAPI.ini #########################################
REM ############################################################
:MOD_PDU_INI
call :LOG ###
call :LOG "%time%" "Fix PDUAPI_VW.ini"
if %ODIS_product%.==OS. set INI_path=C:\ProgramData\Volkswagen\VW_D_PDU_API_OS
if %ODIS_product%.==OE. set INI_path=C:\ProgramData\Volkswagen\VW_D_PDU_API_OE
call :LOG "%time%" " 	INI Path is set to: %INI_path%"
cd /d "%INI_path%"
call :LOG "%time%" " 	Backing up PDUAPI_VW.ini from:"
cd >> %logfile%
if not exist "%INI_path%\PDUAPI_VW.ini" (
	call :LOG "%time%" " 	"%INI_path%\PDUAPI_VW.ini" not found. Script will fail!"
	SET FAILURE=1
	GOTO END_SCRIPT
)
copy "PDUAPI_VW.ini" "PDUAPI_VW_backup_%myDate%_%myTime%.ini" /Y >>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" "	- Kopieren beendet mit: %wert%"

REM ### modify the ini file for OS ####################################
	if %ODIS_product%.==OS. (
		call :LOG "%time%" " 	OS changes"
		call :LOG "%time%" " 	Adding new line ### DoIPTrace=off"
		call :LOG "%time%" " 	Adding new line ### DoIPMirrorTrace=off"
		call :LOG "%time%" " 	Adding new line ### LogLevel=ERROR"
		call :LOG "%time%" " 	Adding new line ### CanTrace=off"

		
		REM delete entries, replace all space with .
		type PDUAPI_VW.ini^
		| findstr /v "modified.params"^
		| findstr /v "see.at"^
		| findstr /v "DoIPTrace="^
		| findstr /v "DoIPMirrorTrace="^
		| findstr /v "LogLevel="^
		| findstr /v "CanTrace=" >output.txt
		
		REM add entries
		echo.>> output.txt
		echo ^;=========================================================================>> output.txt
		echo ^; modified params>> output.txt
		echo ^; see at "DoIP trace">> output.txt
		echo DoIPTrace=off>> output.txt
		echo ^; see at "DoIP Mirroring">> output.txt
		echo DoIPMirrorTrace=off>> output.txt
		echo ^; see at "Logging">> output.txt
		echo LogLevel=ERROR>> output.txt
		echo ^; see at "CAN trace">> output.txt
		echo CanTrace=off>> output.txt
		echo.>> output.txt
		
	)

REM ### modify the ini file for OE ####################################
	if %ODIS_product%.==OE. (
		call :LOG "%time%" " 	OE changes"
		call :LOG "%time%" " 	... nothing to do here"
		GOTO :mod_pdu_api_finish
	)
	

REM ### final operations #############################################
call :LOG "%time%" " 	delete old PDUAPI_VW.ini"
del "PDUAPI_VW.ini" /f /q >>%logfile% 2>&1
call :LOG "%time%" " 	write new PDUAPI_VW.ini"
copy output.txt "PDUAPI_VW.ini" /Y >>%logfile% 2>&1
call :LOG "%time%" " 	delete temporary file"
del output.txt /f /q >>%logfile% 2>&1
cd %~dp0
:mod_pdu_api_finish
set SUCCESS=1
GOTO :ADD_ENVIRONMENT_VARIABLES


REM ############################################################
REM ### MOD MCD3D_SERVER.ini ###################################
REM ############################################################
:MOD_MCD3D_SERVER_INI
call :LOG ###
call :LOG "%time%" "Update MCD3D_SERVER.ini"

setlocal EnableDelayedExpansion

REM ### ini file name ###
set fileName=MCD3D_SERVER.ini

REM ### ini file path depending on product and confdir setting ###
if %ODIS_product%.==OS. set fileDir=C:\ProgramData\vw_mcd_os
if %ODIS_product%.==OE. set fileDir=C:\ProgramData\vw_mcd_oe
set fileFullPath=%fileDir%\%fileName%

call :LOG "%time%" " 	The path of the %fileName% file is: %fileFullPath%"

if not exist "%fileFullPath%" (
	call :LOG "%time%" " 	The INI file %fileFullPath% not found. Script will fail and exit on error!"
	SET FAILURE=1
	GOTO END_SCRIPT
)

REM ### old and new line value in the ini file depending on product ###
set oldLine=;MCD3D_LogDirectory=../log
if %ODIS_product%.==OS. set newLine=MCD3D_LogDirectory=C:/ProgramData/OS/log
if %ODIS_product%.==OE. set newLine=MCD3D_LogDirectory=C:/ProgramData/OE/log

REM ### Check if the ini file already patched ###
findstr /C:"%newLine%" "%fileFullPath%" > nul
if %ERRORLEVEL%==0 (
	call :LOG "%time%" " 	The Parameter MCD3D_LogDirectory has already been set to the correct value!"
)

REM ### Create backup file ###
call :LOG "%time%" " 	Creating backup file"
copy "%fileFullPath%" "%fileDir%\MCD3D_SERVER_backup_%myDate%_%myTime%.ini" /Y >>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	Create backup file completed with: %wert%"

REM ### temp file ###
set "tempFile=%fileDir%\temp.txt"

REM ### new parameter de.volkswagen.odis.vaudas.systemProxyCheckURL because of defect 23948 ###
set "newParameter=de.volkswagen.odis.vaudas.systemProxyCheckURL=https://www.diagnostic-quick-guide.com/"

REM ### update file ###
set "found="
(
	for /f "tokens=1,* delims=]" %%i in ('type "%fileFullPath%" ^| find /n /v ""') do (
		if "%%j"=="%oldLine%" (
			echo %newLine%
			set found=true
		) else if "%%j"=="" (
			echo.
		) else (
			echo %%j
		)
	)
	REM ### add parameter de.volkswagen.odis.vaudas.systemProxyCheckURL ###
	call :LOG "%time%" " 	Add parameter de.volkswagen.odis.vaudas.systemProxyCheckURL"
	if %ODIS_product%.==OS. (
		echo.
		echo # URL to check whether the SystemProxy setting in the net.properties file should be enabled
		echo %newParameter%
	)
) > "%tempFile%"

if not defined found (
	call :LOG "%time%" " 	"%oldLine%" was not found in the %fileName% file. Please check the file!"
)

REM ### replace the ini file by the temp file ###
move /y "%tempFile%" "%fileFullPath%" >>%logfile% 2>&1
call :LOG "%time%" " 	Update %fileName% file completed with: %ERRORLEVEL%!"

endlocal
set SUCCESS=1
GOTO :MOD_CONVERTER_INI


REM ############################################################
REM ### MOD converter.ini ######################################
REM ############################################################
:MOD_CONVERTER_INI
call :LOG ###
call :LOG "%time%" "Update converter.ini"

setlocal EnableDelayedExpansion

REM ### ini file name ###
set fileName=converter.ini

REM ### ini file path depending on product and confdir setting ###
if %ODIS_product%.==OS. set fileDir=C:\ProgramData\vw_mcd_os
if %ODIS_product%.==OE. set fileDir=C:\ProgramData\vw_mcd_oe
set fileFullPath=%fileDir%\%fileName%

call :LOG "%time%" " 	The path of the %fileName% file is: %fileFullPath%"

if not exist "%fileFullPath%" (
	call :LOG "%time%" " 	The INI file %fileFullPath% not found. Script will fail and exit on error!"
	SET FAILURE=1
	GOTO END_SCRIPT
)

REM ### old and new line value in the ini file depending on product ###
set "oldLine=;LogDirectory=../log"
if %ODIS_product%.==OS. set "newLine=LogDirectory=C:/ProgramData/OS/log"
if %ODIS_product%.==OE. set "newLine=LogDirectory=C:/ProgramData/OE/log"

REM ### Check if the ini file already patched ###
findstr /C:"%newLine%" "%fileFullPath%" > nul
if %ERRORLEVEL%==0 (
	call :LOG "%time%" " 	Found "%newLine%" in the %fileName% file, patch is NOT necessary!"
	GOTO :MOD_CONVERTER_INI_FINISH
)

REM ### Create backup file ###
call :LOG "%time%" " 	Creating backup file"
copy "%fileFullPath%" "%fileDir%\converter_backup_%myDate%_%myTime%.ini" /Y >>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	Create backup file completed with: %wert%"

REM ### temp file ###
set "tempFile=%fileDir%\temp.txt"

REM ### update file ###
set "found="
(for /f "tokens=1,* delims=]" %%i in ('type "%fileFullPath%" ^| find /n /v ""') do (
	if "%%j"=="%oldLine%" (
		echo %newLine%
		set found=true
	) else if "%%j"=="" (
		echo.
	) else (
		echo %%j
	)
)) > "%tempFile%"

if not defined found (
	call :LOG "%time%" " 	"%oldLine%" was not found in the %fileName% file. Please check the file!"
	if exist "%tempFile%" (
		del "%tempFile%" /f /q >>%logfile% 2>&1
		call :LOG "%time%" " 	Delete temp file completed with: %ERRORLEVEL%"
	)
	GOTO :MOD_CONVERTER_INI_FINISH
)

REM ### replace the ini file by the temp file ###
move /y "%tempFile%" "%fileFullPath%" >>%logfile% 2>&1
call :LOG "%time%" " 	Update %fileName% file completed with: %ERRORLEVEL%!"

:MOD_CONVERTER_INI_FINISH
endlocal
set SUCCESS=1
GOTO :ADD_ENVIRONMENT_VARIABLES


REM ####################################################
REM ### Add environment variables ######################
REM ####################################################
:ADD_ENVIRONMENT_VARIABLES
call :LOG ###
call :LOG "%time%" "Add permanent Windows environment variables"
setlocal enabledelayedexpansion
if %ODIS_product%.==OS. (
	call :LOG "%time%" "	OS variables"
	
	call :LOG "%time%" "	... GDI_PA_LOGDIR C:\ProgramData\OS\log"
	setx GDI_PA_LOGDIR C:\ProgramData\OS\log /M >>%logfile% 2>&1
	set wert_setx=%ERRORLEVEL%
	call :LOG "%time%" " 	RETURNCODE: %wert_setx%"
	
	call :LOG "%time%" "	... GDI_PALOG_LEN 4.000.000"
	setx GDI_PALOG_LEN 4.000.000 /M >>%logfile% 2>&1
	set wert_setx=%ERRORLEVEL%
	call :LOG "%time%" " 	RETURNCODE: %wert_setx%"
	
	call :LOG "%time%" "	... GDI_PALOG_NAMESTAMP TIME"
	setx GDI_PALOG_NAMESTAMP TIME /M >>%logfile% 2>&1
	set wert_setx=%ERRORLEVEL%
	call :LOG "%time%" " 	RETURNCODE: %wert_setx%"
)
endlocal
set SUCCESS=1
GOTO :ENABLE_WER


REM ####################################################
REM ### Windows Error Reporting ########################
REM ####################################################
:ENABLE_WER
call :LOG ###
call :LOG "%time%" "Enalbe Windows Error Reporting"

call :LOG "%time%" "	... adding key"
REG ADD "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\Windows Error Reporting\LocalDumps\OffboardDiagLauncher.exe" /f >>%logfile% 2>&1
set wert_reg=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_reg%"

call :LOG "%time%" "	... creating DumpFolder if needed"
if not exist "%ProgramData%\Diag_SetupLogs\CoreDump" md "%ProgramData%\Diag_SetupLogs\CoreDump"
call :LOG "%time%" "	... adding DumpFolder"
REG ADD "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\Windows Error Reporting\LocalDumps\OffboardDiagLauncher.exe" /v DumpFolder /t REG_EXPAND_SZ /d %ProgramData%\Diag_SetupLogs\CoreDump /f >>%logfile% 2>&1
set wert_reg=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_reg%"

call :LOG "%time%" "	... adding DumpCount"
REG ADD "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\Windows Error Reporting\LocalDumps\OffboardDiagLauncher.exe" /v DumpCount /t REG_DWORD /d 1 /f >>%logfile% 2>&1
set wert_reg=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_reg%"

call :LOG "%time%" "	... adding DumpType"
REG ADD "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\Windows Error Reporting\LocalDumps\OffboardDiagLauncher.exe" /v DumpType /t REG_DWORD /d 2 /f >>%logfile% 2>&1
set wert_reg=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert_reg%"

set SUCCESS=1
REM GOTO :RUN_OE_WORKAROUND
GOTO :CLEAN_FOLDER


REM ################################################
REM ### Clean folders Manuals and queue\news ########
REM ################################################
:CLEAN_FOLDER
call :LOG ###
call :LOG "%time%" "Clean folders Manuals and queue\news in the installation directory"

if %ODIS_product%.==OS. GOTO :CLEAN_OS_FOLDER
if %ODIS_product%.==OE. GOTO :CLEAN_OE_FOLDER

:CLEAN_OS_FOLDER
set manualsPath=C:\ProgramData\OS\Manuals
call :LOG "%time%" " 	the path of the folder Manuals is set to: %manualsPath%"

REM ### Delete folder Manuals ###
if exist "%manualsPath%" rmdir /s /q "%manualsPath%"
set wert_del_manuals=%ERRORLEVEL%
call :LOG "%time%" " 	- clean folder Manuals finished with: %wert_del_manuals%"

GOTO :CLEAN_FOLDER_FINISH

:CLEAN_OE_FOLDER
set manualsPath=C:\ProgramData\OE\Manuals
set newsPath=C:\ProgramData\OE\queue\news
call :LOG "%time%" " 	the path of the folder Manuals is set to: %manualsPath%"
call :LOG "%time%" " 	the path of the folder queue\news is set to: %newsPath%"

REM ### Delete PDU-API documents ### 
if exist "%manualsPath%\VAS6154" rmdir /s /q "%manualsPath%\VAS6154"
set wert_del_manuals=%ERRORLEVEL%
call :LOG "%time%" " 	- clean PDU-API documents finished with: %wert_del_manuals%"

REM ### Delete user handbooks ###
if exist "%manualsPath%\Manual_engineering*.pdf" del /f /q "%manualsPath%\Manual_engineering*.pdf"
set wert_del_manuals=%ERRORLEVEL%
call :LOG "%time%" " 	- clean user handbooks finished with: %wert_del_manuals%"

REM ### Delete release notes ###
if exist "%newsPath%\releasenotes*.pdf" del /f /q "%newsPath%\releasenotes*.pdf"
set wert_del_news=%ERRORLEVEL%
call :LOG "%time%" " 	- clean release notes finished with: %wert_del_news%"

GOTO :CLEAN_FOLDER_FINISH

:CLEAN_FOLDER_FINISH
SET SUCCESS=1
GOTO :GRANT_INI


REM ####################################################
REM ### ODIS Engineering Workarounds ###################
REM ####################################################
:RUN_OE_WORKAROUND
if %ODIS_product%.==OS. GOTO run_oe_workaround_finish
call :LOG ###
call :LOG "%time%" "ODIS Engineering Workarounds"
call :LOG "%time%" "Create .install file"
set PD_OE_Path=C:\ProgramData\OE
cd %PD_OE_Path% 

REM ### Write the .install file
echo installation.mcdprojects.engineering=C\:\\ProgramData\\OE\\MCD-PROJECTS-E\\VWMCD>.install
echo installation.mcdprojects=C\:\\ProgramData\\OE\\MCD-PROJECTS\\VWMCD>>.install


REM ### Rename ProdiMCD folders
call :LOG "%time%" ""
call :LOG "%time%" "Rename ProdiMCD folders:"
REM ### 	Rename OS ProdiMCD folder
:rename_prodimcd_os
call :LOG "%time%" "Rename ProdiMCD OS:"
if not exist "%PD_OE_Path%\MCD-PROJECTS\DSVR-ProdiMCD" (
	call :LOG "%time%" "	... %PD_OE_Path%\MCD-PROJECTS\DSVR-ProdiMCD not found"
	call :LOG "%time%" "	... skipping this step"
	GOTO rename_prodimcd_oe
)
call :LOG "%time%" " 	Rename %PD_OE_Path%\MCD-PROJECTS\DSVR-ProdiMCD to VWMCD"
call :LOG "%time%" " 	... cleaning path ..."
del %PD_OE_Path%\MCD-PROJECTS\VWMCD /f /q /s>>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"
rd %PD_OE_Path%\MCD-PROJECTS\VWMCD /q /s>>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"

call :LOG "%time%" " 	... renaming path ..."
RENAME "%PD_OE_Path%\MCD-PROJECTS\DSVR-ProdiMCD" VWMCD>>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"

REM ### 	Rename OE ProdiMCD folder
:rename_prodimcd_oe
call :LOG "%time%" ""
call :LOG "%time%" "Rename ProdiMCD OE:"
if not exist "%PD_OE_Path%\MCD-PROJECTS-E\DSVR-ProdiMCD" (
	call :LOG "%time%" "	... %PD_OE_Path%\MCD-PROJECTS-E\DSVR-ProdiMCD not found"
	call :LOG "%time%" "	... skipping this step"
	GOTO copy_entry_projects
)
call :LOG "%time%" " 	Rename %PD_OE_Path%\MCD-PROJECTS-E\DSVR-ProdiMCD to VWMCD"
call :LOG "%time%" " 	... cleaning path ..."
del %PD_OE_Path%\MCD-PROJECTS-E\VWMCD /f /q /s>>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"
rd %PD_OE_Path%\MCD-PROJECTS-E\VWMCD /q /s>>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"

call :LOG "%time%" " 	... renaming path ..."
RENAME "%PD_OE_Path%\MCD-PROJECTS-E\DSVR-ProdiMCD" VWMCD>>%logfile% 2>&1
set wert=%ERRORLEVEL%
call :LOG "%time%" " 	RETURNCODE: %wert%"


REM ### Copy VWVIN and VW FLEET
:copy_entry_projects
cd %PD_OE_Path% 
call :LOG "%time%" ""
call :LOG "%time%" "Copy Projects:"
call :LOG "%time%" "Copy VWVIN ..."
if not exist "%PD_OE_Path%\MCD-PROJECTS-E\VWMCD\VWVIN" (
	md "%PD_OE_Path%\MCD-PROJECTS-E\VWMCD">>%logfile% 2>&1
	call :LOG "%time%" "	... %PD_OE_Path%\MCD-PROJECTS\VWMCD\VWVIN  to  %PD_OE_Path%\MCD-PROJECTS-E\VWMCD\VWVIN"
	robocopy "%PD_OE_Path%\MCD-PROJECTS\VWMCD\VWVIN" "%PD_OE_Path%\MCD-PROJECTS-E\VWMCD\VWVIN" /E /COPYALL /R:10 /W:1 /NP>>%logfile% 2>&1
	set wert=%ERRORLEVEL%
	call :LOG "%time%" " 	RETURNCODE: %wert%"
) else (
	call :LOG "%time%" " 	... it already exist"
)

call :LOG "%time%" "Copy VWFLEET ..."
if not exist "%PD_OE_Path%\MCD-PROJECTS-E\VWMCD\VWFLEET" (
	md "%PD_OE_Path%\MCD-PROJECTS-E\VWMCD">>%logfile% 2>&1
	call :LOG "%time%" "	... %PD_OE_Path%\MCD-PROJECTS\VWMCD\VWFLEET  to  %PD_OE_Path%\MCD-PROJECTS-E\VWMCD\VWFLEET"
	robocopy "%PD_OE_Path%\MCD-PROJECTS\VWMCD\VWFLEET" "%PD_OE_Path%\MCD-PROJECTS-E\VWMCD\VWFLEET" /E /COPYALL /R:10 /W:1 /NP>>%logfile% 2>&1
	set wert=%ERRORLEVEL%
	call :LOG "%time%" " 	RETURNCODE: %wert%"
) else (
	call :LOG "%time%" " 	... it already exist"
)

:run_oe_workaround_finish
cd %~dp0
set SUCCESS=1
GOTO :GRANT_INI


REM ############################################################
REM ### Grant permissions on ini files #########################
REM ############################################################
:GRANT_INI
call :LOG ###

REM ### Grant modify permissions on ini files
call :LOG "%time%" "GRANT INI files: Grant modify permissions on ini files"
if %ODIS_product%.==OS. set iniPath="C:\ProgramData\vw_mcd_os\*.ini"
if %ODIS_product%.==OE. set iniPath="C:\ProgramData\vw_mcd_oe\*.ini"
call :LOG "%time%" " 	INI Path is set to: %iniPath%"
icacls %iniPath% /grant Users:M /T >>%logfile% 2>&1
set wertGrant=%ERRORLEVEL%
call :LOG "%time%" "	- Grant modify permissions on ini files is completed with: %wertGrant%"

SET SUCCESS=1
GOTO :MOD_MB_LOGGERSETTINGS


REM ########################################################
REM ### Replace java.security file #########################
REM ########################################################
REM :REPLACE_JAVA_SECURITY
REM if %ODIS_product%.==OS. GOTO :REPLACE_JAVA_SECURITY_FINISH
REM call :LOG ###
REM call :LOG "%time%" "Replace java.security file"

REM set fileName=java.security
REM set fileDir=%ProgramFiles%\%ODIS_product%\jre\conf\security
REM set fileFullPath=%fileDir%\%fileName%
REM call :LOG "%time%" " 	File full path is set to: %fileFullPath%"

REM if not exist "%fileFullPath%" (
	REM call :LOG "%time%" "The java security file to be replaced is not found. Script will fail and exit on error!"
	REM SET FAILURE=1
	REM GOTO END_SCRIPT
REM )

REM REM ### Create backup file
REM if not exist "%fileDir%\ORIGINAL_%fileName%" (
	REM call :LOG "%time%" "	- creating backup file"
	REM copy "%fileFullPath%" "%fileDir%\ORIGINAL_%fileName%" /Y >>%logfile% 2>&1
	REM call :LOG "%time%" "	- Creating backup completed with: %ERRORLEVEL%"
REM )

REM REM ### Copy file to destination
REM call :LOG "%time%" "Copying %fileName% to the destination"
REM cd /d %~dp0
REM copy /y "%fileName%" "%fileFullPath%" >>%logfile% 2>&1
REM set wert=%ERRORLEVEL%
REM call :LOG "%time%" "	- Copying completed with: %wert%"

REM :REPLACE_JAVA_SECURITY_FINISH
REM SET SUCCESS=1
REM GOTO :UNINSTALL_UPDATEPROXY


REM ############################################################
REM ### MOD MB loggerSettings.json #############################
REM ############################################################
:MOD_MB_LOGGERSETTINGS
setlocal EnableDelayedExpansion

REM ### Only OS relevant ###
if %ODIS_product%.==OE. GOTO :MOD_MB_LOGGERSETTINGS_FINISH

call :LOG ###
call :LOG "%time%" "Update Module Balancer logger settings"

REM ### File name and file directory ###
set "fileName=loggerSettings.json"
set "fileDir=%ProgramFiles%\DiTest\EmobServiceGRPC"
set "fileFullPath=%fileDir%\%fileName%"
set "tempFile=%fileDir%\temp.txt"
set "searchString=%%APPDATA%%/DiTEST/EmobServiceGRPC/Logs/log.txt"
set "replaceString=%%ProgramData%%/Diag_SetupLogs/DiTEST/EmobServiceGRPC/log.txt"
set "logDir=%ProgramData%\Diag_SetupLogs\DiTEST\EmobServiceGRPC"

call :LOG "%time%" " 	The path of the loggerSettings.json file is: %fileFullPath%"

REM ### Create MB log folder if necessary
if not exist "%logDir%" (
	call :LOG "%time%" " 	The folder %logDir% will be created."
	md "%logDir%" >>%logfile% 2>&1
	REM ### Users without admin rights can delete the folder
	call :LOG "%time%" " 	Permission change of the folder DiTEST so that users without admin rights can delete it"
	icacls "%ProgramData%\Diag_SetupLogs\DiTEST" /grant Users:F /T >>%logfile% 2>&1
)

REM ### Check if the logger setting file exists
if not exist "%fileFullPath%" (
	call :LOG "%time%" " 	The loggerSettings.json file is not found. Script will continue running."
	GOTO :MOD_MB_LOGGERSETTINGS_FINISH
)

REM ### Check if the logger setting file already updated ###
call :LOG "%time%" " 	Check if the logger setting file already updated"
findstr /C:"%replaceString%" "%fileFullPath%" > nul
if %ERRORLEVEL%==0 (
	call :LOG "%time%" " 	Found required adjustment in the %fileName% file, update is NOT necessary!"
	GOTO :MOD_MB_LOGGERSETTINGS_FINISH
)
call :LOG "%time%" " 	NOT found required adjustment in the %fileName% file, update is necessary!"

REM ### Create backup file ###
if not exist "%fileDir%\ORIGINAL_%fileName%" (
	call :LOG "%time%" " 	Creating backup file"
	copy "%fileFullPath%" "%fileDir%\ORIGINAL_%fileName%" /Y >>%logfile% 2>&1
	set wert=%ERRORLEVEL%
	call :LOG "%time%" " 	Create backup file completed with: %wert%"
)

REM ### Update file ###
call :LOG "%time%" " 	Updating file..."
(for /f "delims=" %%i in ('type "%fileFullPath%"') do (
    set "line=%%i"
    set "line=!line:%searchString%=%replaceString%!"
    echo !line!
)) > "%tempFile%"

REM ### The original file is replaced by the temp file ###
move /Y "%tempFile%" "%fileFullPath%"

call :LOG "%time%" " 	Update %fileName% file completed with: %ERRORLEVEL%!"

:MOD_MB_LOGGERSETTINGS_FINISH
endlocal
SET SUCCESS=1
GOTO :MOD_MB_APPSETTINGS


REM ############################################################
REM ### MOD MB appsettings.json ################################
REM ############################################################
:MOD_MB_APPSETTINGS
setlocal EnableDelayedExpansion

REM ### Only OS relevant ###
if %ODIS_product%.==OE. GOTO :MOD_MB_APPSETTINGS_FINISH

call :LOG ###
call :LOG "%time%" "Update Module Balancer app settings"

REM ### File name and file directory ###
set "fileName=appsettings.json"
set "fileDir=%ProgramFiles%\DiTest\EmobServiceGRPC"
set "fileFullPath=%fileDir%\%fileName%"
set "tempFile=%fileDir%\temp.txt"

call :LOG "%time%" " 	The path of the appsettings.json file is: %fileFullPath%"

REM ### Flags to track the sections ###
set "inHvSafety=false"
set "inWorkSafe=false"

REM ### Check if the app setting file exists ###
if not exist "%fileFullPath%" (
	call :LOG "%time%" " 	The appsettings.json file is not found. Script will continue running."
	GOTO :MOD_MB_APPSETTINGS_FINISH
)

REM ### Create backup file ###
if not exist "%fileDir%\ORIGINAL_%fileName%" (
	call :LOG "%time%" " 	Creating backup file"
	copy "%fileFullPath%" "%fileDir%\ORIGINAL_%fileName%" /Y >>%logfile% 2>&1
	set wert=%ERRORLEVEL%
	call :LOG "%time%" " 	Create backup file completed with: %wert%"
)

REM ### Read the JSON file and replace the values ###
(for /f "delims=" %%i in ('type "%fileFullPath%"') do (
    set "line=%%i"
    
    REM ### Check if the HvSafety section bas been reached ###
    echo %%i | findstr /c:"\"AVL.DiTEST.HvSafety\":" >nul && set "inHvSafety=true" && set "inWorkSafe=false"
    
    REM ### Check if the WorkSafe section has been reached ###
    echo %%i | findstr /c:"\"AVL.DiTEST.WorkSafe\":" >nul && set "inWorkSafe=true" && set "inHvSafety=false"
    
    REM ### Set the value of the parameter "Enabled" to "false" only in the specified sections ###
    if "!inHvSafety!"=="true" (
        set "line=!line:"Enabled": "true"="Enabled": "false"!"
    ) else if "!inWorkSafe!"=="true" (
        set "line=!line:"Enabled": "true"="Enabled": "false"!"
    )
	
    REM ### Other lines will not be changed ###
    echo !line!>> "%tempFile%"
))

REM ### The original file is replaced by the temp file ###
move /Y "%tempFile%" "%fileFullPath%"

call :LOG "%time%" " 	Update %fileName% file completed with: %ERRORLEVEL%!"

:MOD_MB_APPSETTINGS_FINISH
endlocal
SET SUCCESS=1
GOTO :MOD_NET_PROPERTIES


REM ############################################################
REM ### MOD net.properties #####################################
REM ############################################################
:MOD_NET_PROPERTIES
setlocal EnableDelayedExpansion

REM ### Only OS relevant ###
if %ODIS_product%.==OE. GOTO :MOD_NET_PROPERTIES_FINISH

call :LOG ###
call :LOG "%time%" "Update net.properties"

REM ### Use the domain name to determine whether the computer is from VW Group ###
set "key=HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters"
set "value=Domain"

for /f "tokens=2*" %%a in ('REG QUERY "!key!" /v !value! 2^>nul') do (
    set "data=%%b"
)

REM if not defined data (
    REM call :LOG "%time%" " 	Entry Domain not found under %key%."
	REM REM ### get domain name using WMIC ###
	REM for /f "tokens=*" %%a in ('wmic computersystem get domain ^| findstr /r /v "^$"') do (
		REM set "data=%%a"
	REM )
REM )

if not defined data (
	call :LOG "%time%" " 	Domain name not found!"
	GOTO :MOD_NET_PROPERTIES_FINISH
)

REM ### The net.properties file will be modified only on VW Group computers ###
call :LOG "%time%" " 	The domain name of this computer is: !data!"
If not "!data:~-4!"==".vwg" (
    call :LOG "%time%" " 	This is not a VW Group computer!"
	GOTO :MOD_NET_PROPERTIES_FINISH
)

REM ### file name and file directory ###
set fileName=net.properties
set fileDir=%ProgramFiles%\OS\jre\conf
set fileFullPath=%fileDir%\%fileName%

call :LOG "%time%" " 	The path of the net.properties file is: %fileFullPath%"

if not exist "%fileFullPath%" (
	call :LOG "%time%" " 	The net.properties file is not found. Script will continue running."
	GOTO :MOD_NET_PROPERTIES_FINISH
)

REM ### Check if the net.properties file already patched ###
set "searchStr=java.net.useSystemProxies=true"
findstr /C:"%searchStr%" "%fileFullPath%" > nul
if %ERRORLEVEL%==0 (
	call :LOG "%time%" " 	Found "%searchStr%" in the %fileName% file, patch is NOT necessary!"
	GOTO :MOD_NET_PROPERTIES_FINISH
)

REM ### Create backup file ###
if not exist "%fileDir%\ORIGINAL_%fileName%" (
	call :LOG "%time%" " 	Creating backup file"
	copy "%fileFullPath%" "%fileDir%\ORIGINAL_%fileName%" /Y >>%logfile% 2>&1
	set wert=%ERRORLEVEL%
	call :LOG "%time%" " 	Create backup file completed with: %wert%"
)

REM ### update file ###
set "searchStr=java.net.useSystemProxies=false"
set "newLine=java.net.useSystemProxies=true"
set "tempFile=%fileDir%\temp.txt"

set "found="
(for /f "tokens=1,* delims=]" %%i in ('type "%fileFullPath%" ^| find /n /v ""') do (
	if "%%j"=="%searchStr%" (
		echo %newLine%
		set found=true
	) else if "%%j"=="" (
		echo.
	) else (
		echo %%j
	)
)) > "%tempFile%"

if not defined found (
	call :LOG "%time%" " 	"%searchStr%" was not found in the %fileName% file. Please check the file!"
	if exist "%tempFile%" (
		del "%tempFile%" /f /q >>%logfile% 2>&1
		call :LOG "%time%" " 	Delete temp file completed with: %ERRORLEVEL%"
	)
	GOTO :MOD_NET_PROPERTIES_FINISH
)

REM ### replace net.properties file ###
move /y "%tempFile%" "%fileFullPath%" >>%logfile% 2>&1
call :LOG "%time%" " 	Update %fileName% file completed with: %ERRORLEVEL%!"


REM ### Create the update.property file ###
REM set propertyFileName=update.property
REM set propertyFileFullPath=C:\temp\%propertyFileName%
REM if not exist "%propertyFileFullPath%" (
    REM echo java.net.useSystemProxies=true> "%propertyFileFullPath%"
	REM call :LOG "%time%" " 	Create %propertyFileName% file completed with: %ERRORLEVEL%!"
	REM ### Changing the permission of the file so that it can be deleted by users without admin rights ###
	REM icacls "%propertyFileFullPath%" /grant Users:F /T
	REM GOTO :MOD_NET_PROPERTIES_FINISH
REM )

:MOD_NET_PROPERTIES_FINISH
endlocal
SET SUCCESS=1
GOTO :UNINSTALL_UPDATEPROXY


REM ###############################################################################
REM ### UpdateProxy will be uninstalled if uninstall.exe (OS 23.0.0) is present ###
REM ###############################################################################
:UNINSTALL_UPDATEPROXY
if %ODIS_product%.==OE. GOTO :UNINSTALL_UPDATEPROXY_FINISH

call :LOG ###
call :LOG "%time%" "UpdateProxy will be uninstalled if uninstall.exe is present"

set proxyPath="%ProgramFiles%\OS\UpdateProxy"
call :LOG "%time%" " 	UpdateProxy Path is set to: %proxyPath%"

if exist %proxyPath%\uninstall.exe (
	call :LOG "%time%" " 	uninstall.exe is found"
	
	REM ### uninstall.exe will be run in silent mode ###
	call :LOG "%time%" " 	uninstall.exe will be run in silent mode"
	rem start /B /D %proxyPath% uninstall.exe -q >>%logfile% 2>&1
	call %proxyPath%\uninstall.exe -q >>%logfile% 2>&1
) else (
	call :LOG "%time%" " 	uninstall.exe is not found"
)
set wert_uninstall=%ERRORLEVEL%
call :LOG "%time%" " 	Uninstall of UpdateProxy finished with: %wert_uninstall%"

:UNINSTALL_UPDATEPROXY_FINISH
SET SUCCESS=1
GOTO :CLEANUP_DIAG_SETUPLOGS


REM ##############################################
REM ### Cleanup Diag_SetupLogs folder ############
REM ##############################################
:CLEANUP_DIAG_SETUPLOGS
call :LOG ###
call :LOG "%time%" "Cleanup Diag_SetupLogs folder"

setlocal enabledelayedexpansion

REM ### Set the target directory
set "TARGET_DIR=C:\ProgramData\Diag_Setuplogs"

if not exist "%TARGET_DIR%" (
	call :LOG "%time%" "Diag_Setuplogs folder does not exist"
	GOTO :CLEANUP_DIAG_SETUPLOGS_FINISH
)

REM ### Delete files older than 6 months
forfiles /p "%TARGET_DIR%" /s /m *.* /d -180 /c "cmd /c del /f /q @path"
call :LOG "%time%" "	- Delete files older than 6 months completed"

REM ### Delete files larger than 10 MB
for /r "%TARGET_DIR%" %%F in (*) do (
    set "size=%%~zF"
    if !size! GTR 10485760 del /f /q "%%F"
)
call :LOG "%time%" "	- Delete files larger than 10 MB completed"

:CLEANUP_DIAG_SETUPLOGS_FINISH
endlocal
set SUCCESS=1
GOTO :END_SCRIPT


REM ############################################################
REM ### get Date and Time ######################################
REM ############################################################
:getMyDateMyTime
set myDate=%date:\=%
set myDate=%myDate:/=%
set myDate=%myDate::=%
set myDate=%myDate:^*=%
set myDate=%myDate:?=%
set myDate=%myDate:<=%
set myDate=%myDate:>=%
set myDate=%myDate:|=%
set myDate=%myDate: =0%
set myTime=%TIME::=%
set myTime=%myTime:;=%
set myTime=%myTime:,=%
set myTime=%myTime: =0%
goto :EOF


REM ####################################################
REM ### Logger #########################################
REM ####################################################
:LOG
if not exist %logfile% (
	echo.> %logfile%
	echo ############################### >> %logfile%
	echo ### ODIS Patch First Update ### >> %logfile%
	echo ### Version:  %SCRIPTVERSION:~0,1%.%SCRIPTVERSION:~1,1%.%SCRIPTVERSION:~2,1%         ### >> %logfile%
	echo ### Starte Log %logfile% ### >> %logfile%
	echo ### Datum %date%  Zeit %time:~0,2%:%time:~3,2%:%time:~6,2% ### >> %logfile%
	echo ############################### >> %logfile%
	echo.>> %logfile%
	)
if %1.==###. (
	echo.>> %logfile%
	echo "%time%" ################################################## >> %logfile%
) else (
	echo %1 ### %2 %3 %4 %5 %6 %7 %8 %9 >> %logfile%
)
goto :EOF



REM ####################################################
REM #### ENDMODULES ####################################
REM ####################################################

REM #### END_SCRIPT ############
:END_SCRIPT
call :LOG ###
call :LOG "%time%" "Terminating the script"
call :LOG "%time%" " 	SUCCESS: %SUCCESS%"
call :LOG "%time%" " 	REBOOT: %REBOOT%"
call :LOG "%time%" " 	NOADMIN: %NOADMIN%"
call :LOG "%time%" " 	FAILURE: %FAILURE%"
if %FAILURE%% EQU 1 GOTO NOK
if %REBOOT%% EQU 1 GOTO REBOOT
REM if %NOADMIN%% EQU 1 GOTO NOADMIN
if %SUCCESS%% EQU 1 GOTO OK
GOTO :EXCEPTION

REM #### OK ############
:OK
call :LOG ###
call :LOG "%time%" "! ! ! Script finished successfully ! ! !"
EXIT /B 0

REM #### NOK ############
:NOK
call :LOG ###
call :LOG "%time%" "!!! Script failed, KB3033929/KB2921916 Error !!!"
REM echo MSGBOX "!!! KB3033929/KB2921916 Error! Contact your administrator !!!" > %temp%\TEMPmessage.vbs
REM call %temp%\TEMPmessage.vbs >>%logfile% 2>&1
REM del %temp%\TEMPmessage.vbs /f /q >>%logfile% 2>&1
REM C:\Windows\System32\msg.exe /TIME:99000 /W "%username%" !!! KB3033929/KB2921916 Error! Contact your Administrator !!! >>%logfile% 2>&1
C:\Windows\System32\msg.exe * "!!! KB3033929/KB2921916 Error! Contact your Administrator !!!" >>%logfile% 2>&1
EXIT /B 1

REM #### REBOOT #########
:REBOOT
call :LOG ###
call :LOG "%time%" "Script finished successfully, but needs reboot. --- Script will show failure"
REM echo MSGBOX "!!! Please REBOOT your computer and run ODIS UPDATE again !!!" > %temp%\TEMPmessage.vbs
REM call %temp%\TEMPmessage.vbs >>%logfile% 2>&1
REM del %temp%\TEMPmessage.vbs /f /q >>%logfile% 2>&1
REM C:\Windows\System32\msg.exe /TIME:99000 /W "%username%" !!! Please REBOOT your Computer and run ODIS UPDATE again !!! >>%logfile% 2>&1
C:\Windows\System32\msg.exe * "!!! Please REBOOT your Computer and run ODIS UPDATE again !!!" >>%logfile% 2>&1
EXIT /B 2

REM #### EXCEPTION ############
:EXCEPTION
call :LOG ###
call :LOG "%time%" "!!! UNKNOWN ERROR ! Contact your Administrator !!!"
REM echo MSGBOX "!!! ERROR - Contact your administrator !!!" > %temp%\TEMPmessage.vbs
REM call %temp%\TEMPmessage.vbs >>%logfile% 2>&1
REM del %temp%\TEMPmessage.vbs /f /q >>%logfile% 2>&1
C:\Windows\System32\msg.exe * "!!! ERROR - Contact your administrator !!!" >>%logfile% 2>&1
EXIT /B 3

REM #### NOADMIN #########
:NOADMIN
call :LOG ###
call :LOG "%time%" "User has no admin rights!"
C:\Windows\System32\msg.exe * "User has no admin rights!" >>%logfile% 2>&1
EXIT /B 4