/*!
 * \file    xm-id.h
 *
 * \brief   Konstanten fr die IDs von Modulen, Interfaces und Operationen.
 *
 * \version 2.0
 * \date    30.11.2007
 *
 * \author  Dr. S. Fischer, gedas deutschland GmbH
 * \author  Dr. M. Tschersich, gedas deutschland GmbH (mts)
 *
 * \hist    \li mts 30.07.2007   Konstanten Id_fnCh_setFilter und Id_fnDev_selfTest
 *                               hinzugefgt
 *          \li mts 30.11.2007   Area-Id fr Inspection (AId_Inspection) hinzugefgt
 */


// ---------- CONSTANTS ----------
//                ==>1234567890123456789012345678901<== max. length 31 characters!!

// IO function
const unsigned short AId_IOInit                      =    5;

// Module xm (externe Messtechnik)
const unsigned short AId_xm                          = 5000;

// interface Device
const unsigned short AId_fnDevice                    = 5100;
const unsigned short Id_fnDev_init                   = 5101;
const unsigned short Id_fnDev_deinit                 = 5102;
const unsigned short Id_fnDev_startWatchdog          = 5103;
const unsigned short Id_fnDev_stopWatchdog           = 5104;
const unsigned short Id_fnDev_getSocketProperties    = 5105;
const unsigned short Id_fnDev_getConnCapability      = 5106;
const unsigned short Id_fnDev_selfTest               = 5107;

// interface Channel
const unsigned short AId_fnChannel                   = 5200;
const unsigned short Id_fnCh_setRange                = 5201;
const unsigned short Id_fnCh_getValue                = 5202;
const unsigned short Id_fnCh_start                   = 5204;
const unsigned short Id_fnCh_stop                    = 5205;
const unsigned short Id_fnCh_calibrate               = 5206;
const unsigned short Id_fnCh_setFilter               = 5207;
const unsigned short Id_fnCh_prepareForDataStream    = 5208;
const unsigned short Id_fnCh_prepareForSingleData    = 5209;
const unsigned short Id_fnCh_finish                  = 5210;

// Constants for Callback
const unsigned short AId_CallBack                    = 9000;
const unsigned short Id_InfReport                    = 9001;
const unsigned short Id_Accept                       = 9002;

// Constants for Inspection
const unsigned short AId_Inspection                  = 9100;
