/*!
 * \file    xm-comm.h
 * \version 2.0.1.0
 * \date    27.07.2020
 * \author  Dr. S. Fischer, gedas deutschland GmbH
 * \author  S. Baumann, rd electronic GmbH (SBa)
 *
 *
 * \hist    \li	2.0.1.0		27.07.2020	SBa		Erstellung
 *
 *
 * \brief   Datentyp fr Kommunikationsparameter.
 */

/*!
 * \brief   Datentyp fr die Kommunikationsparameter.
 *
 * \note    Strukturen zur Untersttzung von TCP-Verbindungen via Adresse bzw. Hostnamen
 */
typedef enum TeEndpointType
{
	// Verbindungsaufbau ber TCP-Server
    eEptTcpName,
	// Verbindungsaufbau ber TCP-Server
    eEptTcpIp4	
	
} TeEndpointType;

typedef struct TTcpName
{
    // Hostname
    A_ASCIISTRING_64	sHostname;
	// Portnummer des TCP-Servers
    A_UINT16			unPort;

}TTcpName;

typedef struct TTcpIp4
{
	// IPv4-Adresse
    A_IP4				tHostAddress;
	// Portnummer des TCP-Servers
    A_UINT16			unPort;

}TTcpIp4;

/*!
 * \brief   Datentyp fuer die Kommunikationsparameter.
 *
 * \note    Der Verbindungsaufbau zu einem direkt mit dem PC verbundenen VAS6558 erfolgt ber die
 *			Portnummer (ucSerialPort). Zum Verbindungsaufbau mit VAS6558-Gerten im Intranet kann
 *			eine IPv4- oder eine IPv6-Adresse verwendet werden.
 */
typedef union TuIoData switch (TeEndpointType)
{
	// Verbindungsdaten zum TCP-Server
    case eEptTcpName	:	TTcpName tTcpName;
	// Verbindungsdaten zum TCP-Server
    case eEptTcpIp4		:	TTcpIp4 tTcpIp4;
		
} TuIoData;
