/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.configurator.IPlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.IConfigurationConstants;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.PlatformConfigurationFactory;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;

public class ConfigurationActivator
implements BundleActivator,
IBundleGroupProvider,
IConfigurationConstants {
    public static String PI_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String LAST_CONFIG_STAMP = "last.config.stamp";
    public static final String NAME_SPACE = "org.eclipse.update";
    public static final String UPDATE_PREFIX = "update@";
    private static final String INITIAL_PREFIX = "initial@";
    public static String OPTION_DEBUG = String.valueOf(PI_CONFIGURATOR) + "/debug";
    public static boolean DEBUG = false;
    private static BundleContext context;
    private ServiceRegistration<IPlatformConfigurationFactory> configurationFactorySR;
    ServiceRegistration<?> bundleGroupProviderSR;
    private PlatformConfiguration configuration;
    private Location configLocation;
    private long lastTimeStamp;
    private long lastStateTimeStamp;
    private static ConfigurationActivator configurator;

    public ConfigurationActivator() {
        configurator = this;
    }

    public void start(BundleContext ctx) throws Exception {
        context = ctx;
        this.loadOptions();
        this.acquireFrameworkLogService();
        try {
            this.initialize();
        }
        catch (Exception e) {
            Utils.shutdown();
            throw e;
        }
        if (this.canRunWithCachedData() || ctx.getProperty("osgi.dev") != null) {
            Utils.debug("Running with cached data");
            this.registerBundleGroupProvider();
            return;
        }
        Utils.debug("Starting update configurator...");
        if (ConfigurationActivator.isReconciling()) {
            this.installBundles();
        }
        this.registerBundleGroupProvider();
    }

    public static boolean isReconciling() {
        String reconcile = context.getProperty("org.eclipse.update.reconcile");
        return reconcile == null || reconcile.equalsIgnoreCase("true");
    }

    private void registerBundleGroupProvider() {
        String serviceName = IBundleGroupProvider.class.getName();
        try {
            ServiceReference[] refs = ConfigurationActivator.getBundleContext().getServiceReferences(serviceName, null);
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    if (PI_CONFIGURATOR.equals(refs[i].getBundle().getSymbolicName())) {
                        return;
                    }
                    ++i;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.bundleGroupProviderSR = ConfigurationActivator.getBundleContext().registerService(serviceName, (Object)this, null);
    }

    private void initialize() throws Exception {
        block18: {
            if (!Utils.isRunning()) {
                throw new Exception(Messages.ConfigurationActivator_initialize);
            }
            this.configLocation = Utils.getConfigurationLocation();
            if (!this.configLocation.isReadOnly()) {
                try {
                    URL privateURL = new URL(this.configLocation.getURL(), NAME_SPACE);
                    File f = new File(privateURL.getFile());
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            this.configurationFactorySR = context.registerService(IPlatformConfigurationFactory.class, (Object)new PlatformConfigurationFactory(), null);
            this.configuration = this.getPlatformConfiguration(Utils.getInstallURL(), this.configLocation);
            if (this.configuration == null) {
                throw Utils.newCoreException(NLS.bind((String)Messages.ConfigurationActivator_createConfig, (Object[])new String[]{this.configLocation.getURL().toExternalForm()}), null);
            }
            FilterInputStream stream = null;
            try {
                try {
                    stream = new DataInputStream(new URL(this.configLocation.getURL(), "org.eclipse.update/last.config.stamp").openStream());
                    this.lastTimeStamp = ((DataInputStream)stream).readLong();
                    this.lastStateTimeStamp = ((DataInputStream)stream).readLong();
                }
                catch (Exception exception) {
                    this.lastTimeStamp = this.configuration.getChangeStamp() - 1L;
                    this.lastStateTimeStamp = -1L;
                    if (stream == null) break block18;
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        Utils.log(e1.getLocalizedMessage());
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        Utils.log(e1.getLocalizedMessage());
                    }
                }
            }
        }
    }

    public void stop(BundleContext ctx) throws Exception {
        try {
            PlatformConfiguration.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.configurationFactorySR.unregister();
        if (this.bundleGroupProviderSR != null) {
            this.bundleGroupProviderSR.unregister();
        }
        Utils.shutdown();
    }

    public boolean installBundles() {
        Utils.debug("Installing bundles...");
        int startLevel = 4;
        String defaultStartLevel = context.getProperty("osgi.bundles.defaultStartLevel");
        if (defaultStartLevel != null) {
            try {
                startLevel = Integer.parseInt(defaultStartLevel);
            }
            catch (NumberFormatException numberFormatException) {
                startLevel = 4;
            }
        }
        if (startLevel < 1) {
            startLevel = 4;
        }
        try {
            Bundle[] bundlesToUninstall;
            Bundle[] cachedBundles = context.getBundles();
            URL[] plugins = this.configuration.getPluginPath();
            List<Bundle> toRefresh = this.getUnresolvedBundles();
            Bundle[] bundleArray = bundlesToUninstall = this.getBundlesToUninstall(cachedBundles, plugins);
            int n = bundlesToUninstall.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                try {
                    if (DEBUG) {
                        Utils.debug("Uninstalling " + b.getLocation());
                    }
                    toRefresh.add(b);
                    b.uninstall();
                }
                catch (Exception exception) {
                    Utils.log(NLS.bind((String)Messages.ConfigurationActivator_uninstallBundle, (Object[])new String[]{b.getLocation()}));
                }
                ++n2;
            }
            String[] bundlesToInstall = this.getBundlesToInstall(cachedBundles, plugins);
            ArrayList<Bundle> lazyActivationBundles = new ArrayList<Bundle>(bundlesToInstall.length);
            String[] stringArray = bundlesToInstall;
            int n3 = bundlesToInstall.length;
            int n4 = 0;
            while (n4 < n3) {
                block21: {
                    String bn = stringArray[n4];
                    try {
                        if (DEBUG) {
                            Utils.debug("Installing " + bn);
                        }
                        URL bundleURL = new URL("reference:file:" + bn);
                        Bundle target = context.installBundle(UPDATE_PREFIX + bn, bundleURL.openStream());
                        toRefresh.add(target);
                        try {
                            BundleStartLevel start = (BundleStartLevel)target.adapt(BundleStartLevel.class);
                            if (start != null) {
                                start.setStartLevel(startLevel);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            Utils.log(String.valueOf(NLS.bind((String)Messages.ConfigurationActivator_installBundle, (Object[])new String[]{bn})) + "   " + e.getMessage());
                        }
                        if (ConfigurationActivator.hasLazyActivationPolicy(target)) {
                            lazyActivationBundles.add(target);
                        }
                    }
                    catch (Exception e) {
                        if (Utils.isAutomaticallyStartedBundle(bn)) break block21;
                        Utils.log(String.valueOf(NLS.bind((String)Messages.ConfigurationActivator_installBundle, (Object[])new String[]{bn})) + "   " + e.getMessage());
                    }
                }
                ++n4;
            }
            this.removeInitialBundles(toRefresh, cachedBundles);
            this.refreshPackages(toRefresh);
            for (Bundle b : lazyActivationBundles) {
                try {
                    b.start(2);
                }
                catch (BundleException e) {
                    if ((b.getState() & 4) == 0) continue;
                    Utils.log(String.valueOf(NLS.bind((String)Messages.ConfigurationActivator_installBundle, (Object[])new String[]{b.getLocation()})) + "   " + e.getMessage());
                }
            }
            this.writePlatformConfigurationTimeStamp();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean hasLazyActivationPolicy(Bundle target) {
        block9: {
            ManifestElement[] elements;
            block10: {
                Dictionary headers;
                block8: {
                    headers = target.getHeaders("");
                    String fragmentHost = (String)headers.get("Fragment-Host");
                    if (fragmentHost != null) {
                        return false;
                    }
                    String activationPolicy = (String)headers.get("Bundle-ActivationPolicy");
                    try {
                        if (activationPolicy == null) break block8;
                        ManifestElement[] elements2 = ManifestElement.parseHeader((String)"Bundle-ActivationPolicy", (String)activationPolicy);
                        if (elements2 != null && elements2.length > 0 && "lazy".equals(elements2[0].getValue())) {
                            return true;
                        }
                        break block9;
                    }
                    catch (BundleException bundleException) {}
                }
                String eclipseLazyStart = (String)headers.get("Eclipse-LazyStart");
                if (eclipseLazyStart == null) {
                    eclipseLazyStart = (String)headers.get("Eclipse-AutoStart");
                }
                if ((elements = ManifestElement.parseHeader((String)"Eclipse-LazyStart", (String)eclipseLazyStart)) == null || elements.length <= 0) break block9;
                if (!"true".equals(elements[0].getValue())) break block10;
                return true;
            }
            if (elements[0].getDirective("exceptions") != null) {
                return true;
            }
        }
        return false;
    }

    private void removeInitialBundles(List<Bundle> bundles, Bundle[] cachedBundles) {
        String[] initialSymbolicNames = this.getInitialSymbolicNames(cachedBundles);
        Iterator<Bundle> iter = bundles.iterator();
        block0: while (iter.hasNext()) {
            String symbolicName = iter.next().getSymbolicName();
            int i = 0;
            while (i < initialSymbolicNames.length) {
                if (initialSymbolicNames[i].equals(symbolicName)) {
                    iter.remove();
                    continue block0;
                }
                ++i;
            }
        }
    }

    private String[] getInitialSymbolicNames(Bundle[] cachedBundles) {
        ArrayList<String> initial = new ArrayList<String>();
        Bundle[] bundleArray = cachedBundles;
        int n = cachedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String symbolicName;
            Bundle bundle = bundleArray[n2];
            if (bundle.getLocation().startsWith(INITIAL_PREFIX) && (symbolicName = bundle.getSymbolicName()) != null) {
                initial.add(symbolicName);
            }
            ++n2;
        }
        return initial.toArray(new String[initial.size()]);
    }

    private List<Bundle> getUnresolvedBundles() {
        Bundle[] allBundles = context.getBundles();
        ArrayList<Bundle> unresolved = new ArrayList<Bundle>();
        Bundle[] bundleArray = allBundles;
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getState() == 2) {
                unresolved.add(b);
            }
            ++n2;
        }
        return unresolved;
    }

    private String[] getBundlesToInstall(Bundle[] cachedBundles, URL[] newPlugins) {
        String location;
        HashSet<String> cachedBundlesSet = new HashSet<String>(cachedBundles.length);
        int offset = UPDATE_PREFIX.length();
        Bundle[] bundleArray = cachedBundles;
        int n = cachedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle cachedBundle = bundleArray[n2];
            if (cachedBundle.getBundleId() != 0L && (location = cachedBundle.getLocation()).startsWith(UPDATE_PREFIX)) {
                location = location.substring(offset);
                cachedBundlesSet.add(location);
                if (Utils.isWindows) {
                    cachedBundlesSet.add(location.toLowerCase());
                }
            }
            ++n2;
        }
        ArrayList<String> bundlesToInstall = new ArrayList<String>(newPlugins.length);
        URL[] uRLArray = newPlugins;
        int n3 = newPlugins.length;
        n = 0;
        while (n < n3) {
            URL u = uRLArray[n];
            location = Utils.makeRelative(Utils.getInstallURL(), u).getFile();
            if (!(cachedBundlesSet.contains(location) || Utils.isWindows && cachedBundlesSet.contains(location.toLowerCase()))) {
                bundlesToInstall.add(location);
            }
            ++n;
        }
        return bundlesToInstall.toArray(new String[bundlesToInstall.size()]);
    }

    private Bundle[] getBundlesToUninstall(Bundle[] cachedBundles, URL[] newPlugins) {
        HashSet<String> newPluginsSet = new HashSet<String>(newPlugins.length);
        int i = 0;
        while (i < newPlugins.length) {
            String pluginLocation = Utils.makeRelative(Utils.getInstallURL(), newPlugins[i]).getFile();
            newPluginsSet.add(pluginLocation);
            if (Utils.isWindows) {
                newPluginsSet.add(pluginLocation.toLowerCase());
            }
            ++i;
        }
        ArrayList<Bundle> bundlesToUninstall = new ArrayList<Bundle>();
        int offset = UPDATE_PREFIX.length();
        Bundle[] bundleArray = cachedBundles;
        int n = cachedBundles.length;
        int n2 = 0;
        while (n2 < n) {
            String location;
            Bundle cachedBundle = bundleArray[n2];
            if (!(cachedBundle.getBundleId() == 0L || !(location = cachedBundle.getLocation()).startsWith(UPDATE_PREFIX) || newPluginsSet.contains(location = location.substring(offset)) || Utils.isWindows && newPluginsSet.contains(location.toLowerCase()))) {
                bundlesToUninstall.add(cachedBundle);
            }
            ++n2;
        }
        return bundlesToUninstall.toArray(new Bundle[bundlesToUninstall.size()]);
    }

    private PlatformConfiguration getPlatformConfiguration(URL installURL, Location configLocation) {
        try {
            PlatformConfiguration.startup(installURL, configLocation);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = "";
            }
            Utils.log(Utils.newStatus(message, e));
        }
        return PlatformConfiguration.getCurrent();
    }

    private void refreshPackages(List<Bundle> bundles) {
        if (bundles == null || bundles.isEmpty()) {
            return;
        }
        FrameworkWiring frameworkWiring = (FrameworkWiring)context.getBundle("System Bundle").adapt(FrameworkWiring.class);
        CountDownLatch latch = new CountDownLatch(1);
        FrameworkListener listener = event -> {
            if (event.getType() == 4) {
                latch.countDown();
            }
        };
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{listener});
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {}
    }

    private void writePlatformConfigurationTimeStamp() {
        FilterOutputStream stream = null;
        try {
            if (this.configLocation.isReadOnly()) {
                return;
            }
            try {
                String configArea = this.configLocation.getURL().getFile();
                this.lastTimeStamp = this.configuration.getChangeStamp();
                this.lastStateTimeStamp = Utils.getStateStamp();
                stream = new DataOutputStream(new FileOutputStream(String.valueOf(configArea) + File.separator + NAME_SPACE + File.separator + LAST_CONFIG_STAMP));
                ((DataOutputStream)stream).writeLong(this.lastTimeStamp);
                ((DataOutputStream)stream).writeLong(this.lastStateTimeStamp);
            }
            catch (Exception e) {
                Utils.log(e.getLocalizedMessage());
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e1) {
                    Utils.log(e1.getLocalizedMessage());
                }
            }
        }
    }

    private void loadOptions() {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class);
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption(OPTION_DEBUG, false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    private boolean canRunWithCachedData() {
        return !"true".equals(context.getProperty("osgi.checkConfiguration")) && this.lastTimeStamp == this.configuration.getChangeStamp() && this.lastStateTimeStamp == Utils.getStateStamp();
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public String getName() {
        return Messages.BundleGroupProvider;
    }

    public IBundleGroup[] getBundleGroups() {
        if (this.configuration == null) {
            return new IBundleGroup[0];
        }
        IPlatformConfiguration.IFeatureEntry[] features = this.configuration.getConfiguredFeatureEntries();
        ArrayList<IBundleGroup> bundleGroups = new ArrayList<IBundleGroup>(features.length);
        IPlatformConfiguration.IFeatureEntry[] iFeatureEntryArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformConfiguration.IFeatureEntry feature = iFeatureEntryArray[n2];
            if (feature instanceof FeatureEntry && ((FeatureEntry)feature).hasBranding()) {
                bundleGroups.add((IBundleGroup)feature);
            }
            ++n2;
        }
        return bundleGroups.toArray(new IBundleGroup[bundleGroups.size()]);
    }

    public static ConfigurationActivator getConfigurator() {
        return configurator;
    }

    private void acquireFrameworkLogService() {
        ServiceReference logServiceReference = context.getServiceReference(FrameworkLog.class);
        if (logServiceReference == null) {
            return;
        }
        Utils.log = (FrameworkLog)context.getService(logServiceReference);
    }
}

