/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.index.ext.rule;

import de.vw.vaudes.diaghook.index.IndicatedElement;
import de.vw.vaudes.diaghook.index.IndicatedTestProgramElement;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.ext.ExtendedDataIndicator;
import de.vw.vaudes.diaghook.index.ext.VaudesObjectDigester;
import de.vw.vaudes.diaghook.index.ext.rule.IExtendedIndicationRule;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestprogramIndicationRule
implements IExtendedIndicationRule {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    @Override
    public void run(Map<String, IndicatedElement> map) throws URISyntaxException {
        Map<URI, List<IndicatedTestProgramElement>> map2 = this.filterTestProgramNodes(map);
        VaudesObjectDigester vaudesObjectDigester = new VaudesObjectDigester();
        for (Map.Entry<URI, List<IndicatedTestProgramElement>> entry : map2.entrySet()) {
            try {
                if (null == entry.getValue().get(0).getInstallationIndexFile()) {
                    for (IndicatedTestProgramElement indicatedTestProgramElement : entry.getValue()) {
                        String string = entry.getKey().toURL().toString() + indicatedTestProgramElement.getFilename();
                        vaudesObjectDigester.run(string);
                        ((IndicatedTestProgramElement)ObjectIndicator.getInstance().getObjectById(indicatedTestProgramElement.getObjectId())).setClassname(vaudesObjectDigester.getClassname());
                    }
                    continue;
                }
                for (IndicatedTestProgramElement indicatedTestProgramElement : entry.getValue()) {
                    try {
                        vaudesObjectDigester.run(ExtendedDataIndicator.resolveFile(entry.getKey().toURL()), indicatedTestProgramElement.getFilename());
                        ((IndicatedTestProgramElement)ObjectIndicator.getInstance().getObjectById(indicatedTestProgramElement.getObjectId())).setClassname(vaudesObjectDigester.getClassname());
                    }
                    catch (Exception exception) {
                        this.fLogger.error((Object)("Error while parsing object " + indicatedTestProgramElement.getFilename()), (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                this.fLogger.error((Object)"error during rule execution", (Throwable)exception);
            }
        }
    }

    private Map<URI, List<IndicatedTestProgramElement>> filterTestProgramNodes(Map<String, IndicatedElement> map) throws URISyntaxException {
        HashMap<URI, List<IndicatedTestProgramElement>> hashMap = new HashMap<URI, List<IndicatedTestProgramElement>>();
        for (Map.Entry<String, IndicatedElement> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof IndicatedTestProgramElement)) continue;
            URI uRI = entry.getValue().getUrl().toURI();
            if (null == hashMap.get(uRI)) {
                ArrayList<IndicatedTestProgramElement> arrayList = new ArrayList<IndicatedTestProgramElement>();
                arrayList.add((IndicatedTestProgramElement)entry.getValue());
                hashMap.put(uRI, arrayList);
                continue;
            }
            ((List)hashMap.get(uRI)).add((IndicatedTestProgramElement)entry.getValue());
        }
        return hashMap;
    }
}

