/*
 * Decompiled with CFR 0.152.
 */
package de.vw.vaudes.diaghook.factory;

import de.volkswagen.odis.vaudas.core.exception.OdisBaseException;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDocumentLink;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IDocumentRepository;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IHotSpot;
import de.volkswagen.odis.vaudas.domainmodel.gfs.bean.IVariantRuleChecker;
import de.volkswagen.odis.vaudas.domainmodel.gfs.factory.IDocumentLinkFactory;
import de.vw.vaudes.diaghook.da.NonUniqueResultException;
import de.vw.vaudes.diaghook.index.ObjectIndicator;
import de.vw.vaudes.diaghook.index.db.DatabaseResolver;
import de.vw.vaudes.diaghook.transform.DbgHookTransformHelper;
import de.vw.vaudes.diaghook.transform.DocumentTransformHelper;
import de.vw.vaudes.diaghook.util.DiagnosticDataAccessHelper;
import de.vw.vaudes.diaghook.util.Validate;
import de.vw.vaudes.xml.object.VAUDESObjekt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DocumentLinkFactoryImpl
implements IDocumentLinkFactory {
    private final Log fLogger = LogFactory.getLog(this.getClass());

    public IDocumentLink getDocLink(String string, IDocumentLink iDocumentLink) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getDocLink(" + string + ", " + iDocumentLink + ")"));
        }
        boolean bl = iDocumentLink != null;
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iDocumentLink));
                }
                return iDocumentLink;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            IDocumentLink iDocumentLink2 = DocumentTransformHelper.createSupplementaryDocument(vAUDESObjekt);
            if (null != iDocumentLink2) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return new " + iDocumentLink2));
                }
                return iDocumentLink2;
            }
            if (bl) {
                if (this.fLogger.isDebugEnabled()) {
                    this.fLogger.debug((Object)("return " + iDocumentLink));
                }
                return iDocumentLink;
            }
            throw DbgHookTransformHelper.createOdisBaseException(string);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error while transforming object id " + string), (Throwable)exception);
            if (null == iDocumentLink) {
                throw DbgHookTransformHelper.createOdisBaseException(string);
            }
            return iDocumentLink;
        }
    }

    public List<IDocumentLink> getDocLinks(String string, IVariantRuleChecker iVariantRuleChecker, List<IDocumentLink> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getDocLinks(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IDocumentLink>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(DocumentTransformHelper.transformSupplementaryDocumentFromDiagObject(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error while transforming object id " + string), (Throwable)exception);
            return list;
        }
    }

    public List<IHotSpot> getHotSpots(String string, List<IHotSpot> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getHotSpots(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IHotSpot>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(DocumentTransformHelper.transformHotspots(vAUDESObjekt));
            for (IHotSpot iHotSpot : list) {
                IDocumentLink iDocumentLink = iHotSpot.getDocLink();
                if (iDocumentLink == null || iDocumentLink.getDocFormat() != 2) continue;
                String string2 = iDocumentLink.getDocumentLinkKey();
                this.getParallelDocLinks(string2, iHotSpot.getDocLink().getParallelDocs());
            }
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error while transforming object id " + string), (Throwable)exception);
            return list;
        }
    }

    public List<IDocumentLink> getParallelDocLinks(String string, List<IDocumentLink> list) throws OdisBaseException {
        Validate.notNull(string);
        Validate.notEmpty(string);
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getParallelDocLinks(" + string + ", " + list + ")"));
        }
        if (null == list) {
            list = new ArrayList<IDocumentLink>();
        }
        Object object = null;
        try {
            object = DiagnosticDataAccessHelper.parseFile(string, VAUDESObjekt.class);
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            throw DbgHookTransformHelper.createOdisBaseException(nonUniqueResultException);
        }
        catch (Exception exception) {
            this.fLogger.error((Object)("Error occurred while parsing object with id " + string + " from index"), (Throwable)exception);
        }
        if (!(object instanceof VAUDESObjekt)) {
            return list;
        }
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"found requested object in index");
        }
        VAUDESObjekt vAUDESObjekt = (VAUDESObjekt)object;
        try {
            list.clear();
            list.addAll(DocumentTransformHelper.getParallelDocLinks(vAUDESObjekt));
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)("return new " + list));
            }
            return list;
        }
        catch (Exception exception) {
            return list;
        }
    }

    public IDocumentLink getDocLinkByVaudesObjectId(String string, IDocumentLink iDocumentLink) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)"getDocLinkByVaudesObjectId called ...");
        }
        return this.getDocLink(string, iDocumentLink);
    }

    public List<? extends IDocumentRepository> getDocumentRepositories(String string, List<? extends IDocumentRepository> list) throws OdisBaseException {
        if (this.fLogger.isDebugEnabled()) {
            this.fLogger.debug((Object)("getDocumentRepositories(" + string + ", " + list + ")"));
        }
        if (null == list) {
            if (this.fLogger.isDebugEnabled()) {
                this.fLogger.debug((Object)"getDocumentRepositories returns empty list.");
            }
            return Collections.EMPTY_LIST;
        }
        List<? extends IDocumentRepository> list2 = list;
        for (IDocumentRepository iDocumentRepository : list2) {
            if (!this.isDocLinkInHotfixOrAtp(iDocumentRepository.getDocumentLinkKey())) continue;
            iDocumentRepository.setJarPath(null);
            if (!this.fLogger.isDebugEnabled()) continue;
            this.fLogger.debug((Object)("getDocumentRepositories: setting jarpath == null for  " + iDocumentRepository.getDocumentLinkKey()));
        }
        return list2;
    }

    private boolean isDocLinkInHotfixOrAtp(String string) {
        return string != null && (ObjectIndicator.getInstance().getObjectByIdOrSysName(string) != null || DatabaseResolver.getInstance().objectCached(string));
    }
}

